/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.api.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;

public class InventoryHelper {
    public static boolean mcdw$hasItem(Player playerEntity, Item item) {
        return InventoryHelper.mcdw$hasItem(playerEntity, item, 1);
    }

    public static boolean mcdw$hasItem(Player playerEntity, Item item, int count) {
        return InventoryHelper.mcdw$countItem(playerEntity, item) >= count;
    }

    public static int mcdw$countItem(Player playerEntity, Item item) {
        Inventory playerInventory = playerEntity.m_150109_();
        int count = 0;
        for (int slotID = 0; slotID < playerInventory.m_6643_(); ++slotID) {
            ItemStack currentStack = playerInventory.m_8020_(slotID);
            if (currentStack.m_41720_() != item) continue;
            count += currentStack.m_41613_();
        }
        return count;
    }

    public static void mcdw$systematicReplace(Player player, Item toReplace, Item replaceTo, int count) {
        Inventory playerInv = player.m_150109_();
        playerInv.m_36030_(new ItemStack((ItemLike)toReplace));
        if (playerInv.m_36062_() >= 0) {
            int hasToReplace = InventoryHelper.mcdw$countItem(player, toReplace);
            if (hasToReplace < count) {
                InventoryHelper.mcdw$systematicReplace(player, toReplace, replaceTo, hasToReplace);
                return;
            }
            List<Integer> emptySlots = InventoryHelper.mcdw$getAllEmptySlots(player);
            for (Integer slotIndex : emptySlots) {
                if (count <= 0) break;
                count = InventoryHelper.mcdw$switchOutItems(player, toReplace, replaceTo, count, slotIndex);
            }
            if (count > 0) {
                InventoryHelper.mcdw$systematicReplace(player, toReplace, replaceTo, count);
            }
        } else {
            InventoryHelper.mcdw$replaceWithoutEmptySlots(player, toReplace, replaceTo, count);
        }
    }

    public static void mcdw$systematicReplacePotions(Player player, Item toReplace, Potion potionReplaceTo, int count) {
        Inventory playerInv = player.m_150109_();
        List<Integer> stackSlots = InventoryHelper.mcdw$getSlotsWithStack(player, toReplace);
        record SlotInfo(int index, int size) {
        }
        ArrayList<SlotInfo> toReplaceSlots = new ArrayList<SlotInfo>();
        for (int slotIndex : stackSlots) {
            toReplaceSlots.add(new SlotInfo(slotIndex, playerInv.m_8020_(slotIndex).m_41613_()));
        }
        ItemStack offhand = playerInv.m_8020_(40);
        if (offhand.m_150930_(toReplace)) {
            toReplaceSlots.add(new SlotInfo(40, offhand.m_41613_()));
        }
        toReplaceSlots.sort(Comparator.comparingInt(a -> a.size));
        while (count > 0 && !toReplaceSlots.isEmpty()) {
            SlotInfo slot = (SlotInfo)toReplaceSlots.get(0);
            ItemStack stackReplaceTo = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potionReplaceTo);
            if (slot.size == 1) {
                playerInv.m_6836_(slot.index, stackReplaceTo);
                toReplaceSlots.remove(0);
            } else {
                int emptySlot = playerInv.m_36062_();
                if (emptySlot == -1) break;
                playerInv.m_8020_(slot.index).m_41774_(1);
                playerInv.m_6836_(emptySlot, stackReplaceTo);
                toReplaceSlots.set(0, new SlotInfo(slot.index, slot.size - 1));
            }
            --count;
        }
    }

    private static void mcdw$replaceWithoutEmptySlots(Player player, Item toReplace, Item replaceTo, int count) {
        Inventory playerInv = player.m_150109_();
        int ogCount = count;
        List<Integer> stackSlots = InventoryHelper.mcdw$getSlotsWithStack(player, toReplace);
        for (int slotIndex : stackSlots) {
            int availableToReplace = playerInv.m_8020_(slotIndex).m_41613_();
            if (availableToReplace > count) continue;
            playerInv.m_36040_(slotIndex, new ItemStack((ItemLike)replaceTo, availableToReplace));
            InventoryHelper.mcdw$switchOutItems(player, toReplace, replaceTo, count -= availableToReplace, slotIndex);
        }
        if (count == ogCount) {
            InventoryHelper.mcdw$optimizeSortItemStack(player, toReplace);
            InventoryHelper.mcdw$replaceWithoutEmptySlots(player, toReplace, replaceTo, count);
        }
    }

    private static void mcdw$optimizeSortItemStack(Player player, Item toReplace) {
        Inventory playerInv = player.m_150109_();
        List<Integer> stackSlots = InventoryHelper.mcdw$getSlotsWithStack(player, toReplace);
        int slotTakingFromIndex = 0;
        for (int i = 1; i < stackSlots.size(); ++i) {
            int slotTakingFrom = stackSlots.get(slotTakingFromIndex);
            int availableToTake = playerInv.m_8020_(slotTakingFrom).m_41613_();
            if (availableToTake == 0) {
                ++slotTakingFromIndex;
            }
            int slotToReplaceTo = stackSlots.get(i);
            int alreadyInSlotToReplaceTo = playerInv.m_8020_(slotToReplaceTo).m_41613_();
            int missingFromMax = toReplace.m_41459_() - alreadyInSlotToReplaceTo;
            int j = Math.min(missingFromMax, availableToTake);
            playerInv.m_7407_(slotTakingFrom, j);
            playerInv.m_36040_(slotToReplaceTo, new ItemStack((ItemLike)toReplace, j));
        }
    }

    public static int mcdw$switchOutItems(Player player, Item toReplace, Item replaceTo, int count, int slotIndex) {
        Inventory playerInv = player.m_150109_();
        int replaceAmount = replaceTo.m_41459_();
        if (count > 0) {
            int k = playerInv.m_36030_(new ItemStack((ItemLike)toReplace));
            int availableToReplace = playerInv.m_8020_(k).m_41613_();
            int j = Math.min(replaceAmount, availableToReplace);
            playerInv.m_36040_(slotIndex, new ItemStack((ItemLike)replaceTo, j));
            playerInv.m_7407_(k, j);
            count -= j;
            int h = replaceAmount - playerInv.m_8020_(slotIndex).m_41613_();
            if (h > 0) {
                count = InventoryHelper.mcdw$switchOutItems(player, toReplace, replaceTo, count, slotIndex);
                return count;
            }
        }
        return count;
    }

    public static List<Integer> mcdw$getAllEmptySlots(Player player) {
        ArrayList<Integer> emptySlots = new ArrayList<Integer>();
        Inventory playerInv = player.m_150109_();
        for (int i = 0; i < playerInv.f_35974_.size(); ++i) {
            if (!((ItemStack)playerInv.f_35974_.get(i)).m_41619_()) continue;
            emptySlots.add(i);
        }
        return emptySlots;
    }

    public static List<Integer> mcdw$getSlotsWithStack(Player player, Item toReplace) {
        Inventory playerInv = player.m_150109_();
        ArrayList<Integer> stackSlots = new ArrayList<Integer>();
        for (int i = 0; i < playerInv.f_35974_.size(); ++i) {
            if (((ItemStack)playerInv.f_35974_.get(i)).m_41619_() || !ItemStack.m_150942_((ItemStack)new ItemStack((ItemLike)toReplace), (ItemStack)playerInv.m_8020_(i))) continue;
            stackSlots.add(i);
        }
        return stackSlots;
    }

    public static void mcdw$deductAmountOfItem(Player player, Item toTake, int amount) {
        List<Integer> stackSlots = InventoryHelper.mcdw$getSlotsWithStack(player, toTake);
        amount = Math.min(amount, InventoryHelper.mcdw$countItem(player, toTake));
        for (Integer stackSlot : stackSlots) {
            ItemStack slot = player.m_150109_().m_8020_(stackSlot.intValue());
            int k = Math.min(slot.m_41613_(), amount);
            slot.m_41774_(k);
            if ((amount -= k) != 0) continue;
            break;
        }
    }
}

