/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.api.util;

import chronosacaria.mcdw.api.interfaces.IDualWielding;
import chronosacaria.mcdw.api.interfaces.IOffhandAttack;
import chronosacaria.mcdw.api.util.AOEHelper;
import chronosacaria.mcdw.api.util.AbilityHelper;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.configs.CompatibilityFlags;
import chronosacaria.mcdw.enums.DaggersID;
import chronosacaria.mcdw.enums.SicklesID;
import chronosacaria.mcdw.registries.EntityAttributesRegistry;
import chronosacaria.mcdw.registries.ParticlesRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.SweepingEdgeEnchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PlayerAttackHelper {
    public static boolean mcdw$isLikelyNotMeleeDamage(DamageSource damageSource) {
        return damageSource.m_276093_(DamageTypes.f_268468_) || damageSource.m_276093_(DamageTypes.f_268565_) || damageSource.m_276093_(DamageTypes.f_268515_) || damageSource.m_276093_(DamageTypes.f_268739_) || !PlayerAttackHelper.mcdw$isDirectDamage(damageSource);
    }

    private static boolean mcdw$isDirectDamage(DamageSource damageSource) {
        return damageSource.m_276093_(DamageTypes.f_268566_) || damageSource.m_276093_(DamageTypes.f_268464_);
    }

    public static void mcdw$switchModifiers(Player player, ItemStack switchFrom, ItemStack switchTo) {
        player.m_21204_().m_22161_(switchFrom.m_41638_(EquipmentSlot.MAINHAND));
        player.m_21204_().m_22178_(switchTo.m_41638_(EquipmentSlot.MAINHAND));
    }

    public static void mcdw$offhandAttack(Player playerEntity, Entity target) {
        if (CompatibilityFlags.noOffhandConflicts) {
            MobType mobType;
            if (!target.m_6097_() && target.m_7313_((Entity)playerEntity)) {
                return;
            }
            ItemStack offhandStack = playerEntity.m_21206_();
            PlayerAttackHelper.mcdw$switchModifiers(playerEntity, playerEntity.m_21205_(), offhandStack);
            float cooldownProgress = ((IDualWielding)playerEntity).mcdw$getOffhandAttackCooldownProgress(0.5f);
            float attackDamage = (float)playerEntity.m_21133_(Attributes.f_22281_);
            attackDamage *= (float)((double)0.2f + Math.pow(cooldownProgress, 2.0) * (double)0.8f);
            PlayerAttackHelper.mcdw$switchModifiers(playerEntity, offhandStack, playerEntity.m_21205_());
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                mobType = livingTarget.m_6336_();
            } else {
                mobType = MobType.f_21640_;
            }
            float enchantBonusDamage = EnchantmentHelper.m_44833_((ItemStack)offhandStack, (MobType)mobType) * cooldownProgress;
            ((IDualWielding)playerEntity).mcdw$resetLastAttackedOffhandTicks();
            if (attackDamage > 0.0f || enchantBonusDamage > 0.0f) {
                boolean playerShouldCrit;
                boolean isMostlyCharged = cooldownProgress > 0.9f;
                int knockbackLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)offhandStack);
                if (playerEntity.m_20142_() && isMostlyCharged) {
                    CleanlinessHelper.playCenteredSound((LivingEntity)playerEntity, SoundEvents.f_12314_, 1.0f, 1.0f);
                    ++knockbackLevel;
                }
                boolean bl = playerShouldCrit = isMostlyCharged && AbilityHelper.entityCanCrit((LivingEntity)playerEntity) && target instanceof LivingEntity;
                if (playerShouldCrit && !playerEntity.m_20142_()) {
                    attackDamage *= 1.5f;
                }
                attackDamage += enchantBonusDamage;
                boolean playerShouldSweep = isMostlyCharged && !playerShouldCrit && !playerEntity.m_20142_() && playerEntity.m_20096_() && (double)(playerEntity.f_19787_ - playerEntity.f_19867_) < (double)playerEntity.m_6113_() && offhandStack.m_41720_() instanceof IOffhandAttack;
                float targetHealth = 0.0f;
                boolean bl5 = false;
                int fireAspectLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)offhandStack);
                if (target instanceof LivingEntity) {
                    LivingEntity livingTarget = (LivingEntity)target;
                    targetHealth = livingTarget.m_21223_();
                    if (fireAspectLevel > 0 && !livingTarget.m_6060_()) {
                        bl5 = true;
                        livingTarget.m_20254_(1);
                    }
                }
                Vec3 targetVelocity = target.m_20184_();
                if (target.m_6469_(target.m_9236_().m_269111_().m_269075_(playerEntity), attackDamage)) {
                    LivingEntity livingTarget;
                    LivingEntity livingTarget2;
                    double positionOne = -Mth.m_14031_((float)(playerEntity.m_146908_() * ((float)Math.PI / 180)));
                    double positionTwo = Mth.m_14089_((float)(playerEntity.m_146908_() * ((float)Math.PI / 180)));
                    if (knockbackLevel > 0) {
                        if (target instanceof LivingEntity) {
                            livingTarget2 = (LivingEntity)target;
                            livingTarget2.m_147240_((double)((float)knockbackLevel * 0.5f), -positionOne, -positionTwo);
                        } else {
                            target.m_5997_(positionOne * (double)knockbackLevel * 0.5, 0.1, positionTwo * (double)knockbackLevel * 0.5);
                        }
                        playerEntity.m_20256_(playerEntity.m_20184_().m_82542_(0.6, 1.0, 0.6));
                        playerEntity.m_6858_(false);
                    }
                    if (playerShouldSweep) {
                        float sweepingEdgeMultiplierTimesDamage = 1.0f + SweepingEdgeEnchantment.m_45193_((int)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44983_, (ItemStack)offhandStack)) * attackDamage;
                        playerEntity.m_9236_().m_45976_(LivingEntity.class, target.m_20191_().m_82377_(1.0, 0.25, 1.0)).forEach(sweptEntity -> {
                            if (AOEHelper.satisfySweepConditions((LivingEntity)playerEntity, target, sweptEntity, 3.0f)) {
                                sweptEntity.m_147240_((double)0.4f, -positionOne, -positionTwo);
                                sweptEntity.m_6469_(sweptEntity.m_9236_().m_269111_().m_269075_(playerEntity), sweepingEdgeMultiplierTimesDamage);
                            }
                        });
                        CleanlinessHelper.playCenteredSound((LivingEntity)playerEntity, SoundEvents.f_12317_, 1.0f, 1.0f);
                        Level level = playerEntity.m_9236_();
                        if (level instanceof ServerLevel) {
                            ServerLevel serverWorld = (ServerLevel)level;
                            serverWorld.m_8767_((ParticleOptions)ParticlesRegistry.OFFHAND_SWEEP_PARTICLE, playerEntity.m_20185_() + positionOne, playerEntity.m_20227_(0.5), playerEntity.m_20189_() + positionTwo, 0, positionOne, 0.0, positionTwo, 0.0);
                        }
                    }
                    if (target instanceof ServerPlayer && target.f_19864_) {
                        ((ServerPlayer)target).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(target));
                        target.f_19864_ = false;
                        target.m_20256_(targetVelocity);
                    }
                    if (playerShouldCrit) {
                        CleanlinessHelper.playCenteredSound((LivingEntity)playerEntity, SoundEvents.f_12313_, 1.0f, 1.0f);
                        playerEntity.m_5704_(target);
                    } else if (!playerShouldSweep) {
                        CleanlinessHelper.playCenteredSound((LivingEntity)playerEntity, isMostlyCharged ? SoundEvents.f_12316_ : SoundEvents.f_12318_, 1.0f, 1.0f);
                    }
                    if (enchantBonusDamage > 0.0f) {
                        playerEntity.m_5700_(target);
                    }
                    playerEntity.m_21335_(target);
                    if (target instanceof LivingEntity) {
                        livingTarget2 = (LivingEntity)target;
                        EnchantmentHelper.m_44823_((LivingEntity)livingTarget2, (Entity)playerEntity);
                    }
                    EnchantmentHelper.m_44896_((LivingEntity)playerEntity, (Entity)target);
                    Entity targetedEntity = target;
                    if (target instanceof EnderDragonPart) {
                        EnderDragonPart enderDragonPartTarget = (EnderDragonPart)target;
                        targetedEntity = enderDragonPartTarget.f_31010_;
                    }
                    if (!playerEntity.m_9236_().f_46443_ && !offhandStack.m_41619_() && targetedEntity instanceof LivingEntity) {
                        livingTarget = (LivingEntity)targetedEntity;
                        offhandStack.m_41640_(livingTarget, playerEntity);
                        if (offhandStack.m_41619_()) {
                            playerEntity.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
                        }
                    }
                    if (target instanceof LivingEntity) {
                        Level level;
                        livingTarget = (LivingEntity)target;
                        float targetCurrentHealth = targetHealth - livingTarget.m_21223_();
                        playerEntity.m_36222_(Stats.f_12928_, Math.round(targetCurrentHealth * 10.0f));
                        if (fireAspectLevel > 0) {
                            target.m_20254_(fireAspectLevel * 4);
                        }
                        if ((level = playerEntity.m_9236_()) instanceof ServerLevel) {
                            ServerLevel playerServerWorld = (ServerLevel)level;
                            if (targetCurrentHealth > 2.0f) {
                                int particleCount = (int)((double)targetCurrentHealth * 0.5);
                                playerServerWorld.m_8767_((ParticleOptions)ParticleTypes.f_123798_, target.m_20185_(), target.m_20227_(0.5), target.m_20189_(), particleCount, 0.1, 0.0, 0.1, 0.2);
                            }
                        }
                    }
                    playerEntity.m_36399_(0.1f);
                } else {
                    CleanlinessHelper.playCenteredSound((LivingEntity)playerEntity, SoundEvents.f_12315_, 1.0f, 1.0f);
                    if (bl5) {
                        target.m_20095_();
                    }
                }
            }
        }
    }

    public static boolean mixAndMatchWeapons(Player playerEntity) {
        return playerEntity.m_21206_().m_150930_(playerEntity.m_21205_().m_41720_()) || playerEntity.m_21205_().m_150930_((Item)DaggersID.DAGGER_THE_BEGINNING.getItem()) && playerEntity.m_21206_().m_150930_((Item)DaggersID.DAGGER_THE_END.getItem()) || playerEntity.m_21205_().m_150930_((Item)DaggersID.DAGGER_THE_END.getItem()) && playerEntity.m_21206_().m_150930_((Item)DaggersID.DAGGER_THE_BEGINNING.getItem()) || playerEntity.m_21205_().m_150930_((Item)SicklesID.SICKLE_LAST_LAUGH_GOLD.getItem()) && playerEntity.m_21206_().m_150930_((Item)SicklesID.SICKLE_LAST_LAUGH_SILVER.getItem()) || playerEntity.m_21205_().m_150930_((Item)SicklesID.SICKLE_LAST_LAUGH_SILVER.getItem()) && playerEntity.m_21206_().m_150930_((Item)SicklesID.SICKLE_LAST_LAUGH_GOLD.getItem());
    }

    public static double mcdw$getReachDistance(LivingEntity livingEntity, double defaultReachDistance) {
        @Nullable AttributeInstance reachDistance = livingEntity.m_21051_(EntityAttributesRegistry.REACH);
        return reachDistance != null ? defaultReachDistance + reachDistance.m_22135_() : defaultReachDistance;
    }

    public static double mcdw$getSquaredReachDistance(LivingEntity livingEntity, double squareDefaultReachDistance) {
        double reachDistance = PlayerAttackHelper.mcdw$getReachDistance(livingEntity, Math.sqrt(squareDefaultReachDistance));
        return reachDistance * reachDistance;
    }

    public static double mcdw$getAttackRange(LivingEntity livingEntity, double defaultAttackRange) {
        @Nullable AttributeInstance attackRange = livingEntity.m_21051_(EntityAttributesRegistry.ATTACK_RANGE);
        return attackRange != null ? defaultAttackRange + attackRange.m_22135_() : defaultAttackRange;
    }

    public static double mcdw$getSquaredAttackRange(LivingEntity livingEntity, double squareDefaultAttackRange) {
        double attackRange = PlayerAttackHelper.mcdw$getAttackRange(livingEntity, Math.sqrt(squareDefaultAttackRange));
        return attackRange * attackRange;
    }

    public static List<Player> mcdw$getPlayerEntitiesWithinReach(Level world, int x, int y, int z, double defaultReachDistance) {
        return PlayerAttackHelper.mcdw$getPlayerEntitiesWithinReach(player -> true, world, x, y, z, defaultReachDistance);
    }

    public static List<Player> mcdw$getPlayerEntitiesWithinReach(Predicate<Player> viewerPredicate, Level world, int x, int y, int z, double defaultReachDistance) {
        ArrayList<Player> playerEntitiesWithinReach = new ArrayList<Player>();
        for (Player playerEntity : world.m_6907_()) {
            double dz;
            double dy;
            if (!viewerPredicate.test(playerEntity)) continue;
            double reach = PlayerAttackHelper.mcdw$getReachDistance((LivingEntity)playerEntity, defaultReachDistance);
            double dx = (double)x + 0.5 - playerEntity.m_20185_();
            if (!(dx * dx + (dy = (double)y + 0.5 - playerEntity.m_20188_()) * dy + (dz = (double)z + 0.5 - playerEntity.m_20189_()) * dz <= reach * reach)) continue;
            playerEntitiesWithinReach.add(playerEntity);
        }
        return playerEntitiesWithinReach;
    }

    public static boolean mcdw$isEntityWithinAttackRange(Player playerEntity, Entity entity) {
        return playerEntity.m_20280_(entity) <= PlayerAttackHelper.mcdw$getSquaredAttackRange((LivingEntity)playerEntity, 64.0);
    }
}

