/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.api.util;

import chronosacaria.mcdw.bases.McdwBow;
import chronosacaria.mcdw.bases.McdwCrossbow;
import chronosacaria.mcdw.bases.McdwShortbow;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class RangedAttackHelper {
    public static float getVanillaArrowVelocity(ItemStack stack, int charge) {
        float bowChargeTime = RangedAttackHelper.getVanillaBowChargeTime(stack);
        if (bowChargeTime <= 0.0f) {
            bowChargeTime = 1.0f;
        }
        float arrowVelocity = (float)charge / bowChargeTime;
        arrowVelocity = (arrowVelocity * arrowVelocity + arrowVelocity * 2.0f) / 3.0f;
        return Math.min(arrowVelocity, 1.0f);
    }

    public static float getVanillaBowChargeTime(ItemStack stack) {
        int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        float bowChargeTime = 30.0f * Math.max(20.0f - (float)(5 * quickChargeLevel), 0.0f);
        long lastFiredtime = (long)(McdwBow.m_40661_((int)22) * Math.max(20.0f - (float)(5 * quickChargeLevel), 0.0f));
        if (lastFiredtime > 0L) {
            return Math.max(bowChargeTime - (float)(5 * quickChargeLevel), 0.0f);
        }
        return Math.max(20.0f - (float)(5 * quickChargeLevel), 0.0f);
    }

    public static float getShortBowChargeTime(ItemStack stack) {
        int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        float bowChargeTime = 15.0f * Math.max(10.0f - (float)(5 * quickChargeLevel), 0.0f);
        long lastFiredtime = (long)(McdwShortbow.m_40661_((int)11) * Math.max(10.0f - (float)(5 * quickChargeLevel), 0.0f));
        if (lastFiredtime > 0L) {
            return Math.max(bowChargeTime - (float)(5 * quickChargeLevel), 0.0f);
        }
        return Math.max(10.0f - (float)(5 * quickChargeLevel), 0.0f);
    }

    public static float getVanillaOrModdedCrossbowArrowVelocity(ItemStack stack) {
        float arrowVelocity;
        Item item = stack.m_41720_();
        if (item instanceof McdwCrossbow) {
            McdwCrossbow mcdwCrossbow = (McdwCrossbow)item;
            arrowVelocity = mcdwCrossbow.getProjectileVelocity(stack);
        } else {
            arrowVelocity = CrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 1.6f : 3.15f;
        }
        return arrowVelocity;
    }

    public static float getVanillaOrModdedBowArrowVelocity(ItemStack stack, int charge) {
        float arrowVelocity = stack.m_41720_() instanceof McdwBow ? McdwBow.getBowArrowVelocity(stack, charge) : RangedAttackHelper.getVanillaArrowVelocity(stack, charge);
        return arrowVelocity;
    }
}

