/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.bases;

import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.api.util.RarityHelper;
import chronosacaria.mcdw.enums.CrossbowsID;
import chronosacaria.mcdw.registries.ItemGroupRegistry;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class McdwCrossbow
extends CrossbowItem
implements IInnateEnchantment {
    public final Tier material;
    public final int drawSpeed;
    public final float range;
    String[] repairIngredient;
    CrossbowsID crossbowsEnum;

    public McdwCrossbow(CrossbowsID crossbowsEnum, Tier material, int drawSpeed, float range, String[] repairIngredient) {
        super(new Item.Properties().m_41487_(1).m_41503_(100 + material.m_6609_()).m_41497_(RarityHelper.fromToolMaterial(material)));
        this.crossbowsEnum = crossbowsEnum;
        ItemGroupEvents.modifyEntriesEvent(ItemGroupRegistry.RANGED).register(entries -> entries.m_246342_(this.m_7968_()));
        this.material = material;
        this.drawSpeed = drawSpeed;
        this.range = range;
        this.repairIngredient = repairIngredient;
    }

    public float getProjectileVelocity(ItemStack stack) {
        return McdwCrossbow.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 1.6f : 3.2f;
    }

    public int m_6615_() {
        return (int)this.range;
    }

    public int m_6473_() {
        return this.material.m_6601_();
    }

    public boolean m_6832_(ItemStack stack, ItemStack ingredient) {
        return CleanlinessHelper.canRepairCheck(this.repairIngredient, ingredient);
    }

    public int getDrawSpeed() {
        return this.drawSpeed;
    }

    public ItemStack m_7968_() {
        return this.getInnateEnchantedStack((Item)this);
    }

    @Override
    public Map<Enchantment, Integer> getInnateEnchantments() {
        if (this.crossbowsEnum.getIsEnabled()) {
            return this.crossbowsEnum.getInnateEnchantments();
        }
        return Map.of();
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        super.m_7373_(stack, world, tooltip, tooltipContext);
        CleanlinessHelper.mcdw$tooltipHelper(stack, tooltip, 19);
    }
}

