/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.bases;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.api.util.RarityHelper;
import chronosacaria.mcdw.configs.CompatibilityFlags;
import chronosacaria.mcdw.enums.GlaivesID;
import chronosacaria.mcdw.registries.EntityAttributesRegistry;
import chronosacaria.mcdw.registries.ItemGroupRegistry;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class McdwGlaive
extends SwordItem
implements IInnateEnchantment {
    String[] repairIngredient;
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;
    private final Tier material;
    private final float attackDamage;
    GlaivesID glaivesEnum;

    public McdwGlaive(GlaivesID glaivesEnum, Tier material, int attackDamage, float attackSpeed, String[] repairIngredient) {
        super(material, attackDamage, attackSpeed, new Item.Properties().m_41497_(RarityHelper.fromToolMaterial(material)));
        this.glaivesEnum = glaivesEnum;
        ItemGroupEvents.modifyEntriesEvent(ItemGroupRegistry.MELEE).register(entries -> entries.m_246342_(this.m_7968_()));
        this.material = material;
        this.attackDamage = (float)attackDamage + material.m_6631_();
        this.repairIngredient = repairIngredient;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)attackSpeed, AttributeModifier.Operation.ADDITION));
        if (FabricLoader.getInstance().isModLoaded("reach-entity-attributes") && CompatibilityFlags.isReachExtensionEnabled) {
            Objects.requireNonNull(Mcdw.CONFIG.mcdwNewStatsConfig);
            builder.put((Object)ReachEntityAttributes.REACH, (Object)new AttributeModifier("Attack range", 1.0, AttributeModifier.Operation.ADDITION));
            Objects.requireNonNull(Mcdw.CONFIG.mcdwNewStatsConfig);
            builder.put((Object)ReachEntityAttributes.ATTACK_RANGE, (Object)new AttributeModifier("Attack range", 1.0, AttributeModifier.Operation.ADDITION));
        } else if (CompatibilityFlags.isReachExtensionEnabled) {
            Objects.requireNonNull(Mcdw.CONFIG.mcdwNewStatsConfig);
            builder.put((Object)EntityAttributesRegistry.ATTACK_RANGE, (Object)new AttributeModifier("Attack range", 1.0, AttributeModifier.Operation.ADDITION));
        }
        this.attributeModifiers = builder.build();
    }

    public Tier m_43314_() {
        return this.material;
    }

    public int m_6473_() {
        return this.material.m_6601_();
    }

    public float m_43299_() {
        return this.attackDamage;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(equipmentSlot);
    }

    public boolean m_6832_(ItemStack stack, ItemStack ingredient) {
        return CleanlinessHelper.canRepairCheck(this.repairIngredient, ingredient);
    }

    public ItemStack m_7968_() {
        return this.getInnateEnchantedStack((Item)this);
    }

    @Override
    public Map<Enchantment, Integer> getInnateEnchantments() {
        if (this.glaivesEnum.getIsEnabled()) {
            return this.glaivesEnum.getInnateEnchantments();
        }
        return Map.of();
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        super.m_7373_(stack, world, tooltip, tooltipContext);
        CleanlinessHelper.mcdw$tooltipHelper(stack, tooltip, 17);
    }
}

