/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.bases;

import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.api.util.RarityHelper;
import chronosacaria.mcdw.enums.HammersID;
import chronosacaria.mcdw.registries.ItemGroupRegistry;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class McdwHammer
extends AxeItem
implements IInnateEnchantment {
    String[] repairIngredient;
    HammersID hammersEnum;

    public McdwHammer(HammersID hammersEnum, Tier material, int attackDamage, float attackSpeed, String[] repairIngredient) {
        super(material, (float)attackDamage, attackSpeed, new Item.Properties().m_41497_(RarityHelper.fromToolMaterial(material)));
        this.hammersEnum = hammersEnum;
        ItemGroupEvents.modifyEntriesEvent(ItemGroupRegistry.MELEE).register(entries -> entries.m_246342_(this.m_7968_()));
        this.repairIngredient = repairIngredient;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return InteractionResult.PASS;
    }

    public boolean m_6832_(ItemStack stack, ItemStack ingredient) {
        return CleanlinessHelper.canRepairCheck(this.repairIngredient, ingredient);
    }

    public ItemStack m_7968_() {
        return this.getInnateEnchantedStack((Item)this);
    }

    @Override
    public Map<Enchantment, Integer> getInnateEnchantments() {
        if (this.hammersEnum.getIsEnabled()) {
            return this.hammersEnum.getInnateEnchantments();
        }
        return Map.of();
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        super.m_7373_(stack, world, tooltip, tooltipContext);
        CleanlinessHelper.mcdw$tooltipHelper(stack, tooltip, 17);
    }
}

