/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.bases;

import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.api.util.RarityHelper;
import chronosacaria.mcdw.enums.LongbowsID;
import chronosacaria.mcdw.registries.ItemGroupRegistry;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class McdwLongbow
extends BowItem
implements IInnateEnchantment {
    public final Tier material;
    public final float drawSpeed;
    public float maxBowRange;
    private final ParticleOptions type;
    String[] repairIngredient;
    LongbowsID longbowsEnum;

    public McdwLongbow(LongbowsID longbowsEnum, Tier material, float drawSpeed, float maxBowRangePar, String[] repairIngredient) {
        super(new Item.Properties().m_41487_(1).m_41503_(material.m_6609_()).m_41497_(RarityHelper.fromToolMaterial(material)));
        this.longbowsEnum = longbowsEnum;
        ItemGroupEvents.modifyEntriesEvent(ItemGroupRegistry.RANGED).register(entries -> entries.m_246342_(this.m_7968_()));
        this.material = material;
        this.drawSpeed = drawSpeed;
        this.repairIngredient = repairIngredient;
        this.maxBowRange = maxBowRangePar;
        this.type = null;
    }

    public float getDrawSpeed() {
        return Math.max(0.0f, this.drawSpeed);
    }

    public int m_6615_() {
        return (int)this.maxBowRange;
    }

    public int m_6473_() {
        return this.material.m_6601_();
    }

    public boolean m_6832_(ItemStack stack, ItemStack ingredient) {
        return CleanlinessHelper.canRepairCheck(this.repairIngredient, ingredient);
    }

    public ItemStack m_7968_() {
        return this.getInnateEnchantedStack((Item)this);
    }

    @Override
    public Map<Enchantment, Integer> getInnateEnchantments() {
        if (this.longbowsEnum.getIsEnabled()) {
            return this.longbowsEnum.getInnateEnchantments();
        }
        return Map.of();
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        super.m_7373_(stack, world, tooltip, tooltipContext);
        CleanlinessHelper.mcdw$tooltipHelper(stack, tooltip, 14);
    }
}

