/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.bases;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.api.util.RarityHelper;
import chronosacaria.mcdw.bases.McdwCustomWeaponBase;
import chronosacaria.mcdw.configs.CompatibilityFlags;
import chronosacaria.mcdw.enums.SpearsID;
import chronosacaria.mcdw.registries.EntityAttributesRegistry;
import chronosacaria.mcdw.registries.ItemGroupRegistry;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class McdwSpear
extends McdwCustomWeaponBase
implements Vanishable,
IInnateEnchantment {
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;
    private final Tier material;
    private final float attackDamage;
    String[] repairIngredient;
    SpearsID spearsEnum;

    public McdwSpear(SpearsID spearsEnum, Tier material, int attackDamage, float attackSpeed, String[] repairIngredient) {
        super(material, attackDamage, attackSpeed, new Item.Properties().m_41497_(RarityHelper.fromToolMaterial(material)));
        ItemGroupEvents.modifyEntriesEvent(ItemGroupRegistry.MELEE).register(entries -> entries.m_246342_(this.m_7968_()));
        this.spearsEnum = spearsEnum;
        this.material = material;
        this.attackDamage = (float)attackDamage + material.m_6631_();
        this.repairIngredient = repairIngredient;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)attackSpeed, AttributeModifier.Operation.ADDITION));
        if (FabricLoader.getInstance().isModLoaded("reach-entity-attributes") && CompatibilityFlags.isReachExtensionEnabled) {
            Objects.requireNonNull(Mcdw.CONFIG.mcdwNewStatsConfig);
            builder.put((Object)ReachEntityAttributes.REACH, (Object)new AttributeModifier("Attack range", 1.0, AttributeModifier.Operation.ADDITION));
            Objects.requireNonNull(Mcdw.CONFIG.mcdwNewStatsConfig);
            builder.put((Object)ReachEntityAttributes.ATTACK_RANGE, (Object)new AttributeModifier("Attack range", 1.0, AttributeModifier.Operation.ADDITION));
        } else if (CompatibilityFlags.isReachExtensionEnabled) {
            Objects.requireNonNull(Mcdw.CONFIG.mcdwNewStatsConfig);
            builder.put((Object)EntityAttributesRegistry.ATTACK_RANGE, (Object)new AttributeModifier("Attack range", 1.0, AttributeModifier.Operation.ADDITION));
        }
        this.attributeModifiers = builder.build();
    }

    public Tier m_43314_() {
        return this.material;
    }

    public int m_6473_() {
        return this.material.m_6601_();
    }

    public boolean m_6832_(ItemStack stack, ItemStack ingredient) {
        return CleanlinessHelper.canRepairCheck(this.repairIngredient, ingredient);
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public boolean m_6777_(BlockState state, Level world, BlockPos pos, Player miner) {
        return !miner.m_7500_();
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        if (state.m_60800_((BlockGetter)world, pos) != 0.0f) {
            stack.m_41622_(2, miner, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(equipmentSlot);
    }

    public ItemStack m_7968_() {
        return this.getInnateEnchantedStack((Item)this);
    }

    @Override
    public Map<Enchantment, Integer> getInnateEnchantments() {
        if (this.spearsEnum.getIsEnabled()) {
            return this.spearsEnum.getInnateEnchantments();
        }
        return Map.of();
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        super.m_7373_(stack, world, tooltip, tooltipContext);
        CleanlinessHelper.mcdw$tooltipHelper(stack, tooltip, 16);
    }
}

