/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.bases;

import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.api.util.RarityHelper;
import chronosacaria.mcdw.enums.SwordsID;
import chronosacaria.mcdw.mixin.mcdw.InsulatedAxeItemAccessor;
import chronosacaria.mcdw.registries.ItemGroupRegistry;
import com.google.common.collect.BiMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class McdwSword
extends SwordItem
implements IInnateEnchantment {
    String[] repairIngredient;
    SwordsID swordsEnum;

    public McdwSword(SwordsID swordsEnum, Tier material, int attackDamage, float attackSpeed, String[] repairIngredient) {
        super(material, attackDamage, attackSpeed, new Item.Properties().m_41497_(RarityHelper.fromToolMaterial(material)));
        ItemGroupEvents.modifyEntriesEvent(ItemGroupRegistry.MELEE).register(entries -> entries.m_246342_(this.m_7968_()));
        this.swordsEnum = swordsEnum;
        this.repairIngredient = repairIngredient;
    }

    public boolean m_6832_(ItemStack stack, ItemStack ingredient) {
        return CleanlinessHelper.canRepairCheck(this.repairIngredient, ingredient);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        Player playerEntity = context.m_43723_();
        BlockState blockState = world.m_8055_(blockPos);
        Optional<BlockState> strippedState = this.getStrippedState(blockState);
        Optional decreasedOxidationState = WeatheringCopper.m_154899_((BlockState)blockState);
        Optional<BlockState> blockStateOptional = Optional.ofNullable((Block)((BiMap)HoneycombItem.f_150864_.get()).get((Object)blockState.m_60734_())).map(block -> block.m_152465_(blockState));
        ItemStack itemStack = context.m_43722_();
        Optional<Object> empty = Optional.empty();
        if (context.m_43722_().m_150930_((Item)SwordsID.SWORD_MECHANIZED_SAWBLADE.getItem())) {
            if (strippedState.isPresent()) {
                world.m_5594_(playerEntity, blockPos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
                empty = strippedState;
            } else if (decreasedOxidationState.isPresent()) {
                world.m_5594_(playerEntity, blockPos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_5898_(playerEntity, 3005, blockPos, 0);
                empty = decreasedOxidationState;
            } else if (blockStateOptional.isPresent()) {
                world.m_5594_(playerEntity, blockPos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_5898_(playerEntity, 3004, blockPos, 0);
                empty = blockStateOptional;
            }
            if (empty.isPresent()) {
                if (playerEntity instanceof ServerPlayer) {
                    CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)playerEntity, blockPos, itemStack);
                }
                world.m_7731_(blockPos, (BlockState)empty.get(), 11);
                world.m_220407_(GameEvent.f_157792_, blockPos, GameEvent.Context.m_223719_((Entity)playerEntity, (BlockState)((BlockState)empty.get())));
                if (playerEntity != null) {
                    itemStack.m_41622_(1, (LivingEntity)playerEntity, p -> p.m_21190_(context.m_43724_()));
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (stack.m_150930_((Item)SwordsID.SWORD_MECHANIZED_SAWBLADE.getItem()) && state.m_204336_(BlockTags.f_144280_)) {
            return 8.0f;
        }
        return super.m_8102_(stack, state);
    }

    private Optional<BlockState> getStrippedState(BlockState state) {
        return Optional.ofNullable(InsulatedAxeItemAccessor.getSTRIPPED_BLOCKS().get(state.m_60734_())).map(block -> (BlockState)block.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_))));
    }

    public ItemStack m_7968_() {
        return this.getInnateEnchantedStack((Item)this);
    }

    @Override
    public Map<Enchantment, Integer> getInnateEnchantments() {
        if (this.swordsEnum.getIsEnabled()) {
            return this.swordsEnum.getInnateEnchantments();
        }
        return Map.of();
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        super.m_7373_(stack, world, tooltip, tooltipContext);
        CleanlinessHelper.mcdw$tooltipHelper(stack, tooltip, 16);
    }
}

