/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.client;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.bases.McdwBow;
import chronosacaria.mcdw.bases.McdwCrossbow;
import chronosacaria.mcdw.bases.McdwLongbow;
import chronosacaria.mcdw.bases.McdwShield;
import chronosacaria.mcdw.bases.McdwShortbow;
import chronosacaria.mcdw.enchants.summons.render.SummonedBeeRenderer;
import chronosacaria.mcdw.enums.BowsID;
import chronosacaria.mcdw.enums.CrossbowsID;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.LongbowsID;
import chronosacaria.mcdw.enums.ShieldsID;
import chronosacaria.mcdw.enums.ShortbowsID;
import chronosacaria.mcdw.registries.EnchantsRegistry;
import chronosacaria.mcdw.registries.ParticlesRegistry;
import chronosacaria.mcdw.registries.StatusEffectsRegistry;
import chronosacaria.mcdw.registries.SummonedEntityRegistry;
import java.util.Arrays;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

@Environment(value=EnvType.CLIENT)
public class McdwClient
implements ClientModInitializer {
    public void onInitializeClient() {
        EntityRendererRegistry.register(SummonedEntityRegistry.SUMMONED_BEE_ENTITY, SummonedBeeRenderer::new);
        ParticlesRegistry.registerOnClient();
        Arrays.stream(BowsID.values()).forEach(bowsID -> McdwClient.registerRangedWeaponPredicates((Item)bowsID.getItem()));
        Arrays.stream(ShortbowsID.values()).forEach(shortBowsID -> McdwClient.registerRangedWeaponPredicates((Item)shortBowsID.getItem()));
        Arrays.stream(LongbowsID.values()).forEach(longBowsID -> McdwClient.registerRangedWeaponPredicates((Item)longBowsID.getItem()));
        Arrays.stream(CrossbowsID.values()).forEach(crossbowsID -> McdwClient.registerRangedWeaponPredicates((Item)crossbowsID.getItem()));
        Arrays.stream(ShieldsID.values()).forEach(shieldsID -> McdwClient.registerShieldPredicates(shieldsID.getItem()));
    }

    public static void registerRangedWeaponPredicates(Item item) {
        ItemProperties.m_174570_((Item)item, (ResourceLocation)new ResourceLocation("pull"), (itemStack, clientWorld, livingEntity, seed) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            if (item instanceof McdwBow) {
                McdwBow bow = (McdwBow)item;
                return McdwClient.calculateDrawSpeed(itemStack, livingEntity, bow.getDrawSpeed());
            }
            if (item instanceof McdwShortbow) {
                McdwShortbow shortbow = (McdwShortbow)item;
                return McdwClient.calculateDrawSpeed(itemStack, livingEntity, shortbow.getDrawSpeed());
            }
            if (item instanceof McdwLongbow) {
                McdwLongbow longbow = (McdwLongbow)item;
                return McdwClient.calculateDrawSpeed(itemStack, livingEntity, longbow.getDrawSpeed());
            }
            if (item instanceof McdwCrossbow) {
                McdwCrossbow crossbow = (McdwCrossbow)item;
                return McdwClient.calculateDrawSpeed(itemStack, livingEntity, crossbow.getDrawSpeed());
            }
            return 0.0f;
        });
        if (item instanceof BowItem) {
            ItemProperties.m_174570_((Item)item, (ResourceLocation)new ResourceLocation("pulling"), (itemStack, clientWorld, livingEntity, seed) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
        }
        if (item instanceof CrossbowItem) {
            ItemProperties.m_174570_((Item)item, (ResourceLocation)new ResourceLocation("pulling"), (itemStack, clientWorld, livingEntity, seed) -> {
                if (livingEntity == null) {
                    return 0.0f;
                }
                return livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack && !McdwCrossbow.m_40932_((ItemStack)itemStack) ? 1.0f : 0.0f;
            });
            ItemProperties.m_174570_((Item)item, (ResourceLocation)new ResourceLocation("charged"), (itemStack, clientWorld, livingEntity, seed) -> {
                if (livingEntity == null) {
                    return 0.0f;
                }
                return McdwCrossbow.m_40932_((ItemStack)itemStack) ? 1.0f : 0.0f;
            });
            ItemProperties.m_174570_((Item)item, (ResourceLocation)new ResourceLocation("firework"), (itemStack, clientWorld, livingEntity, seed) -> {
                if (livingEntity == null) {
                    return 0.0f;
                }
                return McdwCrossbow.m_40932_((ItemStack)itemStack) && McdwCrossbow.m_40871_((ItemStack)itemStack, (Item)Items.f_42688_) ? 1.0f : 0.0f;
            });
        }
    }

    public static void registerShieldPredicates(McdwShield shield) {
        ItemProperties.m_174570_((Item)shield, (ResourceLocation)new ResourceLocation("blocking"), (itemStack, clientWorld, livingEntity, seed) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
    }

    private static float calculateDrawSpeed(ItemStack itemStack, LivingEntity livingEntity, float drawSpeed) {
        int overchargeLevel;
        int accelerateLevel;
        int useTicks = itemStack.m_41779_() - livingEntity.m_21212_();
        if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.ACCELERATE).mcdw$getIsEnabled() && (accelerateLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.ACCELERATE), (ItemStack)itemStack)) > 0) {
            MobEffectInstance accelerateInstance = livingEntity.m_21124_(StatusEffectsRegistry.ACCELERATE);
            int consecutiveShots = accelerateInstance != null ? accelerateInstance.m_19564_() + 1 : 0;
            useTicks = (int)((float)useTicks * (1.0f + Mth.m_14036_((float)((float)consecutiveShots * (6.0f + 2.0f * (float)accelerateLevel)), (float)0.0f, (float)100.0f) / 100.0f));
        }
        if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.OVERCHARGE).mcdw$getIsEnabled() && (overchargeLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.OVERCHARGE), (ItemStack)itemStack)) > 0) {
            int overcharge = (int)Math.min((float)useTicks / drawSpeed - 1.0f, (float)overchargeLevel);
            int n = useTicks = overcharge == overchargeLevel ? useTicks : (int)((float)useTicks % drawSpeed);
        }
        if (itemStack.m_41720_() instanceof BowItem) {
            return livingEntity.m_21211_() != itemStack ? 0.0f : (float)useTicks / drawSpeed;
        }
        if (itemStack.m_41720_() instanceof McdwCrossbow) {
            return McdwCrossbow.m_40932_((ItemStack)itemStack) ? 0.0f : (float)useTicks / (float)McdwCrossbow.m_40939_((ItemStack)itemStack);
        }
        return drawSpeed;
    }
}

