/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.configs;

import chronosacaria.mcdw.configs.EnchantmentIDConfigHelper;
import chronosacaria.mcdw.enums.EnchantmentsID;
import java.util.LinkedHashMap;
import java.util.List;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;

@Config(name="mcdw_enchantments_config")
public class McdwEnchantmentsConfig
implements ConfigData {
    @Comment(value="\nA slider value for damage modifying enchantments:\nAmbush, Critical Hit, Void Strike, Pain Cycle, Enigma Resonator, Dynamo, Shadow Form,\nEnigma Shot, Growing, Void Shot, Overcharge, Committed and Hunter's Promise.\n")
    public float directDamageEnchantmentMultiplier = 1.0f;
    @Comment(value="\nSome notes to make sense of the config, below:\n\noffset:     This is a value that is unique to certain enchantments. What it does will be\n            explained in the \"comment\" section that is related to the enchantment.\n\nisEnabled:  Whether the enchantment is on or off. If set to \"false\", the enchantment\n            will not be possible to obtain in any way.\n\nisAvailableForEnchantedBookOffer: Whether the enchantment can be sold by villagers.\n            If set to \"false\", this means that Librarian villagers will not sell this\n            enchantment.\n\nisAvailableForRandomSelection: Whether the enchantment can be found as random loot or\n            obtained through the Enchanting Table. If set to \"false\", this means that the\n            enchantment will not be available via the Enchanting Table nor will it\n            generate as loot that is found in the world.\n\nmaxLevel:   This is an integer (whole number) value that tells the game what the max\n            level the enchantment can be. The value for most enchantments in Minecraft\n            range from 1 to 5. Most MCDX enchantments are up to level 3 and whilst it\n            is possible to set this value above 3, it can have some unexpected results.\n\nprocChance: Some enchantments trigger on a chance. Whilst this number is not a percentage\n            the higher the number, the more likely the enchantment is to trigger.\n            Therefore, if the procChance is set to 20, it is more likely to trigger than\n            if the procChance is set to 10. It is best to experiment with these values\n            if you plan to change them to see what works best for you.\n")
    public final LinkedHashMap<EnchantmentsID, EnchantmentIDConfigHelper> ENCHANTMENT_CONFIG = new LinkedHashMap();

    public McdwEnchantmentsConfig() {
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.ACCELERATE, new EnchantmentIDConfigHelper(true, true, true, 3, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.AMBUSH, new EnchantmentIDConfigHelper(true, true, true, 3, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.ANIMA_CONDUIT, new EnchantmentIDConfigHelper(List.of("Effect Offset:  Healing Percentage,", "Offset Note:    higher offset = more health recovered,", "Default:        100f"), true, true, true, 3, null, 100.0f));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.BONUS_SHOT, new EnchantmentIDConfigHelper(true, true, true, 3, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.BURST_BOWSTRING, new EnchantmentIDConfigHelper(true, false, false, 3, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.BUSY_BEE, new EnchantmentIDConfigHelper(true, false, false, 1, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.CHAIN_REACTION, new EnchantmentIDConfigHelper(true, true, true, 3, 10));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.CHAINS, new EnchantmentIDConfigHelper(true, true, true, 3, 20));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.CHARGE, new EnchantmentIDConfigHelper(true, true, true, 3, 10));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.COBWEB_SHOT, new EnchantmentIDConfigHelper(true, true, true, 1, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.COMMITTED, new EnchantmentIDConfigHelper(true, true, true, 3, 10));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.CRITICAL_HIT, new EnchantmentIDConfigHelper(true, true, true, 3, 10));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.DIPPING_POISON, new EnchantmentIDConfigHelper(true, true, true, 3, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.DYNAMO, new EnchantmentIDConfigHelper(List.of("Effect Offset:  Maximum Stacks,", "Offset Note:    higher offset = more potential stacks,", "Default:        20f"), true, false, false, 3, null, 20.0f));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.ECHO, new EnchantmentIDConfigHelper(true, true, true, 3, 10));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.ENIGMA_RESONATOR, new EnchantmentIDConfigHelper(List.of("Effect Offset:  Damage Divisor,", "Formula:        max((log_e(numSouls * level + 20) / offset) - 1, 0)", "Offset Note:    higher offset = less damage,", "Default:        3.25f"), true, true, true, 3, null, 3.25f));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.EXPLODING, new EnchantmentIDConfigHelper(true, true, true, 3, 20));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.FREEZING, new EnchantmentIDConfigHelper(true, true, true, 3, 30));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.FUSE_SHOT, new EnchantmentIDConfigHelper(true, true, true, 3, 20));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.GRAVITY, new EnchantmentIDConfigHelper(true, true, true, 3, 30));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.GROWING, new EnchantmentIDConfigHelper(true, true, true, 3, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.GUARDING_STRIKE, new EnchantmentIDConfigHelper(true, true, true, 3, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.ILLAGERS_BANE, new EnchantmentIDConfigHelper(true, true, true, 3, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.JUNGLE_POISON, new EnchantmentIDConfigHelper(true, true, true, 3, 30));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.LEECHING, new EnchantmentIDConfigHelper(List.of("Effect Offset:  Healing Percentage,", "Offset Note:    higher offset = more health recovered,", "Default:        100f"), true, true, true, 3, null, 100.0f));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.LEVITATION_SHOT, new EnchantmentIDConfigHelper(true, true, true, 3, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.MULTI_SHOT, new EnchantmentIDConfigHelper(true, false, false, 1, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.OVERCHARGE, new EnchantmentIDConfigHelper(true, true, true, 3, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.PAIN_CYCLE, new EnchantmentIDConfigHelper(true, true, true, 3, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.PHANTOMS_MARK, new EnchantmentIDConfigHelper(true, true, true, 3, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.POISON_CLOUD, new EnchantmentIDConfigHelper(true, true, true, 3, 30));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.PROSPECTOR, new EnchantmentIDConfigHelper(true, true, true, 3, 5));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.RADIANCE, new EnchantmentIDConfigHelper(true, true, true, 3, 20));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.RAMPAGING, new EnchantmentIDConfigHelper(true, true, true, 3, 10));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.REFRESHMENT, new EnchantmentIDConfigHelper(true, true, true, 3, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.REPLENISH, new EnchantmentIDConfigHelper(true, true, true, 3, 3));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.RICOCHET, new EnchantmentIDConfigHelper(true, true, true, 3, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.RUSHDOWN, new EnchantmentIDConfigHelper(true, true, true, 3, 10));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.SHADOW_BARB, new EnchantmentIDConfigHelper(true, false, false, 1, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.SHADOW_SHOT, new EnchantmentIDConfigHelper(true, false, false, 1, 10));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.SHARED_PAIN, new EnchantmentIDConfigHelper(true, false, false, 3, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.SHOCKWAVE, new EnchantmentIDConfigHelper(true, true, true, 3, 10));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.SMITING, new EnchantmentIDConfigHelper(true, true, true, 3, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.SOUL_DEVOURER, new EnchantmentIDConfigHelper(List.of("Effect Offset:  Additional XP,", "Formula:        amount * (1 + (level / offset)),", "Offset Note:    higher offset = less additional XP,", "Default:        3.0f"), true, true, true, 3, null, 3.0f));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.SOUL_SIPHON, new EnchantmentIDConfigHelper(true, true, true, 3, 10));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.STUNNING, new EnchantmentIDConfigHelper(true, true, true, 3, 20));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.SWIRLING, new EnchantmentIDConfigHelper(true, true, true, 3, 10));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.TEMPO_THEFT, new EnchantmentIDConfigHelper(true, true, true, 3, null));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.THUNDERING, new EnchantmentIDConfigHelper(true, true, true, 3, 20));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.VOID_SHOT, new EnchantmentIDConfigHelper(true, false, true, 3, 25));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.VOID_STRIKE, new EnchantmentIDConfigHelper(true, false, true, 3, 15));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.WEAKENING, new EnchantmentIDConfigHelper(true, true, true, 3, 30));
        this.ENCHANTMENT_CONFIG.put(EnchantmentsID.WILD_RAGE, new EnchantmentIDConfigHelper(true, false, true, 3, 10));
    }
}

