/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.effects;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IMcdwEnchantedArrow;
import chronosacaria.mcdw.api.util.AOECloudHelper;
import chronosacaria.mcdw.api.util.AOEHelper;
import chronosacaria.mcdw.api.util.AbilityHelper;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.api.util.InventoryHelper;
import chronosacaria.mcdw.api.util.ProjectileEffectHelper;
import chronosacaria.mcdw.enchants.goals.WildRageAttackGoal;
import chronosacaria.mcdw.enums.BowsID;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.mixin.mcdw.CreeperEntityAccessor;
import chronosacaria.mcdw.mixin.mcdw.MobEntityAccessor;
import chronosacaria.mcdw.registries.EnchantsRegistry;
import chronosacaria.mcdw.registries.SoundEventsRegistry;
import chronosacaria.mcdw.registries.StatusEffectsRegistry;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class EnchantmentEffects {
    public static int mcdw$getEnchantmentLevel(Enchantment enchantment, LivingEntity enchantedEntity, boolean isOffHandStack) {
        if (FabricLoader.getInstance().isModLoaded("bettercombat")) {
            return EnchantmentHelper.m_44836_((Enchantment)enchantment, (LivingEntity)enchantedEntity);
        }
        return EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)(isOffHandStack ? enchantedEntity.m_21206_() : enchantedEntity.m_21205_()));
    }

    public static int soulDevourerExperience(Player playerEntity, int amount) {
        int offHandLevel;
        int mainHandLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.SOUL_DEVOURER), (ItemStack)playerEntity.m_21205_());
        int soulDevourerLevel = mainHandLevel + (offHandLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.SOUL_DEVOURER), (ItemStack)playerEntity.m_21206_()));
        if (soulDevourerLevel > 0) {
            return Math.round((float)amount * (1.0f + (float)soulDevourerLevel / Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.SOUL_DEVOURER).mcdw$getOffset()));
        }
        return amount;
    }

    public static int animaConduitExperience(Player playerEntity, int amount, boolean isOffHandStack) {
        float missingHealth;
        int animaLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.ANIMA_CONDUIT), (LivingEntity)playerEntity, isOffHandStack);
        if (animaLevel > 0 && (missingHealth = playerEntity.m_21233_() - playerEntity.m_21223_()) > 0.0f) {
            float i = Math.min(AbilityHelper.getAnimaRepairAmount(amount, animaLevel), missingHealth);
            playerEntity.m_5634_(i * Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.ANIMA_CONDUIT).mcdw$getOffset() / 100.0f);
            return Math.max(amount -= (int)(i * 5.0f), 0);
        }
        return amount;
    }

    public static float huntersPromiseDamage(Player owner, ServerLevel serverWorld) {
        UUID petOwnerUUID;
        if (Mcdw.CONFIG.mcdwNewStatsConfig.bowStats.get((Object)BowsID.BOW_HUNTERS_PROMISE).isEnabled && owner.m_21205_().m_150930_((Item)BowsID.BOW_HUNTERS_PROMISE.getItem()) && (petOwnerUUID = owner.m_20148_()) != null && serverWorld.m_8791_(petOwnerUUID) instanceof LivingEntity) {
            return 0.5f;
        }
        return 0.0f;
    }

    public static void applyProspector(LivingEntity prospectingEntity, LivingEntity victim, boolean isOffHandStack) {
        int prospectorLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.PROSPECTOR), prospectingEntity, isOffHandStack);
        if (prospectorLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.PROSPECTOR).mcdw$getProcChance() * prospectorLevel) && victim instanceof Enemy) {
            CleanlinessHelper.mcdw$dropItem(victim, Items.f_42616_);
        }
    }

    public static void applyRushdown(LivingEntity rushingEntity, boolean isOffHandStack) {
        int rushdownLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.RUSHDOWN), rushingEntity, isOffHandStack);
        if (rushdownLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.RUSHDOWN).mcdw$getProcChance())) {
            MobEffectInstance rushdown = new MobEffectInstance(MobEffects.f_19596_, 100 * rushdownLevel, 2, false, false);
            rushingEntity.m_7292_(rushdown);
        }
    }

    public static void applySoulSiphon(Player siphoningEntity, boolean isOffHandStack) {
        int soulLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.SOUL_SIPHON), (LivingEntity)siphoningEntity, isOffHandStack);
        if (soulLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.SOUL_SIPHON).mcdw$getProcChance())) {
            siphoningEntity.m_6756_(3 * soulLevel);
        }
    }

    public static void applyShadowShotShadowForm(LivingEntity shadowShotEntity, AbstractArrow ppe, int duration) {
        int shadowShotLevel = ((IMcdwEnchantedArrow)ppe).mcdw$getShadowShotLevel();
        if (shadowShotLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.SHADOW_SHOT).mcdw$getProcChance())) {
            shadowShotEntity.m_7292_(new MobEffectInstance(StatusEffectsRegistry.SHADOW_FORM, duration, 0, false, true, true));
        }
    }

    public static float ambushDamage(LivingEntity ambushingEntity, LivingEntity ambushee, boolean isOffHandStack) {
        int ambushLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.AMBUSH), ambushingEntity, isOffHandStack);
        if (ambushLevel > 0 && ambushingEntity.m_20145_() && ambushingEntity.m_6144_()) {
            CleanlinessHelper.playCenteredSound(ambushee, SoundEvents.f_144126_, 0.5f, 1.0f);
            return 0.15f * (float)ambushLevel;
        }
        return 0.0f;
    }

    public static float criticalHitDamage(LivingEntity crittingEntity, LivingEntity target, boolean isOffHandStack) {
        int criticalHitLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.CRITICAL_HIT), crittingEntity, isOffHandStack);
        if (criticalHitLevel > 0 && CleanlinessHelper.percentToOccur(10 + Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.CRITICAL_HIT).mcdw$getProcChance() * criticalHitLevel) && !AbilityHelper.entityCanCrit(crittingEntity)) {
            CleanlinessHelper.playCenteredSound(target, SoundEvents.f_12313_, 0.5f, 1.0f);
            return 0.5f;
        }
        return 0.0f;
    }

    public static float voidStrikeDamage(LivingEntity voidEntity, LivingEntity target, boolean isOffHandStack) {
        int voidlevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.VOID_STRIKE), voidEntity, isOffHandStack);
        if (voidlevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.VOID_STRIKE).mcdw$getProcChance() + 5 * voidlevel)) {
            CleanlinessHelper.playCenteredSound(target, SoundEvents.f_11852_, 0.5f, 1.0f);
            return 2.0f * (float)voidlevel - 1.0f;
        }
        return 0.0f;
    }

    public static float painCycleDamage(LivingEntity painEntity, boolean isOffHandStack) {
        int painCycleLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.PAIN_CYCLE), painEntity, isOffHandStack);
        if (painCycleLevel > 0) {
            int i;
            MobEffectInstance painCycleInstance = painEntity.m_21124_(StatusEffectsRegistry.PAIN_CYCLE);
            int n = i = painCycleInstance != null ? painCycleInstance.m_19564_() + 1 : 0;
            if (i < 5) {
                MobEffectInstance painCycleUpdate = new MobEffectInstance(StatusEffectsRegistry.PAIN_CYCLE, 120000, i, false, false, true);
                painEntity.m_21195_(StatusEffectsRegistry.PAIN_CYCLE);
                painEntity.m_7292_(painCycleUpdate);
                painEntity.m_6469_(painEntity.m_9236_().m_269111_().m_269425_(), 1.0f);
            } else {
                painEntity.m_21195_(StatusEffectsRegistry.PAIN_CYCLE);
                return painCycleLevel + 1;
            }
        }
        return 0.0f;
    }

    public static float enigmaResonatorDamage(Player resonatingEntity, LivingEntity target, boolean isOffHandStack) {
        int resonatorLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.ENIGMA_RESONATOR), (LivingEntity)resonatingEntity, isOffHandStack);
        return EnchantmentEffects.calcEnigmaResonatorDamage(resonatingEntity, target, resonatorLevel);
    }

    public static float enigmaShotDamage(LivingEntity resonatingEntity, LivingEntity target, AbstractArrow ppe) {
        if (!(resonatingEntity instanceof Player)) {
            return 0.0f;
        }
        Player player = (Player)resonatingEntity;
        IMcdwEnchantedArrow enchantedArrow = (IMcdwEnchantedArrow)ppe;
        int resonatorLevel = enchantedArrow.mcdw$getEnigmaResonatorLevel();
        return EnchantmentEffects.calcEnigmaResonatorDamage(player, target, resonatorLevel);
    }

    private static float calcEnigmaResonatorDamage(Player resonatingEntity, LivingEntity target, int resonatorLevel) {
        int numSouls;
        if (resonatorLevel > 0 && (numSouls = resonatingEntity.f_36078_) > 0) {
            CleanlinessHelper.playCenteredSound(target, SoundEvents.f_12404_, 0.5f, 1.0f);
            float extraDamageMultiplier = (float)Math.log(numSouls * resonatorLevel + 20) / Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.ENIGMA_RESONATOR).mcdw$getOffset();
            return Math.max(extraDamageMultiplier - 1.0f, 0.0f);
        }
        return 0.0f;
    }

    public static float growingDamage(LivingEntity growingEntity, LivingEntity target, AbstractArrow ppe) {
        int growingLevel = ((IMcdwEnchantedArrow)ppe).mcdw$getGrowingLevel();
        if (growingLevel > 0) {
            CleanlinessHelper.playCenteredSound(target, SoundEvents.f_11852_, 0.5f, 1.0f);
            float damageModifier = 0.03f * growingEntity.m_20270_((Entity)target) * (float)growingLevel;
            return Mth.m_14036_((float)damageModifier, (float)0.0f, (float)growingLevel);
        }
        return 0.0f;
    }

    public static float voidShotDamage(LivingEntity target, AbstractArrow ppe) {
        int voidlevel = ((IMcdwEnchantedArrow)ppe).mcdw$getVoidShotLevel();
        if (voidlevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.VOID_SHOT).mcdw$getProcChance() + 5 * voidlevel)) {
            CleanlinessHelper.playCenteredSound(target, SoundEvents.f_11852_, 0.5f, 1.0f);
            return voidlevel;
        }
        return 0.0f;
    }

    public static float committedDamage(LivingEntity committedEntity, LivingEntity target, boolean isOffHandStack) {
        int committedLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.COMMITTED), committedEntity, isOffHandStack);
        if (committedLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.COMMITTED).mcdw$getProcChance())) {
            CleanlinessHelper.playCenteredSound(target, SoundEvents.f_11913_, 0.5f, 1.0f);
            float getTargetRemainingHealth = Mth.m_14036_((float)(target.m_21223_() / target.m_21233_()), (float)0.0f, (float)1.0f);
            float attributeDamage = (float)committedEntity.m_21133_(Attributes.f_22281_);
            float committedMultiplier = 0.2f * (float)committedLevel;
            float getExtraDamage = attributeDamage * (1.0f - getTargetRemainingHealth) * committedMultiplier;
            return Math.max(getExtraDamage, 0.0f);
        }
        return 0.0f;
    }

    public static float dynamoDamage(LivingEntity dynamoEntity, boolean isOffHandStack) {
        int dynamoLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.DYNAMO), dynamoEntity, isOffHandStack);
        return EnchantmentEffects.calcDynamoDamage(dynamoEntity, dynamoLevel);
    }

    public static float dynamoShotDamage(LivingEntity dynamoEntity, AbstractArrow ppe) {
        int dynamoLevel = ((IMcdwEnchantedArrow)ppe).mcdw$getDynamoLevel();
        return EnchantmentEffects.calcDynamoDamage(dynamoEntity, dynamoLevel);
    }

    private static float calcDynamoDamage(LivingEntity dynamoEntity, int dynamoLevel) {
        MobEffectInstance dynamoInstance;
        if (dynamoLevel > 0 && dynamoEntity.m_21023_(StatusEffectsRegistry.DYNAMO) && (dynamoInstance = dynamoEntity.m_21124_(StatusEffectsRegistry.DYNAMO)) != null) {
            int dynamoAmplifier = dynamoInstance.m_19564_() + 1;
            float dynamoLevelModifier = (float)(dynamoLevel - 1) * 0.25f + 1.0f;
            float getDynamoDamage = (float)((double)dynamoLevelModifier * ((double)dynamoAmplifier * 0.1));
            dynamoEntity.m_21195_(StatusEffectsRegistry.DYNAMO);
            return Math.max(getDynamoDamage, 0.0f);
        }
        return 0.0f;
    }

    public static float shadowFormDamage(LivingEntity shadowShotEntity) {
        if (shadowShotEntity.m_21023_(StatusEffectsRegistry.SHADOW_FORM)) {
            shadowShotEntity.m_21195_(StatusEffectsRegistry.SHADOW_FORM);
            return 7.0f;
        }
        return 0.0f;
    }

    public static float shadowFormShotDamage(LivingEntity shadowShotEntity, AbstractArrow ppe) {
        boolean shadowBarbBoolean = ((IMcdwEnchantedArrow)ppe).mcdw$getShadowBarbBoolean();
        if (shadowShotEntity.m_21023_(StatusEffectsRegistry.SHADOW_FORM)) {
            if (!shadowBarbBoolean) {
                shadowShotEntity.m_21195_(StatusEffectsRegistry.SHADOW_FORM);
            }
            return 7.0f;
        }
        return 0.0f;
    }

    public static float overchargeDamage(AbstractArrow ppe) {
        int overchargeAmount = ((IMcdwEnchantedArrow)ppe).mcdw$getOvercharge();
        return Math.max(overchargeAmount, 0);
    }

    public static void applyFreezing(LivingEntity freezerEntity, LivingEntity target, boolean isOffHandStack) {
        int freezingLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.FREEZING), freezerEntity, isOffHandStack);
        if (freezingLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.FREEZING).mcdw$getProcChance() + 10 * freezingLevel)) {
            AbilityHelper.causeFreezing(target, 100);
        }
    }

    public static void applyPoisoning(LivingEntity poisoningEntity, LivingEntity target, boolean isOffHandStack) {
        int poisoningLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.JUNGLE_POISON), poisoningEntity, isOffHandStack);
        if (poisoningLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.JUNGLE_POISON).mcdw$getProcChance())) {
            MobEffectInstance poison = new MobEffectInstance(MobEffects.f_19614_, 60, poisoningLevel - 1);
            target.m_7292_(poison);
        }
    }

    public static void applyPoisonCloud(LivingEntity poisoningEntity, LivingEntity target, boolean isOffHandStack) {
        int poisoningLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.POISON_CLOUD), poisoningEntity, isOffHandStack);
        if (poisoningLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.POISON_CLOUD).mcdw$getProcChance())) {
            AOECloudHelper.spawnAreaEffectCloudEntityWithAttributes(poisoningEntity, target, 5.0f, 10, 60, MobEffects.f_19614_, 60, poisoningLevel - 1, true, true, true, false);
        }
    }

    public static void applyRadianceCloud(LivingEntity radiantEntity, boolean isOffHandStack) {
        int radianceLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.RADIANCE), radiantEntity, isOffHandStack);
        if (radianceLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.RADIANCE).mcdw$getProcChance())) {
            AOECloudHelper.spawnAreaEffectCloudEntityWithAttributes(radiantEntity, radiantEntity, 5.0f, 10, 60, MobEffects.f_19605_, 100, radianceLevel - 1, true, false, false, true);
        }
    }

    public static void applyShockwave(LivingEntity shockwaveEntity, LivingEntity target, float amount, boolean isOffHandStack) {
        int shockwaveLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.SHOCKWAVE), shockwaveEntity, isOffHandStack);
        if (shockwaveLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.SHOCKWAVE).mcdw$getProcChance() + 15 * shockwaveLevel)) {
            EnchantmentEffects.causeShockwaveAttack(shockwaveEntity, target, 3.0f, amount);
            CleanlinessHelper.playCenteredSound(target, SoundEvents.f_12089_, SoundSource.WEATHER, 0.5f, 1.0f);
        }
    }

    public static void causeShockwaveAttack(LivingEntity user, LivingEntity target, float distance, float amount) {
        AOEHelper.getEntitiesByConfig(user, distance).stream().filter(nearbyEntity -> nearbyEntity != target).forEach(nearbyEntity -> nearbyEntity.m_6469_(nearbyEntity.m_9236_().m_269111_().m_269264_(), amount * 0.25f));
    }

    public static void causeSmitingAttack(LivingEntity user, LivingEntity target, float distance, float amount) {
        AOEHelper.getEntitiesByConfig(user, distance).stream().filter(nearbyEntity -> nearbyEntity != target && nearbyEntity.m_21222_()).forEach(nearbyEntity -> nearbyEntity.m_6469_(nearbyEntity.m_9236_().m_269111_().m_269425_(), amount * 1.25f));
    }

    public static void applyStunning(LivingEntity stunningEntity, LivingEntity target, boolean isOffHandStack) {
        int stunningLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.STUNNING), stunningEntity, isOffHandStack);
        if (stunningLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.STUNNING).mcdw$getProcChance() + 15 * stunningLevel)) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 10));
            target.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 60, 1));
        }
    }

    public static void applyThundering(LivingEntity thunderingEntity, float amount, boolean isOffHandStack) {
        int thunderingLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.THUNDERING), thunderingEntity, isOffHandStack);
        if (thunderingLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.THUNDERING).mcdw$getProcChance())) {
            EnchantmentEffects.electrocuteNearbyEnemies(thunderingEntity, 5 * thunderingLevel, amount, Integer.MAX_VALUE);
        }
    }

    public static void createVisualLightningBoltOnEntity(Entity target) {
        EntityDataAccessor<Boolean> charged = CreeperEntityAccessor.getCHARGED();
        Level world = target.m_20193_();
        LightningBolt lightningEntity = (LightningBolt)EntityType.f_20465_.m_20615_(world);
        if (lightningEntity != null) {
            lightningEntity.m_6027_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            lightningEntity.m_20874_(true);
            if (target instanceof Creeper) {
                Creeper creeperEntity = (Creeper)target;
                creeperEntity.m_20088_().m_135381_(charged, (Object)true);
            }
            world.m_7967_((Entity)lightningEntity);
        }
    }

    public static void electrocute(LivingEntity victim, float damageAmount) {
        EnchantmentEffects.createVisualLightningBoltOnEntity((Entity)victim);
        victim.m_6469_(victim.m_9236_().m_269111_().m_269548_(), damageAmount);
    }

    public static void electrocuteNearbyEnemies(LivingEntity user, float distance, float damageAmount, int limit) {
        boolean foundTarget = false;
        for (LivingEntity nearbyEntity : AOEHelper.getEntitiesByConfig(user, distance)) {
            EnchantmentEffects.electrocute(nearbyEntity, damageAmount);
            foundTarget = true;
            if (--limit > 0) continue;
            break;
        }
        if (foundTarget) {
            CleanlinessHelper.playCenteredSound(user, SoundEvents.f_12090_, SoundSource.WEATHER, 1.0f, 1.0f);
            CleanlinessHelper.playCenteredSound(user, SoundEvents.f_12089_, SoundSource.WEATHER, 1.0f, 1.0f);
        }
    }

    public static void applyWeakeningCloud(LivingEntity weakeningEntity, LivingEntity target, boolean isOffHandStack) {
        int weakeningLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.WEAKENING), weakeningEntity, isOffHandStack);
        if (weakeningLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.WEAKENING).mcdw$getProcChance())) {
            AOECloudHelper.spawnAreaEffectCloudEntityWithAttributes(weakeningEntity, target, 5.0f, 10, 60, MobEffects.f_19613_, 100, weakeningLevel - 1, true, true, true, false);
        }
    }

    public static void applySwirling(LivingEntity swirlingEntity, LivingEntity target, float amount, boolean isOffHandStack) {
        int swirlingLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.SWIRLING), swirlingEntity, isOffHandStack);
        if (swirlingLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.SWIRLING).mcdw$getProcChance() + 15 * swirlingLevel)) {
            EnchantmentEffects.causeSwirlingAttack(swirlingEntity, swirlingEntity, 1.5f, amount);
            CleanlinessHelper.playCenteredSound(target, SoundEvents.f_12317_, 0.5f, 1.0f);
        }
    }

    public static void causeSwirlingAttack(LivingEntity user, LivingEntity target, float distance, float amount) {
        AOEHelper.getEntitiesByConfig(target, user, distance).forEach(nearbyEntity -> nearbyEntity.m_6469_(nearbyEntity.m_9236_().m_269111_().m_269264_(), amount * 0.5f));
    }

    public static void applyChains(LivingEntity chainingEntity, LivingEntity target, boolean isOffHandStack) {
        int chainsLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.CHAINS), chainingEntity, isOffHandStack);
        if (chainsLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.CHAINS).mcdw$getProcChance())) {
            EnchantmentEffects.chainNearbyEntities(chainingEntity, target, 1.5f * (float)chainsLevel, chainsLevel);
        }
    }

    public static void chainNearbyEntities(LivingEntity user, LivingEntity target, float distance, int timeMultiplier) {
        MobEffectInstance chained = new MobEffectInstance(MobEffects.f_19597_, 100 * timeMultiplier, 100);
        target.m_7292_(chained);
        AOEHelper.getEntitiesByConfig(user, distance).stream().filter(nearbyEntity -> nearbyEntity != target).forEach(nearbyEntity -> {
            EnchantmentEffects.pullTowards((Entity)nearbyEntity, (Entity)target);
            nearbyEntity.m_7292_(chained);
        });
    }

    public static void applyGravity(LivingEntity gravityEntity, LivingEntity target, boolean isOffHandStack) {
        int gravityLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.GRAVITY), gravityEntity, isOffHandStack);
        if (gravityLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.GRAVITY).mcdw$getProcChance())) {
            EnchantmentEffects.pullInNearbyEntities(gravityEntity, target, (gravityLevel + 1) * 3);
        }
    }

    public static void pullTowards(Entity self, Entity target) {
        if (self instanceof Player && ((Player)self).m_150110_().f_35937_) {
            return;
        }
        double motionX = Mth.m_14008_((double)((target.m_20185_() - self.m_20185_()) * (double)0.15f), (double)-5.0, (double)5.0);
        double motionZ = Mth.m_14008_((double)((target.m_20189_() - self.m_20189_()) * (double)0.15f), (double)-5.0, (double)5.0);
        Vec3 vec3d = new Vec3(motionX, 0.0, motionZ);
        self.m_20256_(vec3d);
    }

    public static void pullInNearbyEntities(LivingEntity user, LivingEntity target, float distance) {
        AOEHelper.getEntitiesByConfig(user, distance).stream().filter(nearbyEntity -> nearbyEntity != target).forEach(nearbyEntity -> EnchantmentEffects.pullTowards((Entity)nearbyEntity, (Entity)target));
    }

    public static void echoDamage(LivingEntity echoEntity, LivingEntity target, float amount, boolean isOffHandStack) {
        int echoLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.ECHO), echoEntity, isOffHandStack);
        if (echoLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.ECHO).mcdw$getProcChance() + 15 * echoLevel)) {
            EnchantmentEffects.causeEchoAttack(echoEntity, target, 3.0f, echoLevel, amount);
            CleanlinessHelper.playCenteredSound(echoEntity, SoundEventsRegistry.ECHO_SOUND_EVENT, 0.5f, 1.0f);
        }
    }

    public static void causeEchoAttack(LivingEntity user, LivingEntity target, float distance, int echoLevel, float amount) {
        for (LivingEntity nearbyEntity : AOEHelper.getEntitiesByConfig(user, distance)) {
            if (nearbyEntity == target) continue;
            nearbyEntity.m_6469_(nearbyEntity.m_9236_().m_269111_().m_269264_(), amount);
            if (--echoLevel > 0) continue;
            break;
        }
    }

    public static void explodingDamage(LivingEntity exploderEntity, LivingEntity target, boolean isOffHandStack) {
        int explodingLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.EXPLODING), exploderEntity, isOffHandStack);
        if (explodingLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.EXPLODING).mcdw$getProcChance())) {
            CleanlinessHelper.playCenteredSound(target, SoundEvents.f_11913_, 0.5f, 1.0f);
            AOECloudHelper.spawnExplosionCloud(exploderEntity, target, 3.0f);
            float explodingDamage = target.m_21233_() * 0.2f * (float)explodingLevel;
            EnchantmentEffects.causeExplosionAttack(exploderEntity, target, explodingDamage, 3.0f);
        }
    }

    public static void causeExplosionAttack(LivingEntity user, LivingEntity target, float damageAmount, float distance) {
        AOEHelper.getEntitiesByConfig(target, user, distance).forEach(nearbyEntity -> nearbyEntity.m_6469_(nearbyEntity.m_9236_().m_269111_().m_269036_((Entity)target, (Entity)user), damageAmount));
    }

    public static void applyRampaging(LivingEntity rampagingEntity, boolean isOffHandStack) {
        int rampagingLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.RAMPAGING), rampagingEntity, isOffHandStack);
        if (rampagingLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.RAMPAGING).mcdw$getProcChance())) {
            MobEffectInstance rampage = new MobEffectInstance(MobEffects.f_19598_, rampagingLevel * 100, 2, false, false);
            rampagingEntity.m_7292_(rampage);
        }
    }

    public static void applyGuardingStrike(LivingEntity guardingEntity, boolean isOffHandStack) {
        int guardingLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.GUARDING_STRIKE), guardingEntity, isOffHandStack);
        if (guardingLevel > 0) {
            MobEffectInstance shield = new MobEffectInstance(MobEffects.f_19606_, 20 + 20 * guardingLevel, 2);
            guardingEntity.m_7292_(shield);
        }
    }

    public static void applyLeeching(LivingEntity leechingEntity, LivingEntity target, boolean isOffHandStack) {
        int leechingLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.LEECHING), leechingEntity, isOffHandStack);
        if (leechingLevel > 0 && leechingEntity.m_21223_() < leechingEntity.m_21233_()) {
            float healthRegained = (0.2f + 0.2f * (float)leechingLevel) * target.m_21233_();
            leechingEntity.m_5634_(healthRegained * Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.LEECHING).mcdw$getOffset() / 100.0f);
        }
    }

    public static void applyRefreshment(Player refreshingEntity, boolean isOffHandStack) {
        int refreshmentLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.REFRESHMENT), (LivingEntity)refreshingEntity, isOffHandStack);
        if (refreshmentLevel > 0) {
            InventoryHelper.mcdw$systematicReplacePotions(refreshingEntity, Items.f_42590_, Potions.f_43623_, refreshmentLevel);
        }
    }

    public static void applyChainReaction(LivingEntity shooter, LivingEntity target, AbstractArrow ppe) {
        int chainReactionLevel = ((IMcdwEnchantedArrow)ppe).mcdw$getChainReactionLevel();
        if (chainReactionLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.CHAIN_REACTION).mcdw$getProcChance() * chainReactionLevel)) {
            ProjectileEffectHelper.mcdw$fireChainReactionProjectileFromTarget(target.m_20193_(), target, shooter, 3.15f, 1.0f);
        }
    }

    public static void applyCharge(LivingEntity chargingEntity, AbstractArrow ppe) {
        int chargeLevel = ((IMcdwEnchantedArrow)ppe).mcdw$getChargeLevel();
        if (chargeLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.CHARGE).mcdw$getProcChance())) {
            chargingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19596_, chargeLevel * 20, 4));
        }
    }

    public static void applyCobwebShotEntity(LivingEntity target, AbstractArrow ppe) {
        BlockPos targetPos;
        Level targetWorld;
        if (((IMcdwEnchantedArrow)ppe).mcdw$getCobwebShotLevel() > 0 && (targetWorld = target.m_20193_()).m_8055_(targetPos = target.m_20183_()) == Blocks.f_50016_.m_49966_()) {
            targetWorld.m_46597_(targetPos, Blocks.f_50033_.m_49966_());
        }
    }

    public static void applyFuseShot(LivingEntity shooter, LivingEntity target, AbstractArrow ppe) {
        int fuseShotLevel = ((IMcdwEnchantedArrow)ppe).mcdw$getFuseShotLevel();
        if (fuseShotLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.FUSE_SHOT).mcdw$getProcChance() + 15 * fuseShotLevel)) {
            CleanlinessHelper.playCenteredSound(target, SoundEvents.f_11913_, 0.5f, 1.0f);
            AOECloudHelper.spawnExplosionCloud(shooter, target, 3.0f);
            float f = (float)ppe.m_20184_().m_82553_();
            int fuseShotDamage = Mth.m_14165_((double)Mth.m_14008_((double)((double)f * ppe.m_36789_()), (double)0.0, (double)2.147483647E9));
            EnchantmentEffects.causeExplosionAttack(shooter, target, fuseShotDamage, 3.0f);
        }
    }

    public static void applyFreezingShot(LivingEntity target, AbstractArrow ppe) {
        int freezingLevel = ((IMcdwEnchantedArrow)ppe).mcdw$getFreezingLevel();
        if (freezingLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.FREEZING).mcdw$getProcChance() + 10 * freezingLevel)) {
            AbilityHelper.causeFreezing(target, 100);
        }
    }

    public static void applyGravityShot(LivingEntity shooter, LivingEntity target, AbstractArrow ppe) {
        int gravityLevel = ((IMcdwEnchantedArrow)ppe).mcdw$getGravityLevel();
        if (gravityLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.GRAVITY).mcdw$getProcChance())) {
            EnchantmentEffects.pullInNearbyEntities(shooter, target, (gravityLevel + 1) * 3);
        }
    }

    public static void applyLevitationShot(LivingEntity target, AbstractArrow ppe) {
        int levitationShotLevel = ((IMcdwEnchantedArrow)ppe).mcdw$getLevitationShotLevel();
        if (levitationShotLevel > 0) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 200 * levitationShotLevel));
        }
    }

    public static void applyPhantomsMark(LivingEntity target, AbstractArrow ppe) {
        int phantomsMarkLevel = ((IMcdwEnchantedArrow)ppe).mcdw$getPhantomsMarkLevel();
        if (phantomsMarkLevel > 0) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 100 * phantomsMarkLevel));
        }
    }

    public static void applyPoisonCloudShot(LivingEntity shooter, LivingEntity target, AbstractArrow ppe) {
        int poisonCloudLevel = ((IMcdwEnchantedArrow)ppe).mcdw$getPoisonCloudLevel();
        if (poisonCloudLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.POISON_CLOUD).mcdw$getProcChance())) {
            AOECloudHelper.spawnAreaEffectCloudEntityWithAttributes(shooter, target, 5.0f, 10, 60, MobEffects.f_19614_, 60, poisonCloudLevel - 1, true, true, false, false);
        }
    }

    public static void applyRadianceShot(LivingEntity shooter, LivingEntity target, AbstractArrow ppe) {
        int radianceLevel = ((IMcdwEnchantedArrow)ppe).mcdw$getRadianceLevel();
        if (radianceLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.RADIANCE).mcdw$getProcChance())) {
            AOECloudHelper.spawnRegenCloudAtPos(shooter, true, target.m_20183_(), radianceLevel - 1);
        }
    }

    public static void applyRicochet(LivingEntity shooter, LivingEntity target, AbstractArrow ppe) {
        int ricochetLevel = ((IMcdwEnchantedArrow)ppe).mcdw$getRicochetLevel();
        if (ricochetLevel > 0) {
            float damageMultiplier = 0.03f + (float)ricochetLevel * 0.07f;
            if (ppe.m_20184_().m_82553_() > (double)0.7f) {
                ProjectileEffectHelper.mcdw$spawnExtraArrows(shooter, target, 1, 10, damageMultiplier);
            }
        }
    }

    public static void applyReplenish(Player shooter, AbstractArrow ppe) {
        int replenishLevel = ((IMcdwEnchantedArrow)ppe).mcdw$getReplenishLevel();
        if (replenishLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.REPLENISH).mcdw$getProcChance() + 7 * replenishLevel)) {
            CleanlinessHelper.mcdw$dropItem((LivingEntity)shooter, Items.f_42412_);
        }
    }

    public static void applyTempoTheft(LivingEntity tempoEntity, LivingEntity target, AbstractArrow ppe) {
        int tempoTheftLevel = ((IMcdwEnchantedArrow)ppe).mcdw$getTempoTheftLevel();
        if (tempoTheftLevel > 0) {
            AbilityHelper.stealSpeedFromTarget(tempoEntity, target, tempoTheftLevel);
        }
    }

    public static void applyThunderingShot(LivingEntity shooter, AbstractArrow ppe) {
        int thunderingLevel = ((IMcdwEnchantedArrow)ppe).mcdw$getThunderingLevel();
        if (thunderingLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.THUNDERING).mcdw$getProcChance())) {
            EnchantmentEffects.electrocuteNearbyEnemies(shooter, 5 * thunderingLevel, 5.0f, Integer.MAX_VALUE);
        }
    }

    public static void applyWildRage(Mob ragingEntity, AbstractArrow ppe) {
        int wildRageLevel = ((IMcdwEnchantedArrow)ppe).mcdw$getWildRageLevel();
        if (wildRageLevel > 0 && CleanlinessHelper.percentToOccur(Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.WILD_RAGE).mcdw$getProcChance() + 10 * wildRageLevel)) {
            EnchantmentEffects.sendIntoWildRage(ragingEntity);
        }
    }

    public static void applyCobwebShotBlock(BlockHitResult blockHitResult, AbstractArrow ppe) {
        if (((IMcdwEnchantedArrow)ppe).mcdw$getCobwebShotLevel() > 0) {
            Level ppeWorld = ppe.m_20193_();
            Direction side = blockHitResult.m_82434_();
            if (ppeWorld.m_8055_(blockHitResult.m_82425_().m_121945_(side)) == Blocks.f_50016_.m_49966_()) {
                ppeWorld.m_46597_(blockHitResult.m_82425_().m_121945_(side), Blocks.f_50033_.m_49966_());
            }
        }
    }

    public static void applyRadianceShotBlock(BlockHitResult blockHitResult, LivingEntity shooter, AbstractArrow ppe) {
        int radianceLevel = ((IMcdwEnchantedArrow)ppe).mcdw$getRadianceLevel();
        if (radianceLevel > 0) {
            AOECloudHelper.spawnRegenCloudAtPos(shooter, true, blockHitResult.m_82425_(), radianceLevel - 1);
        }
    }

    public static void activateBurstBowstringOnJump(LivingEntity jumpingEntity) {
        int burstBowstringLevel = Math.max(EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.BURST_BOWSTRING), (ItemStack)jumpingEntity.m_21205_()), EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.BURST_BOWSTRING), (ItemStack)jumpingEntity.m_21206_()));
        if (burstBowstringLevel > 0 && jumpingEntity instanceof Player) {
            Player attackingPlayer = (Player)jumpingEntity;
            int availableArrows = Math.min(InventoryHelper.mcdw$countItem(attackingPlayer, Items.f_42412_), burstBowstringLevel);
            if (availableArrows < 1) {
                return;
            }
            ProjectileEffectHelper.mcdw$spawnExtraArrows(jumpingEntity, jumpingEntity, availableArrows, 16, 0.4f);
        }
    }

    public static void handleAddDynamoEffect(Player playerEntity) {
        ItemStack mainHandStack = playerEntity.m_21205_();
        ItemStack offHandStack = playerEntity.m_21206_();
        if (Math.max(EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.DYNAMO), (ItemStack)mainHandStack), EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.DYNAMO), (ItemStack)offHandStack)) > 0) {
            MobEffectInstance dynamoInstance = playerEntity.m_21124_(StatusEffectsRegistry.DYNAMO);
            int i = 1;
            i = dynamoInstance != null ? (i += dynamoInstance.m_19564_()) : --i;
            i = Mth.m_14045_((int)i, (int)0, (int)((int)Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.DYNAMO).mcdw$getOffset()));
            MobEffectInstance dynamoUpdateInstance = new MobEffectInstance(StatusEffectsRegistry.DYNAMO, 120000, i, false, false, true);
            playerEntity.m_7292_(dynamoUpdateInstance);
        }
    }

    public static void sendIntoWildRage(Mob mobEntity) {
        ((MobEntityAccessor)mobEntity).targetSelector().m_25352_(0, (Goal)new WildRageAttackGoal(mobEntity));
    }
}

