/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.bases.McdwAxe;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;

public enum AxesID implements IMeleeWeaponID,
IInnateEnchantment
{
    AXE_ANCHOR(true, (Tier)Tiers.IRON, 8, -3.4f, "minecraft:iron_ingot"),
    AXE_AXE(true, (Tier)Tiers.IRON, 6, -3.1f, "minecraft:iron_ingot"),
    AXE_ENCRUSTED_ANCHOR(true, (Tier)Tiers.DIAMOND, 8, -3.4f, "minecraft:diamond"),
    AXE_FIREBRAND(true, (Tier)Tiers.DIAMOND, 4, -2.9f, "minecraft:diamond"),
    AXE_HIGHLAND(true, (Tier)Tiers.IRON, 4, -2.9f, "minecraft:iron_ingot");

    private final boolean isEnabled;
    private final Tier material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private AxesID(boolean isEnabled, Tier material, int damage, float attackSpeed, String ... repairIngredient) {
        this.isEnabled = isEnabled;
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static EnumMap<AxesID, McdwAxe> getItemsEnum() {
        return ItemsRegistry.AXE_ITEMS;
    }

    public static HashMap<AxesID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.AXE_SPAWN_RATES;
    }

    public static HashMap<AxesID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.axeStats;
    }

    @Override
    public boolean getIsEnabled() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.axeStats.get((Object)this).isEnabled;
    }

    public McdwAxe getItem() {
        return AxesID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return AxesID.getSpawnRates().get(this);
    }

    public HashMap<AxesID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.axeStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return AxesID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.axeStats.get(this);
    }

    @Override
    public Tier getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getMeleeStats() {
        return new IMeleeWeaponID.MeleeStats().meleeStats(this.isEnabled, CleanlinessHelper.materialToString(this.material), this.damage, this.attackSpeed, this.repairIngredient);
    }

    @Override
    public Map<Enchantment, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case AXE_ANCHOR -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.GRAVITY});
            case AXE_AXE -> Map.of();
            case AXE_ENCRUSTED_ANCHOR -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.GRAVITY, EnchantmentsID.JUNGLE_POISON});
            case AXE_FIREBRAND -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, Enchantments.f_44981_);
            case AXE_HIGHLAND -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.STUNNING});
        };
    }

    @Override
    @NotNull
    public ItemStack getInnateEnchantedStack(Item item) {
        return item.m_7968_();
    }

    public McdwAxe makeWeapon() {
        McdwAxe mcdwAxe = new McdwAxe(this, CleanlinessHelper.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        AxesID.getItemsEnum().put(this, mcdwAxe);
        return mcdwAxe;
    }
}

