/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.bases.McdwBow;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.IRangedWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;

public enum BowsID implements IRangedWeaponID,
IInnateEnchantment
{
    BOW_ANCIENT_BOW(true, (Tier)Tiers.NETHERITE, 7.0, 14, 18.0f, "minecraft:netherite_scrap"),
    BOW_BONEBOW(true, (Tier)Tiers.STONE, 5.0, 16, 12.0f, "minecraft:bone"),
    BOW_BUBBLE_BOW(true, (Tier)Tiers.IRON, 5.0, 15, 12.0f, "minecraft:iron_ingot"),
    BOW_BUBBLE_BURSTER(true, (Tier)Tiers.DIAMOND, 5.0, 15, 13.0f, "minecraft:diamond"),
    BOW_BURST_GALE_BOW(true, (Tier)Tiers.DIAMOND, 6.0, 12, 16.0f, "minecraft:diamond"),
    BOW_CALL_OF_THE_VOID(true, (Tier)Tiers.NETHERITE, 6.0, 15, 16.0f, "minecraft:netherite_scrap"),
    BOW_ECHO_OF_THE_VALLEY(true, (Tier)Tiers.DIAMOND, 6.0, 11, 16.0f, "minecraft:diamond"),
    BOW_ELITE_POWER_BOW(true, (Tier)Tiers.IRON, 6.0, 20, 15.0f, "minecraft:iron_ingot"),
    BOW_GREEN_MENACE(true, (Tier)Tiers.DIAMOND, 5.0, 17, 13.0f, "minecraft:diamond"),
    BOW_HAUNTED_BOW(true, (Tier)Tiers.NETHERITE, 6.0, 18, 16.0f, "minecraft:netherite_scrap"),
    BOW_HUNTERS_PROMISE(true, (Tier)Tiers.IRON, 6.0, 15, 16.0f, "minecraft:iron_ingot"),
    BOW_HUNTING_BOW(true, (Tier)Tiers.IRON, 6.0, 16, 15.0f, "minecraft:iron_ingot"),
    BOW_LOST_SOULS(true, (Tier)Tiers.NETHERITE, 6.0, 12, 17.0f, "minecraft:netherite_scrap"),
    BOW_MASTERS_BOW(true, (Tier)Tiers.IRON, 6.0, 17, 16.0f, "minecraft:iron_ingot"),
    BOW_NOCTURNAL_BOW(true, (Tier)Tiers.DIAMOND, 6.0, 17, 14.0f, "minecraft:diamond"),
    BOW_PHANTOM_BOW(true, (Tier)Tiers.DIAMOND, 6.0, 20, 14.0f, "minecraft:diamond"),
    BOW_PINK_SCOUNDREL(true, (Tier)Tiers.DIAMOND, 5.0, 17, 13.0f, "minecraft:diamond"),
    BOW_POWER_BOW(true, (Tier)Tiers.IRON, 6.0, 20, 14.0f, "minecraft:iron_ingot"),
    BOW_SABREWING(true, (Tier)Tiers.DIAMOND, 5.0, 10, 13.0f, "minecraft:diamond"),
    BOW_SHIVERING_BOW(true, (Tier)Tiers.DIAMOND, 6.0, 14, 15.0f, "minecraft:diamond"),
    BOW_SNOW_BOW(true, (Tier)Tiers.IRON, 5.0, 16, 13.0f, "minecraft:iron_ingot"),
    BOW_SOUL_BOW(true, (Tier)Tiers.IRON, 6.0, 14, 15.0f, "minecraft:iron_ingot"),
    BOW_TRICKBOW(true, (Tier)Tiers.DIAMOND, 5.0, 12, 12.0f, "minecraft:diamond"),
    BOW_TWIN_BOW(true, (Tier)Tiers.DIAMOND, 5.0, 12, 12.0f, "minecraft:diamond"),
    BOW_TWISTING_VINE_BOW(true, (Tier)Tiers.IRON, 5.0, 15, 13.0f, "minecraft:iron_ingot"),
    BOW_VOID_BOW(true, (Tier)Tiers.DIAMOND, 6.0, 15, 16.0f, "minecraft:diamond"),
    BOW_WEB_BOW(true, (Tier)Tiers.DIAMOND, 5.0, 15, 12.0f, "minecraft:diamond"),
    BOW_WEEPING_VINE_BOW(true, (Tier)Tiers.IRON, 5.0, 15, 13.0f, "minecraft:iron_ingot"),
    BOW_WIND_BOW(true, (Tier)Tiers.DIAMOND, 6.0, 11, 15.0f, "minecraft:diamond"),
    BOW_WINTERS_TOUCH(true, (Tier)Tiers.DIAMOND, 6.0, 15, 14.0f, "minecraft:diamond");

    private final boolean isEnabled;
    private final Tier material;
    private final double projectileDamage;
    private final int drawSpeed;
    private final float range;
    private final String[] repairIngredient;

    private BowsID(boolean isEnabled, Tier material, double projectileDamage, int drawSpeed, float range, String ... repairIngredient) {
        this.isEnabled = isEnabled;
        this.material = material;
        this.projectileDamage = FabricLoader.getInstance().isModLoaded("ranged_weapon_api") ? projectileDamage : 0.0;
        this.drawSpeed = drawSpeed;
        this.range = range;
        this.repairIngredient = repairIngredient;
    }

    public static EnumMap<BowsID, McdwBow> getItemsEnum() {
        return ItemsRegistry.BOW_ITEMS;
    }

    public static HashMap<BowsID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.BOW_SPAWN_RATES;
    }

    public static HashMap<BowsID, IRangedWeaponID.RangedStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.bowStats;
    }

    @Override
    public boolean getIsEnabled() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.bowStats.get((Object)this).isEnabled;
    }

    public McdwBow getItem() {
        return BowsID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return BowsID.getSpawnRates().get(this);
    }

    public HashMap<BowsID, IRangedWeaponID.RangedStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.bowStats;
    }

    @Override
    public IRangedWeaponID.RangedStats getWeaponItemStats() {
        return BowsID.getWeaponStats().get(this);
    }

    @Override
    public IRangedWeaponID.RangedStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.bowStats.get(this);
    }

    @Override
    public Tier getMaterial() {
        return this.material;
    }

    @Override
    public double getProjectileDamage() {
        if (FabricLoader.getInstance().isModLoaded("ranged_weapon_api")) {
            return this.projectileDamage;
        }
        return 0.0;
    }

    @Override
    public int getDrawSpeed() {
        return this.drawSpeed;
    }

    @Override
    public float getRange() {
        return this.range;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public IRangedWeaponID.RangedStats getRangedStats() {
        return new IRangedWeaponID.RangedStats().rangedStats(this.isEnabled, CleanlinessHelper.materialToString(this.material), this.projectileDamage, this.drawSpeed, this.range, this.repairIngredient);
    }

    @Override
    public Map<Enchantment, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case BOW_ANCIENT_BOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.DYNAMO});
            case BOW_BONEBOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.GROWING});
            case BOW_BUBBLE_BOW, BOW_SOUL_BOW, BOW_TWISTING_VINE_BOW, BOW_WEEPING_VINE_BOW, BOW_HUNTING_BOW -> Map.of();
            case BOW_SNOW_BOW, BOW_WINTERS_TOUCH -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.FREEZING});
            case BOW_BUBBLE_BURSTER, BOW_TRICKBOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.RICOCHET});
            case BOW_ECHO_OF_THE_VALLEY -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.GRAVITY, EnchantmentsID.RICOCHET});
            case BOW_BURST_GALE_BOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.CHARGE, EnchantmentsID.GRAVITY});
            case BOW_CALL_OF_THE_VOID -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.FUSE_SHOT, EnchantmentsID.VOID_SHOT});
            case BOW_ELITE_POWER_BOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(2, Enchantments.f_44988_);
            case BOW_GREEN_MENACE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.RICOCHET, EnchantmentsID.POISON_CLOUD});
            case BOW_HAUNTED_BOW, BOW_TWIN_BOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.BONUS_SHOT});
            case BOW_HUNTERS_PROMISE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.REPLENISH});
            case BOW_LOST_SOULS -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.MULTI_SHOT});
            case BOW_NOCTURNAL_BOW, BOW_SHIVERING_BOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.TEMPO_THEFT});
            case BOW_PHANTOM_BOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.MULTI_SHOT, Enchantments.f_44988_});
            case BOW_PINK_SCOUNDREL -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.RICOCHET, EnchantmentsID.WILD_RAGE});
            case BOW_POWER_BOW, BOW_MASTERS_BOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, Enchantments.f_44988_);
            case BOW_SABREWING -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{Enchantments.f_44988_, EnchantmentsID.RADIANCE});
            case BOW_VOID_BOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.VOID_SHOT});
            case BOW_WEB_BOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.COBWEB_SHOT});
            case BOW_WIND_BOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.GRAVITY});
        };
    }

    @Override
    @NotNull
    public ItemStack getInnateEnchantedStack(Item item) {
        return item.m_7968_();
    }

    public McdwBow makeWeapon() {
        McdwBow mcdwBow = new McdwBow(this, CleanlinessHelper.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().drawSpeed, this.getWeaponItemStats().range, this.getWeaponItemStats().repairIngredient);
        BowsID.getItemsEnum().put(this, mcdwBow);
        return mcdwBow;
    }
}

