/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.bases.McdwCrossbow;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.IRangedWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;

public enum CrossbowsID implements IRangedWeaponID,
IInnateEnchantment
{
    CROSSBOW_AUTO_CROSSBOW(true, (Tier)Tiers.IRON, 9.0, 28, 8.0f, "minecraft:iron_ingot"),
    CROSSBOW_AZURE_SEEKER(true, (Tier)Tiers.IRON, 10.0, 28, 8.4f, "minecraft:iron_ingot"),
    CROSSBOW_BABY_CROSSBOW(true, (Tier)Tiers.IRON, 8.0, 23, 7.2f, "minecraft:iron_ingot"),
    CROSSBOW_BURST_CROSSBOW(true, (Tier)Tiers.IRON, 9.0, 28, 8.0f, "minecraft:iron_ingot"),
    CROSSBOW_BUTTERFLY_CROSSBOW(true, (Tier)Tiers.IRON, 10.0, 28, 8.9f, "minecraft:iron_ingot"),
    CROSSBOW_COG_CROSSBOW(true, (Tier)Tiers.IRON, 10.0, 28, 8.4f, "minecraft:iron_ingot"),
    CROSSBOW_CORRUPTED_CROSSBOW(true, (Tier)Tiers.NETHERITE, 16.0, 22, 14.0f, "minecraft:netherite_scrap"),
    CROSSBOW_DOOM_CROSSBOW(true, (Tier)Tiers.NETHERITE, 9.0, 26, 8.0f, "minecraft:netherite_scrap"),
    CROSSBOW_DUAL_CROSSBOW(true, (Tier)Tiers.IRON, 8.0, 24, 7.0f, "minecraft:iron_ingot"),
    CROSSBOW_EXPLODING_CROSSBOW(true, (Tier)Tiers.IRON, 9.0, 28, 8.0f, "minecraft:iron_ingot"),
    CROSSBOW_FERAL_SOUL_CROSSBOW(true, (Tier)Tiers.IRON, 10.0, 28, 9.2f, "minecraft:iron_ingot"),
    CROSSBOW_FIREBOLT_THROWER(true, (Tier)Tiers.IRON, 9.0, 28, 7.9f, "minecraft:iron_ingot"),
    CROSSBOW_HARPOON_CROSSBOW(true, (Tier)Tiers.IRON, 12.0, 28, 11.0f, "minecraft:iron_ingot"),
    CROSSBOW_HARP_CROSSBOW(true, (Tier)Tiers.IRON, 10.0, 28, 8.6f, "minecraft:iron_ingot"),
    CROSSBOW_HEAVY_CROSSBOW(true, (Tier)Tiers.IRON, 9.0, 28, 8.0f, "minecraft:iron_ingot"),
    CROSSBOW_IMPLODING_CROSSBOW(true, (Tier)Tiers.IRON, 9.0, 28, 8.0f, "minecraft:iron_ingot"),
    CROSSBOW_LIGHTNING_HARP_CROSSBOW(true, (Tier)Tiers.DIAMOND, 16.0, 28, 14.2f, "minecraft:diamond"),
    CROSSBOW_NAUTICAL_CROSSBOW(true, (Tier)Tiers.DIAMOND, 16.0, 24, 14.0f, "minecraft:diamond"),
    CROSSBOW_PRIDE_OF_THE_PIGLINS(true, (Tier)Tiers.NETHERITE, 15.0, 20, 13.0f, "minecraft:netherite_scrap"),
    CROSSBOW_RAPID_CROSSBOW(true, (Tier)Tiers.IRON, 9.0, 20, 8.2f, "minecraft:iron_ingot"),
    CROSSBOW_SCATTER_CROSSBOW(true, (Tier)Tiers.IRON, 9.0, 28, 8.0f, "minecraft:iron_ingot"),
    CROSSBOW_SHADOW_CROSSBOW(true, (Tier)Tiers.DIAMOND, 14.0, 25, 12.0f, "minecraft:diamond"),
    CROSSBOW_SLAYER_CROSSBOW(true, (Tier)Tiers.DIAMOND, 10.0, 26, 8.8f, "minecraft:diamond"),
    CROSSBOW_SOUL_CROSSBOW(true, (Tier)Tiers.IRON, 9.0, 28, 8.0f, "minecraft:iron_ingot"),
    CROSSBOW_SOUL_HUNTER_CROSSBOW(true, (Tier)Tiers.DIAMOND, 12.0, 28, 11.0f, "minecraft:diamond"),
    CROSSBOW_SPELLBOUND_CROSSBOW(true, (Tier)Tiers.IRON, 10.0, 28, 8.9f, "minecraft:iron_ingot"),
    CROSSBOW_THE_SLICER(true, (Tier)Tiers.IRON, 12.0, 28, 10.2f, "minecraft:iron_ingot"),
    CROSSBOW_VEILED_CROSSBOW(true, (Tier)Tiers.DIAMOND, 16.0, 22, 14.5f, "minecraft:diamond"),
    CROSSBOW_VOIDCALLER_CROSSBOW(true, (Tier)Tiers.DIAMOND, 14.0, 26, 12.5f, "minecraft:diamond");

    private final boolean isEnabled;
    private final Tier material;
    private final double projectileDamage;
    private final int drawSpeed;
    private final float range;
    private final String[] repairIngredient;

    private CrossbowsID(boolean isEnabled, Tier material, double projectileDamage, int drawSpeed, float range, String ... repairIngredient) {
        this.isEnabled = isEnabled;
        this.material = material;
        this.projectileDamage = FabricLoader.getInstance().isModLoaded("ranged_weapon_api") ? projectileDamage : 0.0;
        this.drawSpeed = drawSpeed;
        this.range = range;
        this.repairIngredient = repairIngredient;
    }

    public static EnumMap<CrossbowsID, McdwCrossbow> getItemsEnum() {
        return ItemsRegistry.CROSSBOW_ITEMS;
    }

    public static HashMap<CrossbowsID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.CROSSBOW_SPAWN_RATES;
    }

    public static HashMap<CrossbowsID, IRangedWeaponID.RangedStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.crossbowStats;
    }

    @Override
    public boolean getIsEnabled() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.crossbowStats.get((Object)this).isEnabled;
    }

    public McdwCrossbow getItem() {
        return CrossbowsID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return CrossbowsID.getSpawnRates().get(this);
    }

    public HashMap<CrossbowsID, IRangedWeaponID.RangedStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.crossbowStats;
    }

    @Override
    public IRangedWeaponID.RangedStats getWeaponItemStats() {
        return CrossbowsID.getWeaponStats().get(this);
    }

    @Override
    public IRangedWeaponID.RangedStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.crossbowStats.get(this);
    }

    @Override
    public Tier getMaterial() {
        return this.material;
    }

    @Override
    public double getProjectileDamage() {
        if (FabricLoader.getInstance().isModLoaded("ranged_weapon_api")) {
            return this.projectileDamage;
        }
        return 0.0;
    }

    @Override
    public int getDrawSpeed() {
        return this.drawSpeed;
    }

    @Override
    public float getRange() {
        return this.range;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public IRangedWeaponID.RangedStats getRangedStats() {
        return new IRangedWeaponID.RangedStats().rangedStats(this.isEnabled, CleanlinessHelper.materialToString(this.material), this.projectileDamage, this.drawSpeed, this.range, this.repairIngredient);
    }

    @Override
    public Map<Enchantment, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case CROSSBOW_AUTO_CROSSBOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.ACCELERATE});
            case CROSSBOW_AZURE_SEEKER, CROSSBOW_BURST_CROSSBOW, CROSSBOW_COG_CROSSBOW, CROSSBOW_DUAL_CROSSBOW, CROSSBOW_RAPID_CROSSBOW, CROSSBOW_SPELLBOUND_CROSSBOW -> Map.of();
            case CROSSBOW_BABY_CROSSBOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.GROWING});
            case CROSSBOW_BUTTERFLY_CROSSBOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.BONUS_SHOT});
            case CROSSBOW_CORRUPTED_CROSSBOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.DYNAMO});
            case CROSSBOW_DOOM_CROSSBOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, Enchantments.f_44989_, 1, Enchantments.f_44988_);
            case CROSSBOW_HARP_CROSSBOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(2, Enchantments.f_44959_);
            case CROSSBOW_HEAVY_CROSSBOW, CROSSBOW_HARPOON_CROSSBOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, Enchantments.f_44989_);
            case CROSSBOW_EXPLODING_CROSSBOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.FUSE_SHOT});
            case CROSSBOW_FERAL_SOUL_CROSSBOW, CROSSBOW_SOUL_CROSSBOW, CROSSBOW_SOUL_HUNTER_CROSSBOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.ENIGMA_RESONATOR});
            case CROSSBOW_FIREBOLT_THROWER -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.FUSE_SHOT, EnchantmentsID.CHAIN_REACTION});
            case CROSSBOW_SCATTER_CROSSBOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, Enchantments.f_44959_);
            case CROSSBOW_IMPLODING_CROSSBOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.FUSE_SHOT, EnchantmentsID.GRAVITY});
            case CROSSBOW_VOIDCALLER_CROSSBOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.GRAVITY});
            case CROSSBOW_LIGHTNING_HARP_CROSSBOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{Enchantments.f_44959_, EnchantmentsID.RICOCHET, EnchantmentsID.THUNDERING});
            case CROSSBOW_NAUTICAL_CROSSBOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, Enchantments.f_44961_, Enchantments.f_44989_);
            case CROSSBOW_PRIDE_OF_THE_PIGLINS, CROSSBOW_THE_SLICER -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, Enchantments.f_44961_);
            case CROSSBOW_SHADOW_CROSSBOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.SHADOW_SHOT});
            case CROSSBOW_SLAYER_CROSSBOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{Enchantments.f_44988_, EnchantmentsID.RICOCHET});
            case CROSSBOW_VEILED_CROSSBOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.SHADOW_SHOT, EnchantmentsID.SHADOW_BARB});
        };
    }

    @Override
    @NotNull
    public ItemStack getInnateEnchantedStack(Item item) {
        return item.m_7968_();
    }

    public McdwCrossbow makeWeapon() {
        McdwCrossbow mcdwCrossbow = new McdwCrossbow(this, CleanlinessHelper.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().drawSpeed, this.getWeaponItemStats().range, this.getWeaponItemStats().repairIngredient);
        CrossbowsID.getItemsEnum().put(this, mcdwCrossbow);
        return mcdwCrossbow;
    }
}

