/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.bases.McdwDagger;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.NotNull;

public enum DaggersID implements IMeleeWeaponID,
IInnateEnchantment
{
    DAGGER_BACKSTABBER(true, (Tier)Tiers.DIAMOND, 1, -1.7f, "minecraft:diamond"),
    DAGGER_CHILL_GALE_KNIFE(true, (Tier)Tiers.DIAMOND, 2, -2.2f, "minecraft:diamond"),
    DAGGER_DAGGER(true, (Tier)Tiers.IRON, 1, -1.5f, "minecraft:iron_ingot"),
    DAGGER_FANGS_OF_FROST(true, (Tier)Tiers.IRON, 1, -1.5f, "minecraft:iron_ingot"),
    DAGGER_MOON(true, (Tier)Tiers.IRON, 1, -1.5f, "minecraft:iron_ingot"),
    DAGGER_RESOLUTE_TEMPEST_KNIFE(true, (Tier)Tiers.IRON, 2, -2.2f, "minecraft:iron_ingot"),
    DAGGER_SHEAR_DAGGER(true, (Tier)Tiers.IRON, 0, -1.5f, "minecraft:iron_ingot"),
    DAGGER_SWIFT_STRIKER(true, (Tier)Tiers.NETHERITE, 1, -1.7f, "minecraft:netherite_scrap"),
    DAGGER_TEMPEST_KNIFE(true, (Tier)Tiers.IRON, 2, -2.2f, "minecraft:iron_ingot"),
    DAGGER_THE_BEGINNING(true, (Tier)Tiers.NETHERITE, 1, -1.8f, "minecraft:netherite_scrap"),
    DAGGER_THE_END(true, (Tier)Tiers.NETHERITE, 1, -1.8f, "minecraft:netherite_scrap"),
    DAGGER_VOID_TOUCHED_BLADE(true, (Tier)Tiers.DIAMOND, 1, -1.8f, "minecraft:diamond");

    private final boolean isEnabled;
    private final Tier material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private DaggersID(boolean isEnabled, Tier material, int damage, float attackSpeed, String ... repairIngredient) {
        this.isEnabled = isEnabled;
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static EnumMap<DaggersID, McdwDagger> getItemsEnum() {
        return ItemsRegistry.DAGGER_ITEMS;
    }

    public static HashMap<DaggersID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.DAGGER_SPAWN_RATES;
    }

    public static HashMap<DaggersID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.daggerStats;
    }

    @Override
    public boolean getIsEnabled() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.daggerStats.get((Object)this).isEnabled;
    }

    public McdwDagger getItem() {
        return DaggersID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return DaggersID.getSpawnRates().get(this);
    }

    public HashMap<DaggersID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.daggerStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return DaggersID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.daggerStats.get(this);
    }

    @Override
    public Tier getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getMeleeStats() {
        return new IMeleeWeaponID.MeleeStats().meleeStats(this.isEnabled, CleanlinessHelper.materialToString(this.material), this.damage, this.attackSpeed, this.repairIngredient);
    }

    @Override
    public Map<Enchantment, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case DAGGER_BACKSTABBER -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.AMBUSH});
            case DAGGER_CHILL_GALE_KNIFE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.RUSHDOWN, EnchantmentsID.FREEZING});
            case DAGGER_FANGS_OF_FROST -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.FREEZING});
            case DAGGER_DAGGER -> Map.of();
            case DAGGER_TEMPEST_KNIFE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.RUSHDOWN});
            case DAGGER_MOON -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.ENIGMA_RESONATOR});
            case DAGGER_RESOLUTE_TEMPEST_KNIFE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.COMMITTED, EnchantmentsID.RUSHDOWN});
            case DAGGER_SHEAR_DAGGER -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.SWIRLING});
            case DAGGER_SWIFT_STRIKER -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.AMBUSH, EnchantmentsID.RUSHDOWN});
            case DAGGER_THE_BEGINNING -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.LEECHING});
            case DAGGER_THE_END, DAGGER_VOID_TOUCHED_BLADE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.VOID_STRIKE});
        };
    }

    @Override
    @NotNull
    public ItemStack getInnateEnchantedStack(Item item) {
        return item.m_7968_();
    }

    public McdwDagger makeWeapon() {
        McdwDagger mcdwDagger = new McdwDagger(this, CleanlinessHelper.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        DaggersID.getItemsEnum().put(this, mcdwDagger);
        return mcdwDagger;
    }
}

