/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.bases.McdwHammer;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;

public enum HammersID implements IMeleeWeaponID,
IInnateEnchantment
{
    HAMMER_BONECLUB(true, (Tier)Tiers.IRON, 7, -3.2f, "minecraft:bone_block"),
    HAMMER_BONE_CUDGEL(true, (Tier)Tiers.NETHERITE, 7, -3.2f, "minecraft:netherite_scrap"),
    HAMMER_FLAIL(true, (Tier)Tiers.IRON, 5, -2.8f, "minecraft:iron_ingot"),
    HAMMER_GRAVITY(true, (Tier)Tiers.DIAMOND, 6, -3.2f, "minecraft:diamond"),
    HAMMER_GREAT_HAMMER(true, (Tier)Tiers.IRON, 6, -3.2f, "minecraft:iron_ingot"),
    HAMMER_MACE(true, (Tier)Tiers.IRON, 5, -2.8f, "minecraft:iron_ingot"),
    HAMMER_STORMLANDER(true, (Tier)Tiers.DIAMOND, 7, -3.2f, "minecraft:diamond"),
    HAMMER_SUNS_GRACE(true, (Tier)Tiers.DIAMOND, 4, -2.8f, "minecraft:diamond");

    private final boolean isEnabled;
    private final Tier material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private HammersID(boolean isEnabled, Tier material, int damage, float attackSpeed, String ... repairIngredient) {
        this.isEnabled = isEnabled;
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static EnumMap<HammersID, McdwHammer> getItemsEnum() {
        return ItemsRegistry.HAMMER_ITEMS;
    }

    public static HashMap<HammersID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.HAMMER_SPAWN_RATES;
    }

    public static HashMap<HammersID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.hammerStats;
    }

    @Override
    public boolean getIsEnabled() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.hammerStats.get((Object)this).isEnabled;
    }

    public McdwHammer getItem() {
        return HammersID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return HammersID.getSpawnRates().get(this);
    }

    public HashMap<HammersID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.hammerStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return HammersID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.hammerStats.get(this);
    }

    @Override
    public Tier getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getMeleeStats() {
        return new IMeleeWeaponID.MeleeStats().meleeStats(this.isEnabled, CleanlinessHelper.materialToString(this.material), this.damage, this.attackSpeed, this.repairIngredient);
    }

    @Override
    public Map<Enchantment, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case HAMMER_BONECLUB -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, Enchantments.f_44980_);
            case HAMMER_GREAT_HAMMER, HAMMER_MACE -> Map.of();
            case HAMMER_FLAIL -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.CHAINS});
            case HAMMER_BONE_CUDGEL -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{Enchantments.f_44980_, EnchantmentsID.ILLAGERS_BANE});
            case HAMMER_GRAVITY -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.GRAVITY});
            case HAMMER_STORMLANDER -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.THUNDERING});
            case HAMMER_SUNS_GRACE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.RADIANCE});
        };
    }

    @Override
    @NotNull
    public ItemStack getInnateEnchantedStack(Item item) {
        return item.m_7968_();
    }

    public McdwHammer makeWeapon() {
        McdwHammer mcdwHammer = new McdwHammer(this, CleanlinessHelper.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        HammersID.getItemsEnum().put(this, mcdwHammer);
        return mcdwHammer;
    }
}

