/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.bases.McdwLongbow;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.IRangedWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;

public enum LongbowsID implements IRangedWeaponID,
IInnateEnchantment
{
    BOW_GUARDIAN_BOW(true, (Tier)Tiers.DIAMOND, 8.0, 30, 19.0f, "minecraft:diamond"),
    BOW_LONGBOW(true, (Tier)Tiers.IRON, 7.0, 25, 17.0f, "minecraft:planks"),
    BOW_RED_SNAKE(true, (Tier)Tiers.DIAMOND, 7.0, 30, 18.0f, "minecraft:diamond");

    public final boolean isEnabled;
    public final Tier material;
    public final double projectileDamage;
    public final int drawSpeed;
    public final float range;
    private final String[] repairIngredient;

    private LongbowsID(boolean isEnabled, Tier material, double projectileDamage, int drawSpeed, float range, String ... repairIngredient) {
        this.isEnabled = isEnabled;
        this.material = material;
        this.projectileDamage = FabricLoader.getInstance().isModLoaded("ranged_weapon_api") ? projectileDamage : 0.0;
        this.drawSpeed = drawSpeed;
        this.range = range;
        this.repairIngredient = repairIngredient;
    }

    public static EnumMap<LongbowsID, McdwLongbow> getItemsEnum() {
        return ItemsRegistry.LONGBOW_ITEMS;
    }

    public static HashMap<LongbowsID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.LONGBOW_SPAWN_RATES;
    }

    public static HashMap<LongbowsID, IRangedWeaponID.RangedStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.longbowStats;
    }

    @Override
    public boolean getIsEnabled() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.longbowStats.get((Object)this).isEnabled;
    }

    public McdwLongbow getItem() {
        return LongbowsID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return LongbowsID.getSpawnRates().get(this);
    }

    public HashMap<LongbowsID, IRangedWeaponID.RangedStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.longbowStats;
    }

    @Override
    public IRangedWeaponID.RangedStats getWeaponItemStats() {
        return LongbowsID.getWeaponStats().get(this);
    }

    @Override
    public IRangedWeaponID.RangedStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.longbowStats.get(this);
    }

    @Override
    public Tier getMaterial() {
        return this.material;
    }

    @Override
    public double getProjectileDamage() {
        if (FabricLoader.getInstance().isModLoaded("ranged_weapon_api")) {
            return this.projectileDamage;
        }
        return 0.0;
    }

    @Override
    public int getDrawSpeed() {
        return this.drawSpeed;
    }

    @Override
    public float getRange() {
        return this.range;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public IRangedWeaponID.RangedStats getRangedStats() {
        return new IRangedWeaponID.RangedStats().rangedStats(this.isEnabled, CleanlinessHelper.materialToString(this.material), this.projectileDamage, this.drawSpeed, this.range, this.repairIngredient);
    }

    @Override
    public Map<Enchantment, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case BOW_LONGBOW -> Map.of();
            case BOW_GUARDIAN_BOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(2, Enchantments.f_44988_);
            case BOW_RED_SNAKE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{Enchantments.f_44988_, EnchantmentsID.FUSE_SHOT});
        };
    }

    @Override
    @NotNull
    public ItemStack getInnateEnchantedStack(Item item) {
        return item.m_7968_();
    }

    public McdwLongbow makeWeapon() {
        McdwLongbow mcdwLongbow = new McdwLongbow(this, CleanlinessHelper.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().drawSpeed, this.getWeaponItemStats().range, this.getWeaponItemStats().repairIngredient);
        LongbowsID.getItemsEnum().put(this, mcdwLongbow);
        return mcdwLongbow;
    }
}

