/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.bases.McdwPick;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;

public enum PicksID implements IMeleeWeaponID
{
    PICK_DIAMOND_PICKAXE_VAR(true, (Tier)Tiers.DIAMOND, 1, -2.8f, "minecraft:diamond"),
    PICK_HAILING_PINNACLE(true, (Tier)Tiers.DIAMOND, 1, -2.8f, "minecraft:diamond"),
    PICK_HOWLING_PICK(true, (Tier)Tiers.IRON, 1, -2.8f, "minecraft:iron_ingot"),
    PICK_MOUNTAINEER_PICK(true, (Tier)Tiers.IRON, 1, -2.8f, "minecraft:iron_ingot");

    private final boolean isEnabled;
    private final Tier material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private PicksID(boolean isEnabled, Tier material, int damage, float attackSpeed, String ... repairIngredient) {
        this.isEnabled = isEnabled;
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static EnumMap<PicksID, McdwPick> getItemsEnum() {
        return ItemsRegistry.PICK_ITEMS;
    }

    public static HashMap<PicksID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.PICK_SPAWN_RATES;
    }

    public static HashMap<PicksID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.pickStats;
    }

    @Override
    public boolean getIsEnabled() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.pickStats.get((Object)this).isEnabled;
    }

    public McdwPick getItem() {
        return PicksID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return PicksID.getSpawnRates().get(this);
    }

    public HashMap<PicksID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.pickStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return PicksID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.pickStats.get(this);
    }

    @Override
    public Tier getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getMeleeStats() {
        return new IMeleeWeaponID.MeleeStats().meleeStats(this.isEnabled, CleanlinessHelper.materialToString(this.material), this.damage, this.attackSpeed, this.repairIngredient);
    }

    public McdwPick makeWeapon() {
        McdwPick mcdwPick = new McdwPick(CleanlinessHelper.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        PicksID.getItemsEnum().put(this, mcdwPick);
        return mcdwPick;
    }
}

