/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.bases.McdwScythe;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.EnchantsRegistry;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.NotNull;

public enum ScythesID implements IMeleeWeaponID,
IInnateEnchantment
{
    SCYTHE_FROST_SCYTHE(true, (Tier)Tiers.DIAMOND, 4, -2.9f, "minecraft:diamond"),
    SCYTHE_JAILORS_SCYTHE(true, (Tier)Tiers.IRON, 4, -2.9f, "minecraft:iron_ingot"),
    SCYTHE_SKULL_SCYTHE(true, (Tier)Tiers.DIAMOND, 4, -2.9f, "minecraft:diamond"),
    SCYTHE_SOUL_SCYTHE(true, (Tier)Tiers.DIAMOND, 3, -2.9f, "minecraft:diamond");

    private final boolean isEnabled;
    private final Tier material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private ScythesID(boolean isEnabled, Tier material, int damage, float attackSpeed, String ... repairIngredient) {
        this.isEnabled = isEnabled;
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static EnumMap<ScythesID, McdwScythe> getItemsEnum() {
        return ItemsRegistry.SCYTHE_ITEMS;
    }

    public static HashMap<ScythesID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.SCYTHE_SPAWN_RATES;
    }

    public static HashMap<ScythesID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.scytheStats;
    }

    @Override
    public boolean getIsEnabled() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.scytheStats.get((Object)this).isEnabled;
    }

    public McdwScythe getItem() {
        return ScythesID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return ScythesID.getSpawnRates().get(this);
    }

    public HashMap<ScythesID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.scytheStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return ScythesID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.scytheStats.get(this);
    }

    @Override
    public Tier getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getMeleeStats() {
        return new IMeleeWeaponID.MeleeStats().meleeStats(this.isEnabled, CleanlinessHelper.materialToString(this.material), this.damage, this.attackSpeed, this.repairIngredient);
    }

    @Override
    public Map<Enchantment, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case SCYTHE_FROST_SCYTHE, SCYTHE_SKULL_SCYTHE -> Map.of(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.FREEZING), 1);
            case SCYTHE_JAILORS_SCYTHE -> Map.of(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.CHAINS), 1);
            case SCYTHE_SOUL_SCYTHE -> Map.of(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.SOUL_DEVOURER), 1);
        };
    }

    @Override
    @NotNull
    public ItemStack getInnateEnchantedStack(Item item) {
        return item.m_7968_();
    }

    public McdwScythe makeWeapon() {
        McdwScythe mcdwScythe = new McdwScythe(this, CleanlinessHelper.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        ScythesID.getItemsEnum().put(this, mcdwScythe);
        return mcdwScythe;
    }
}

