/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.bases.McdwShield;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.IShieldID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;

public enum ShieldsID implements IShieldID
{
    SHIELD_ROYAL_GUARD(true, (Tier)Tiers.DIAMOND, "minecraft:iron_ingot", "minecraft:gold_ingot"),
    SHIELD_TOWER_GUARD(true, (Tier)Tiers.DIAMOND, "minecraft:iron_ingot", "minecraft:gold_ingot", "minecraft:copper_ingot"),
    SHIELD_VANGUARD(true, (Tier)Tiers.DIAMOND, "minecraft:planks", "minecraft:iron_ingot");

    private final boolean isEnabled;
    private final Tier material;
    private final String[] repairIngredient;

    private ShieldsID(boolean isEnabled, Tier material, String ... repairIngredient) {
        this.isEnabled = isEnabled;
        this.material = material;
        this.repairIngredient = repairIngredient;
    }

    public static EnumMap<ShieldsID, McdwShield> getItemsEnum() {
        return ItemsRegistry.SHIELD_ITEMS;
    }

    public static HashMap<ShieldsID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.SHIELD_SPAWN_RATES;
    }

    public static HashMap<ShieldsID, IShieldID.ShieldStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.shieldStats;
    }

    @Override
    public boolean getIsEnabled() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.shieldStats.get((Object)this).isEnabled;
    }

    public McdwShield getItem() {
        return ShieldsID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return ShieldsID.getSpawnRates().get(this);
    }

    @Override
    public HashMap<ShieldsID, IShieldID.ShieldStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.shieldStats;
    }

    @Override
    public IShieldID.ShieldStats getWeaponItemStats() {
        return ShieldsID.getWeaponStats().get(this);
    }

    @Override
    public IShieldID.ShieldStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return this.getWeaponStats(mcdwNewStatsConfig).get(this);
    }

    @Override
    public Tier getMaterial() {
        return this.material;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public IShieldID.ShieldStats getShieldStats() {
        return new IShieldID.ShieldStats().shieldStats(this.isEnabled, CleanlinessHelper.materialToString(this.material), this.repairIngredient);
    }

    public McdwShield makeWeapon() {
        McdwShield mcdwShield = new McdwShield(CleanlinessHelper.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().repairIngredient);
        ShieldsID.getItemsEnum().put(this, mcdwShield);
        return mcdwShield;
    }
}

