/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.bases.McdwShortbow;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.IRangedWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.NotNull;

public enum ShortbowsID implements IRangedWeaponID,
IInnateEnchantment
{
    BOW_LOVE_SPELL_BOW(true, (Tier)Tiers.IRON, 3.0, 9, 8.0f, "minecraft:iron_ingot"),
    BOW_MECHANICAL_SHORTBOW(true, (Tier)Tiers.IRON, 4.0, 9, 9.0f, "minecraft:iron_ingot"),
    BOW_PURPLE_STORM(true, (Tier)Tiers.IRON, 3.0, 9, 8.0f, "minecraft:iron_ingot"),
    BOW_SHORTBOW(true, (Tier)Tiers.IRON, 3.0, 9, 8.0f, "minecraft:planks");

    private final boolean isEnabled;
    private final Tier material;
    private final double projectileDamage;
    private final int drawSpeed;
    private final float range;
    private final String[] repairIngredient;

    private ShortbowsID(boolean isEnabled, Tier material, double projectileDamage, int drawSpeed, float range, String ... repairIngredient) {
        this.isEnabled = isEnabled;
        this.material = material;
        this.projectileDamage = FabricLoader.getInstance().isModLoaded("ranged_weapon_api") ? projectileDamage : 0.0;
        this.drawSpeed = drawSpeed;
        this.range = range;
        this.repairIngredient = repairIngredient;
    }

    public static EnumMap<ShortbowsID, McdwShortbow> getItemsEnum() {
        return ItemsRegistry.SHORTBOW_ITEMS;
    }

    public static HashMap<ShortbowsID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.SHORTBOW_SPAWN_RATES;
    }

    public static HashMap<ShortbowsID, IRangedWeaponID.RangedStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.shortbowStats;
    }

    @Override
    public boolean getIsEnabled() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.shortbowStats.get((Object)this).isEnabled;
    }

    public McdwShortbow getItem() {
        return ShortbowsID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return ShortbowsID.getSpawnRates().get(this);
    }

    public HashMap<ShortbowsID, IRangedWeaponID.RangedStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.shortbowStats;
    }

    @Override
    public IRangedWeaponID.RangedStats getWeaponItemStats() {
        return ShortbowsID.getWeaponStats().get(this);
    }

    @Override
    public IRangedWeaponID.RangedStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.shortbowStats.get(this);
    }

    @Override
    public Tier getMaterial() {
        return this.material;
    }

    @Override
    public double getProjectileDamage() {
        if (FabricLoader.getInstance().isModLoaded("ranged_weapon_api")) {
            return this.projectileDamage;
        }
        return 0.0;
    }

    @Override
    public int getDrawSpeed() {
        return this.drawSpeed;
    }

    @Override
    public float getRange() {
        return this.range;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public IRangedWeaponID.RangedStats getRangedStats() {
        return new IRangedWeaponID.RangedStats().rangedStats(this.isEnabled, CleanlinessHelper.materialToString(this.material), this.projectileDamage, this.drawSpeed, this.range, this.repairIngredient);
    }

    @Override
    public Map<Enchantment, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case BOW_LOVE_SPELL_BOW -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.WILD_RAGE});
            case BOW_MECHANICAL_SHORTBOW, BOW_PURPLE_STORM -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.ACCELERATE});
            case BOW_SHORTBOW -> Map.of();
        };
    }

    @Override
    @NotNull
    public ItemStack getInnateEnchantedStack(Item item) {
        return item.m_7968_();
    }

    public McdwShortbow makeWeapon() {
        McdwShortbow mcdwShortbow = new McdwShortbow(this, CleanlinessHelper.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().drawSpeed, this.getWeaponItemStats().range, this.getWeaponItemStats().repairIngredient);
        ShortbowsID.getItemsEnum().put(this, mcdwShortbow);
        return mcdwShortbow;
    }
}

