/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.bases.McdwSpear;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;

public enum SpearsID implements IMeleeWeaponID,
IInnateEnchantment
{
    SPEAR_SPEAR(true, (Tier)Tiers.IRON, 4, -2.5f, "minecraft:iron_ingot"),
    SPEAR_WHISPERING_SPEAR(true, (Tier)Tiers.IRON, 5, -2.5f, "minecraft:iron_ingot"),
    SPEAR_FORTUNE(true, (Tier)Tiers.IRON, 5, -2.5f, "minecraft:iron_ingot");

    private final boolean isEnabled;
    private final Tier material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private SpearsID(boolean isEnabled, Tier material, int damage, float attackSpeed, String ... repairIngredient) {
        this.isEnabled = isEnabled;
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static EnumMap<SpearsID, McdwSpear> getItemsEnum() {
        return ItemsRegistry.SPEAR_ITEMS;
    }

    public static HashMap<SpearsID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.SPEAR_SPAWN_RATES;
    }

    public static HashMap<SpearsID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.spearStats;
    }

    @Override
    public boolean getIsEnabled() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.spearStats.get((Object)this).isEnabled;
    }

    public McdwSpear getItem() {
        return SpearsID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return SpearsID.getSpawnRates().get(this);
    }

    public HashMap<SpearsID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.spearStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return SpearsID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.spearStats.get(this);
    }

    @Override
    public Tier getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getMeleeStats() {
        return new IMeleeWeaponID.MeleeStats().meleeStats(this.isEnabled, CleanlinessHelper.materialToString(this.material), this.damage, this.attackSpeed, this.repairIngredient);
    }

    @Override
    public Map<Enchantment, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case SPEAR_SPEAR -> Map.of();
            case SPEAR_WHISPERING_SPEAR -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.ECHO});
            case SPEAR_FORTUNE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, Enchantments.f_44982_);
        };
    }

    @Override
    @NotNull
    public ItemStack getInnateEnchantedStack(Item item) {
        return item.m_7968_();
    }

    public McdwSpear makeWeapon() {
        McdwSpear mcdwSpear = new McdwSpear(this, CleanlinessHelper.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        SpearsID.getItemsEnum().put(this, mcdwSpear);
        return mcdwSpear;
    }
}

