/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.bases.McdwSword;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;

public enum SwordsID implements IMeleeWeaponID,
IInnateEnchantment
{
    SWORD_BEESTINGER(true, (Tier)Tiers.IRON, 0, -1.1f, "minecraft:iron_ingot"),
    SWORD_BROADSWORD(true, (Tier)Tiers.IRON, 5, -3.0f, "minecraft:iron_ingot"),
    SWORD_BROKEN_SAWBLADE(true, (Tier)Tiers.IRON, 3, -2.4f, "minecraft:iron_ingot"),
    SWORD_CLAYMORE(true, (Tier)Tiers.IRON, 7, -3.2f, "minecraft:iron_ingot"),
    SWORD_CORAL_BLADE(true, (Tier)Tiers.IRON, 3, -2.4f, "minecraft:iron_ingot"),
    SWORD_CUTLASS(true, (Tier)Tiers.IRON, 2, -2.3f, "minecraft:iron_ingot"),
    SWORD_DANCERS_SWORD(true, (Tier)Tiers.IRON, 3, -2.0f, "minecraft:iron_ingot"),
    SWORD_DARK_KATANA(true, (Tier)Tiers.NETHERITE, 4, -2.9f, "minecraft:netherite_scrap"),
    SWORD_DIAMOND_SWORD_VAR(true, (Tier)Tiers.DIAMOND, 3, -2.4f, "minecraft:diamond"),
    SWORD_FREEZING_FOIL(true, (Tier)Tiers.IRON, 1, -1.1f, "minecraft:iron_ingot"),
    SWORD_FROST_SLAYER(true, (Tier)Tiers.DIAMOND, 6, -3.2f, "minecraft:diamond"),
    SWORD_GREAT_AXEBLADE(true, (Tier)Tiers.IRON, 7, -3.2f, "minecraft:iron_ingot"),
    SWORD_HAWKBRAND(true, (Tier)Tiers.IRON, 6, -2.9f, "minecraft:iron_ingot"),
    SWORD_HEARTSTEALER(true, (Tier)Tiers.DIAMOND, 6, -3.2f, "minecraft:diamond"),
    SWORD_IRON_SWORD_VAR(true, (Tier)Tiers.IRON, 3, -2.4f, "minecraft:iron_ingot"),
    SWORD_KATANA(true, (Tier)Tiers.IRON, 4, -2.9f, "minecraft:iron_ingot"),
    SWORD_MASTERS_KATANA(true, (Tier)Tiers.DIAMOND, 4, -2.9f, "minecraft:diamond"),
    SWORD_MECHANIZED_SAWBLADE(true, (Tier)Tiers.DIAMOND, 3, -2.4f, "minecraft:blaze_rod"),
    SWORD_NAMELESS_BLADE(true, (Tier)Tiers.IRON, 4, -2.3f, "minecraft:iron_ingot"),
    SWORD_OBSIDIAN_CLAYMORE(true, (Tier)Tiers.NETHERITE, 6, -3.3f, "minecraft:netherite_scrap"),
    SWORD_RAPIER(true, (Tier)Tiers.IRON, 0, -1.14f, "minecraft:iron_ingot"),
    SWORD_SINISTER(true, (Tier)Tiers.IRON, 6, -2.9f, "minecraft:iron_ingot"),
    SWORD_SPONGE_STRIKER(true, (Tier)Tiers.DIAMOND, 3, -2.4f, "minecraft:diamond"),
    SWORD_THE_STARLESS_NIGHT(true, (Tier)Tiers.NETHERITE, 6, -3.3f, "minecraft:netherite_scrap");

    private final boolean isEnabled;
    private final Tier material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private SwordsID(boolean isEnabled, Tier material, int damage, float attackSpeed, String ... repairIngredient) {
        this.isEnabled = isEnabled;
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static EnumMap<SwordsID, McdwSword> getItemsEnum() {
        return ItemsRegistry.SWORD_ITEMS;
    }

    public static HashMap<SwordsID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.SWORD_SPAWN_RATES;
    }

    public static HashMap<SwordsID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.swordStats;
    }

    @Override
    public boolean getIsEnabled() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.swordStats.get((Object)this).isEnabled;
    }

    public McdwSword getItem() {
        return SwordsID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return SwordsID.getSpawnRates().get(this);
    }

    public HashMap<SwordsID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.swordStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return SwordsID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.swordStats.get(this);
    }

    @Override
    public Tier getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getMeleeStats() {
        return new IMeleeWeaponID.MeleeStats().meleeStats(this.isEnabled, CleanlinessHelper.materialToString(this.material), this.damage, this.attackSpeed, this.repairIngredient);
    }

    @Override
    public Map<Enchantment, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case SWORD_BEESTINGER -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.BUSY_BEE});
            case SWORD_BROKEN_SAWBLADE, SWORD_CORAL_BLADE, SWORD_CUTLASS, SWORD_DIAMOND_SWORD_VAR, SWORD_IRON_SWORD_VAR, SWORD_KATANA, SWORD_OBSIDIAN_CLAYMORE, SWORD_RAPIER -> Map.of();
            case SWORD_CLAYMORE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, Enchantments.f_44980_);
            case SWORD_BROADSWORD -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{Enchantments.f_44980_, EnchantmentsID.SWIRLING});
            case SWORD_DANCERS_SWORD -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.RAMPAGING});
            case SWORD_DARK_KATANA -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.SMITING});
            case SWORD_FREEZING_FOIL -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.FREEZING});
            case SWORD_FROST_SLAYER -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{Enchantments.f_44980_, EnchantmentsID.FREEZING});
            case SWORD_GREAT_AXEBLADE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{Enchantments.f_44980_, EnchantmentsID.DYNAMO});
            case SWORD_HAWKBRAND, SWORD_MASTERS_KATANA, SWORD_SINISTER -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.CRITICAL_HIT});
            case SWORD_HEARTSTEALER -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{Enchantments.f_44980_, EnchantmentsID.LEECHING});
            case SWORD_MECHANIZED_SAWBLADE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, Enchantments.f_44981_);
            case SWORD_NAMELESS_BLADE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.WEAKENING});
            case SWORD_SPONGE_STRIKER -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.ENIGMA_RESONATOR});
            case SWORD_THE_STARLESS_NIGHT -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.SHARED_PAIN});
        };
    }

    @Override
    @NotNull
    public ItemStack getInnateEnchantedStack(Item item) {
        return item.m_7968_();
    }

    public McdwSword makeWeapon() {
        McdwSword mcdwSword = new McdwSword(this, CleanlinessHelper.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        SwordsID.getItemsEnum().put(this, mcdwSword);
        return mcdwSword;
    }
}

