/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.bases.McdwWhip;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.NotNull;

public enum WhipsID implements IMeleeWeaponID,
IInnateEnchantment
{
    WHIP_VINE_WHIP(true, (Tier)Tiers.IRON, 5, -3.1f, "minecraft:vine"),
    WHIP_WHIP(true, (Tier)Tiers.IRON, 3, -3.1f, "minecraft:string");

    private final boolean isEnabled;
    private final Tier material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private WhipsID(boolean isEnabled, Tier material, int damage, float attackSpeed, String ... repairIngredient) {
        this.isEnabled = isEnabled;
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static EnumMap<WhipsID, McdwWhip> getItemsEnum() {
        return ItemsRegistry.WHIP_ITEMS;
    }

    public static HashMap<WhipsID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.WHIP_SPAWN_RATES;
    }

    public static HashMap<WhipsID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.whipStats;
    }

    @Override
    public boolean getIsEnabled() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.whipStats.get((Object)this).isEnabled;
    }

    public McdwWhip getItem() {
        return WhipsID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return WhipsID.getSpawnRates().get(this);
    }

    public HashMap<WhipsID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.whipStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return WhipsID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.whipStats.get(this);
    }

    @Override
    public Tier getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getMeleeStats() {
        return new IMeleeWeaponID.MeleeStats().meleeStats(this.isEnabled, CleanlinessHelper.materialToString(this.material), this.damage, this.attackSpeed, this.repairIngredient);
    }

    @Override
    public Map<Enchantment, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case WHIP_WHIP -> Map.of();
            case WHIP_VINE_WHIP -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.JUNGLE_POISON});
        };
    }

    @Override
    @NotNull
    public ItemStack getInnateEnchantedStack(Item item) {
        return item.m_7968_();
    }

    public McdwWhip makeWeapon() {
        McdwWhip mcdwWhip = new McdwWhip(this, CleanlinessHelper.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        WhipsID.getItemsEnum().put(this, mcdwWhip);
        return mcdwWhip;
    }
}

