/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.mixin.mcdw;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IMcdwEnchantedArrow;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.api.util.ProjectileEffectHelper;
import chronosacaria.mcdw.api.util.RangedAttackHelper;
import chronosacaria.mcdw.bases.McdwBow;
import chronosacaria.mcdw.bases.McdwLongbow;
import chronosacaria.mcdw.bases.McdwShortbow;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.registries.EnchantsRegistry;
import chronosacaria.mcdw.registries.StatusEffectsRegistry;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={BowItem.class})
public abstract class BowItemMixin {
    @Unique
    private int overcharge;
    @Unique
    private LivingEntity livingEntity;

    @Unique
    public void setLivingEntity(LivingEntity livingEntity) {
        this.livingEntity = livingEntity;
    }

    @Inject(method={"onStoppedUsing"}, at={@At(value="HEAD")})
    public void mcdw$onStoppedUsingBow(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks, CallbackInfo ci) {
        int multiShotLevel;
        int bonusShotLevel;
        if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.BONUS_SHOT).mcdw$getIsEnabled() && (bonusShotLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.BONUS_SHOT), (ItemStack)stack)) > 0) {
            float damageMultiplier = 0.03f + (float)bonusShotLevel * 0.07f;
            float arrowVelocity = RangedAttackHelper.getVanillaOrModdedBowArrowVelocity(stack, remainingUseTicks);
            if (arrowVelocity >= 0.1f) {
                ProjectileEffectHelper.mcdw$spawnExtraArrows(user, user, 1, 10, damageMultiplier);
            }
        }
        if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.MULTI_SHOT).mcdw$getIsEnabled() && (multiShotLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.MULTI_SHOT), (ItemStack)stack)) > 0) {
            AbstractArrow projectile = ProjectileEffectHelper.mcdw$createAbstractArrow(user);
            LivingEntity target = user.m_21214_();
            if (target != null) {
                double d = target.m_20185_() - user.m_20185_();
                double e = target.m_20227_(0.3333333333333333) - projectile.m_20186_();
                double f = target.m_20189_() - user.m_20189_();
                double g = Mth.m_14116_((float)((float)(d * d + f * f)));
                projectile.m_6686_(d, e + g * (double)0.2f, f, 1.6f, (float)(14 - user.m_9236_().m_46791_().m_19028_() * 4));
                projectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                world.m_7967_((Entity)projectile);
            }
        }
    }

    @Inject(method={"onStoppedUsing"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/projectile/PersistentProjectileEntity;setVelocity(Lnet/minecraft/entity/Entity;FFFFF)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void mcdw$applyBowEnchantmentLevel(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks, CallbackInfo ci, Player playerEntity, boolean bl, ItemStack itemStack, int i, float f, boolean bl2, ArrowItem arrowItem, AbstractArrow ppe) {
        if (this.overcharge > 0) {
            ((IMcdwEnchantedArrow)ppe).mcdw$setOvercharge(this.overcharge);
        }
        CleanlinessHelper.addPPEEnchantments(stack, (IMcdwEnchantedArrow)ppe);
    }

    @Inject(method={"onStoppedUsing"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/BowItem;getMaxUseTime(Lnet/minecraft/item/ItemStack;)I")})
    private void mcdw$livingEntityGetter(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks, CallbackInfo ci) {
        this.setLivingEntity(user);
    }

    @ModifyArg(method={"onStoppedUsing"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/BowItem;getPullProgress(I)F"), index=0)
    private int mcdw$acceleratedPullProgress(int value) {
        int overchargeLevel;
        MobEffectInstance accelerateInstance;
        int consecutiveShots;
        int accelerateLevel;
        ItemStack bowStack = this.livingEntity.m_21211_();
        Item item = bowStack.m_41720_();
        if (item instanceof McdwShortbow) {
            McdwShortbow mcdwShortBow = (McdwShortbow)item;
            value = (int)((float)value / (mcdwShortBow.getDrawSpeed() / 20.0f));
        } else {
            item = bowStack.m_41720_();
            if (item instanceof McdwLongbow) {
                McdwLongbow mcdwLongBow = (McdwLongbow)item;
                value = (int)((float)value / (mcdwLongBow.getDrawSpeed() / 20.0f));
            } else {
                item = bowStack.m_41720_();
                if (item instanceof McdwBow) {
                    McdwBow mcdwBow = (McdwBow)item;
                    value = (int)((float)value / (mcdwBow.getDrawSpeed() / 20.0f));
                }
            }
        }
        if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.ACCELERATE).mcdw$getIsEnabled() && (accelerateLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.ACCELERATE), (ItemStack)bowStack)) > 0 && BowItem.m_40661_((int)(value = (int)((float)value * (1.0f + Mth.m_14036_((float)((float)(consecutiveShots = (accelerateInstance = this.livingEntity.m_21124_(StatusEffectsRegistry.ACCELERATE)) != null ? accelerateInstance.m_19564_() + 1 : 0) * (6.0f + 2.0f * (float)accelerateLevel)), (float)0.0f, (float)100.0f) / 100.0f)))) >= 1.0f) {
            MobEffectInstance accelerateUpdateInstance = new MobEffectInstance(StatusEffectsRegistry.ACCELERATE, 60, consecutiveShots, false, false, true);
            this.livingEntity.m_7292_(accelerateUpdateInstance);
        }
        if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.OVERCHARGE).mcdw$getIsEnabled() && (overchargeLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.OVERCHARGE), (ItemStack)bowStack)) > 0) {
            this.overcharge = Math.min(value / 20 - 1, overchargeLevel);
            value = this.overcharge == overchargeLevel ? value : value % 20;
        }
        return value;
    }

    @ModifyArgs(method={"onStoppedUsing"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/projectile/PersistentProjectileEntity;setVelocity(Lnet/minecraft/entity/Entity;FFFFF)V"))
    private void mcdw$rangeHandler(Args args) {
        float velocity = ((Float)args.get(4)).floatValue();
        ItemStack bowStack = this.livingEntity.m_21211_();
        Item item = bowStack.m_41720_();
        if (item instanceof McdwShortbow) {
            McdwShortbow mcdwShortBow = (McdwShortbow)item;
            velocity *= (float)mcdwShortBow.m_6615_() / 15.0f;
        } else {
            item = bowStack.m_41720_();
            if (item instanceof McdwLongbow) {
                McdwLongbow mcdwLongBow = (McdwLongbow)item;
                velocity *= (float)mcdwLongBow.m_6615_() / 15.0f;
            } else {
                item = bowStack.m_41720_();
                if (item instanceof McdwBow) {
                    McdwBow mcdwBow = (McdwBow)item;
                    velocity *= (float)mcdwBow.m_6615_() / 15.0f;
                }
            }
        }
        args.set(4, (Object)Float.valueOf(velocity));
    }
}

