/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.mixin.mcdw;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IMcdwEnchantedArrow;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.api.util.ProjectileEffectHelper;
import chronosacaria.mcdw.api.util.RangedAttackHelper;
import chronosacaria.mcdw.bases.McdwCrossbow;
import chronosacaria.mcdw.enums.CrossbowsID;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.registries.EnchantsRegistry;
import chronosacaria.mcdw.registries.ItemsRegistry;
import chronosacaria.mcdw.registries.StatusEffectsRegistry;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={CrossbowItem.class})
public class CrossbowItemMixin {
    @Unique
    private LivingEntity livingEntity;

    @Unique
    public void mcdw$setLivingEntity(LivingEntity livingEntity) {
        this.livingEntity = livingEntity;
    }

    @Inject(method={"createArrow"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    private static void mcdw$applyCrossbowEnchantmentLevel(Level world, LivingEntity user, ItemStack crossbow, ItemStack arrow, CallbackInfoReturnable<AbstractArrow> cir, ArrowItem arrowItem, AbstractArrow ppe) {
        if (CrossbowItem.m_40932_((ItemStack)crossbow)) {
            int bonusShotLevel;
            CleanlinessHelper.addPPEEnchantments(crossbow, (IMcdwEnchantedArrow)ppe);
            ((IMcdwEnchantedArrow)ppe).mcdw$setNautilusBoolean(crossbow.m_150930_((Item)ItemsRegistry.CROSSBOW_ITEMS.get(CrossbowsID.CROSSBOW_NAUTICAL_CROSSBOW)));
            ((IMcdwEnchantedArrow)ppe).mcdw$setShadowBarbBoolean(crossbow.m_150930_((Item)ItemsRegistry.CROSSBOW_ITEMS.get(CrossbowsID.CROSSBOW_VEILED_CROSSBOW)));
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.BONUS_SHOT).mcdw$getIsEnabled() && (bonusShotLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.BONUS_SHOT), (ItemStack)crossbow)) > 0) {
                float damageMultiplier = 0.1f + (float)(bonusShotLevel - 1) * 0.07f;
                float arrowVelocity = RangedAttackHelper.getVanillaOrModdedCrossbowArrowVelocity(crossbow);
                ProjectileEffectHelper.mcdw$spawnExtraArrows(user, user, 1, 10, damageMultiplier);
            }
        }
    }

    @Inject(method={"onStoppedUsing"}, at={@At(value="HEAD")})
    private void mcdw$livingEntityGetter(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks, CallbackInfo ci) {
        this.mcdw$setLivingEntity(user);
    }

    @ModifyArg(method={"onStoppedUsing"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/CrossbowItem;getPullProgress(ILnet/minecraft/item/ItemStack;)F"), index=0)
    private int mcdw$acceleratedPullProgress(int useTicks) {
        MobEffectInstance accelerateInstance;
        int consecutiveShots;
        int accelerateLevel;
        ItemStack crossbowStack = this.livingEntity.m_21211_();
        if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.ACCELERATE).mcdw$getIsEnabled() && (accelerateLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.ACCELERATE), (ItemStack)crossbowStack)) > 0 && (float)(useTicks = (int)((float)useTicks * (1.0f + Mth.m_14036_((float)((float)(consecutiveShots = (accelerateInstance = this.livingEntity.m_21124_(StatusEffectsRegistry.ACCELERATE)) != null ? accelerateInstance.m_19564_() + 1 : 0) * (6.0f + 2.0f * (float)accelerateLevel)), (float)0.0f, (float)100.0f) / 100.0f))) / (float)CrossbowItem.m_40939_((ItemStack)crossbowStack) >= 1.0f) {
            MobEffectInstance accelerateUpdateInstance = new MobEffectInstance(StatusEffectsRegistry.ACCELERATE, 60, consecutiveShots, false, false, true);
            this.livingEntity.m_7292_(accelerateUpdateInstance);
        }
        return useTicks;
    }

    @ModifyArgs(method={"shootAll"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/CrossbowItem;shoot(Lnet/minecraft/world/World;Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/util/Hand;Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;FZFFF)V"))
    private static void mcdw$crossbowRangeHandler(Args args) {
        float velocity = ((Float)args.get(7)).floatValue();
        ItemStack crossbowStack = (ItemStack)args.get(3);
        Item item = crossbowStack.m_41720_();
        if (item instanceof McdwCrossbow) {
            McdwCrossbow mcdwCrossbow = (McdwCrossbow)item;
            velocity *= (float)mcdwCrossbow.m_6615_() / 8.0f;
        }
        args.set(7, (Object)Float.valueOf(velocity));
    }

    @Inject(method={"getPullTime"}, at={@At(value="RETURN")}, cancellable=true)
    private static void mcdw$crossbowPullTimeHandler(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        int pullTime = (Integer)cir.getReturnValue();
        Item item = stack.m_41720_();
        if (item instanceof McdwCrossbow) {
            McdwCrossbow mcdwCrossbow = (McdwCrossbow)item;
            pullTime += mcdwCrossbow.getDrawSpeed() - 25;
        }
        cir.setReturnValue((Object)Math.max(0, pullTime));
    }
}

