/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.mixin.mcdw;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.util.AOEHelper;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.damagesources.OffHandDamageSource;
import chronosacaria.mcdw.effects.EnchantmentEffects;
import chronosacaria.mcdw.enchants.summons.IBeeSummoning;
import chronosacaria.mcdw.enchants.summons.entity.SummonedBeeEntity;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.ItemsID;
import chronosacaria.mcdw.enums.SettingsID;
import chronosacaria.mcdw.enums.SwordsID;
import chronosacaria.mcdw.registries.EnchantsRegistry;
import chronosacaria.mcdw.registries.EntityAttributesRegistry;
import chronosacaria.mcdw.registries.ItemsRegistry;
import chronosacaria.mcdw.registries.SummonedEntityRegistry;
import java.util.Comparator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Unique
    public final EntityType<SummonedBeeEntity> mcdw$summoned_bee = SummonedEntityRegistry.SUMMONED_BEE_ENTITY;

    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    public float mcdw$damageModifiers(float amount, DamageSource source) {
        Entity entity = source.m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return amount;
        }
        LivingEntity attackingEntity = (LivingEntity)entity;
        if (amount > 0.0f) {
            TamableAnimal petSource;
            Level level;
            float storedAmount = amount * Mcdw.CONFIG.mcdwEnchantmentsConfig.directDamageEnchantmentMultiplier;
            if (attackingEntity instanceof TamableAnimal && (level = (petSource = (TamableAnimal)attackingEntity).m_9236_()) instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                level = petSource.m_269323_();
                if (level instanceof Player) {
                    Player owner = (Player)level;
                    amount += storedAmount * EnchantmentEffects.huntersPromiseDamage(owner, serverWorld);
                }
            }
        }
        return amount;
    }

    @Inject(method={"onDeath"}, at={@At(value="HEAD")})
    private void mcdw$onDeath(DamageSource source, CallbackInfo ci) {
        LivingEntity victim = (LivingEntity)this;
        boolean isOffHandAttack = source instanceof OffHandDamageSource;
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attackingEntity = (LivingEntity)entity;
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.PROSPECTOR).mcdw$getIsEnabled()) {
                EnchantmentEffects.applyProspector(attackingEntity, victim, isOffHandAttack);
            }
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.RUSHDOWN).mcdw$getIsEnabled()) {
                EnchantmentEffects.applyRushdown(attackingEntity, isOffHandAttack);
            }
        }
        if ((entity = source.m_7639_()) instanceof Player) {
            Player attackingPlayer = (Player)entity;
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.SOUL_SIPHON).mcdw$getIsEnabled()) {
                EnchantmentEffects.applySoulSiphon(attackingPlayer, isOffHandAttack);
            }
        }
    }

    @Inject(method={"applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V"}, at={@At(value="HEAD")})
    public void mcdw$applySmitingEnchantmentDamage(DamageSource source, float amount, CallbackInfo info) {
        Entity entity = source.m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity user = (LivingEntity)entity;
        LivingEntity target = (LivingEntity)this;
        if (target instanceof Player) {
            return;
        }
        if (source.m_7640_() instanceof LivingEntity && amount > 0.0f) {
            ItemStack mainHandStack = user.m_21205_();
            ItemStack offHandStack = user.m_21206_();
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.SMITING).mcdw$getIsEnabled()) {
                this.mcdw$applySmite(amount, user, target, mainHandStack);
                this.mcdw$applySmite(amount, user, target, offHandStack);
            }
        }
    }

    @Unique
    private void mcdw$applySmite(float amount, LivingEntity user, LivingEntity target, ItemStack itemStack) {
        if (itemStack != null && EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.SMITING), (ItemStack)itemStack) > 0 && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44978_, (ItemStack)itemStack) <= 0) {
            int smitingLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.SMITING), (ItemStack)itemStack);
            if (target.m_21222_()) {
                EnchantmentEffects.causeSmitingAttack(user, target, 3.0f * (float)smitingLevel, amount);
            }
        }
    }

    @Inject(method={"applyDamage"}, at={@At(value="HEAD")})
    private void mcdw$onAttack(DamageSource source, float amount, CallbackInfo ci) {
        Entity attacker = source.m_7639_();
        LivingEntity target = (LivingEntity)this;
        if (target.m_6673_(source)) {
            return;
        }
        if (!(attacker instanceof Player)) {
            return;
        }
        Player attackingPlayer = (Player)attacker;
        if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.BUSY_BEE).mcdw$getIsEnabled() && ((IBeeSummoning)attackingPlayer).isReadyForBeeSummon(attackingPlayer.f_19797_)) {
            ItemStack mainHandStack = attackingPlayer.m_21205_();
            ItemStack offHandStack = attackingPlayer.m_21206_();
            if (mainHandStack.m_41720_() == ItemsRegistry.SWORD_ITEMS.get(SwordsID.SWORD_BEESTINGER) && offHandStack.m_41720_() == ItemsRegistry.MCDW_ITEMS.get((Object)ItemsID.ITEM_BEE_STINGER)) {
                offHandStack.m_41774_(1);
                SummonedBeeEntity summonedBeeEntity_1 = (SummonedBeeEntity)this.mcdw$summoned_bee.m_20615_(attackingPlayer.m_9236_());
                if (summonedBeeEntity_1 != null) {
                    summonedBeeEntity_1.setSummoner((Entity)attackingPlayer);
                    summonedBeeEntity_1.m_7678_(attackingPlayer.m_20185_(), attackingPlayer.m_20186_() + 1.0, attackingPlayer.m_20189_(), 0.0f, 0.0f);
                    attackingPlayer.m_9236_().m_7967_((Entity)summonedBeeEntity_1);
                }
            }
        }
    }

    @Inject(method={"consumeItem"}, at={@At(value="HEAD")})
    public void mcdw$applyDippingPoisonPotionConsumption(CallbackInfo ci) {
        LivingEntityMixin livingEntityMixin = this;
        if (!(livingEntityMixin instanceof Player)) {
            return;
        }
        Player user = (Player)livingEntityMixin;
        ItemStack poisonTippedArrow = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42738_, 8), (Potion)Potions.f_43584_);
        if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.DIPPING_POISON).mcdw$getIsEnabled()) {
            int dippingPoisonLevel;
            if (!(user.m_21205_().m_41720_() instanceof PotionItem)) {
                return;
            }
            if (user.m_21206_() != null && EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.DIPPING_POISON), (ItemStack)user.m_21206_()) > 0 && (dippingPoisonLevel = EnchantmentHelper.m_44843_((Enchantment)EnchantsRegistry.enchantments.get((Object)EnchantmentsID.DIPPING_POISON), (ItemStack)user.m_21206_())) > 0) {
                List potionEffects = PotionUtils.m_43547_((ItemStack)user.m_21205_());
                if (((MobEffectInstance)potionEffects.get(0)).m_19544_() != MobEffects.f_19601_) {
                    return;
                }
                if (((MobEffectInstance)potionEffects.get(0)).m_19544_() == MobEffects.f_19601_) {
                    CleanlinessHelper.mcdw$dropItem((LivingEntity)user, poisonTippedArrow);
                }
            }
        }
    }

    @Inject(method={"jump"}, at={@At(value="HEAD")})
    public void mcdw$onJumpEffects(CallbackInfo ci) {
        LivingEntityMixin livingEntityMixin = this;
        if (!(livingEntityMixin instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer playerEntity = (ServerPlayer)livingEntityMixin;
        if (playerEntity != null) {
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.BURST_BOWSTRING).mcdw$getIsEnabled()) {
                EnchantmentEffects.activateBurstBowstringOnJump((LivingEntity)playerEntity);
            }
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.DYNAMO).mcdw$getIsEnabled()) {
                EnchantmentEffects.handleAddDynamoEffect((Player)playerEntity);
            }
        }
    }

    @Inject(method={"applyDamage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;setHealth(F)V")})
    public void mcdw$applySharedPainDamage(DamageSource source, float amount, CallbackInfo ci) {
        Entity entity = source.m_7640_();
        if (entity instanceof Player) {
            LivingEntity target;
            float targetHealth;
            LivingEntityMixin livingEntityMixin;
            Player player = (Player)entity;
            int sharedPainLevel = EnchantmentEffects.mcdw$getEnchantmentLevel(EnchantsRegistry.enchantments.get((Object)EnchantmentsID.SHARED_PAIN), (LivingEntity)player, false);
            if (sharedPainLevel <= 0) {
                return;
            }
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.SHARED_PAIN).mcdw$getIsEnabled() && (livingEntityMixin = this) instanceof LivingEntity && (targetHealth = (target = (LivingEntity)livingEntityMixin).m_21223_() - amount) < 0.0f) {
                float overkillDamage = Math.abs(targetHealth);
                List<LivingEntity> nearbyEntities = AOEHelper.getEntitiesByConfig(target, 6.0f);
                if (nearbyEntities.isEmpty()) {
                    if (Mcdw.CONFIG.mcdwEnchantmentSettingsConfig.ENABLE_ENCHANTMENT_SETTINGS.get((Object)SettingsID.SHARED_PAIN_CAN_DAMAGE_USER).booleanValue()) {
                        player.m_6469_(player.m_9236_().m_269111_().m_269425_(), overkillDamage);
                    }
                } else {
                    nearbyEntities.sort(Comparator.comparingDouble(livingEntity -> livingEntity.m_20280_((Entity)target)));
                    nearbyEntities.get(0).m_6469_(nearbyEntities.get(0).m_9236_().m_269111_().m_269425_(), overkillDamage);
                }
            }
        }
    }

    @Inject(method={"createLivingAttributes"}, require=1, allow=1, at={@At(value="RETURN")})
    private static void mcdw$addAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> cir) {
        ((AttributeSupplier.Builder)cir.getReturnValue()).m_22266_(EntityAttributesRegistry.REACH).m_22266_(EntityAttributesRegistry.ATTACK_RANGE);
    }
}

