/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.mixin.mcdw;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.util.PlayerAttackHelper;
import chronosacaria.mcdw.damagesources.OffHandDamageSource;
import chronosacaria.mcdw.effects.EnchantmentEffects;
import chronosacaria.mcdw.enums.EnchantmentsID;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class, Player.class})
public class LivingEntityPlayerEntityMixin {
    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), argsOnly=true)
    public float mcdw$damageModifiers(float amount, DamageSource source) {
        Entity entity = source.m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return amount;
        }
        LivingEntity attackingEntity = (LivingEntity)entity;
        LivingEntity victim = (LivingEntity)this;
        boolean isOffHandAttack = source instanceof OffHandDamageSource;
        if (amount > 0.0f) {
            Entity entity2;
            float storedAmount = amount * Mcdw.CONFIG.mcdwEnchantmentsConfig.directDamageEnchantmentMultiplier;
            if (source.m_7640_() instanceof LivingEntity) {
                if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.AMBUSH).mcdw$getIsEnabled()) {
                    amount += storedAmount * EnchantmentEffects.ambushDamage(attackingEntity, victim, isOffHandAttack);
                }
                if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.CRITICAL_HIT).mcdw$getIsEnabled()) {
                    amount += storedAmount * EnchantmentEffects.criticalHitDamage(attackingEntity, victim, isOffHandAttack);
                }
                if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.VOID_STRIKE).mcdw$getIsEnabled()) {
                    amount += storedAmount * EnchantmentEffects.voidStrikeDamage(attackingEntity, victim, isOffHandAttack);
                }
                if (!PlayerAttackHelper.mcdw$isLikelyNotMeleeDamage(source) && Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.PAIN_CYCLE).mcdw$getIsEnabled()) {
                    amount += storedAmount * EnchantmentEffects.painCycleDamage(attackingEntity, isOffHandAttack);
                }
            }
            if ((entity2 = source.m_7640_()) instanceof Player) {
                Player attackingPlayer = (Player)entity2;
                if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.ENIGMA_RESONATOR).mcdw$getIsEnabled()) {
                    amount += storedAmount * EnchantmentEffects.enigmaResonatorDamage(attackingPlayer, victim, isOffHandAttack);
                }
                if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.DYNAMO).mcdw$getIsEnabled()) {
                    amount += storedAmount * EnchantmentEffects.dynamoDamage(attackingEntity, isOffHandAttack);
                }
                if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.SHADOW_SHOT).mcdw$getIsEnabled()) {
                    amount += storedAmount * EnchantmentEffects.shadowFormDamage(attackingEntity);
                }
            }
            if ((entity2 = source.m_7640_()) instanceof AbstractArrow) {
                AbstractArrow ppe = (AbstractArrow)entity2;
                if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.ENIGMA_RESONATOR).mcdw$getIsEnabled()) {
                    amount += storedAmount * EnchantmentEffects.enigmaShotDamage(attackingEntity, victim, ppe);
                }
                if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.GROWING).mcdw$getIsEnabled()) {
                    amount += storedAmount * EnchantmentEffects.growingDamage(attackingEntity, victim, ppe);
                }
                if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.VOID_SHOT).mcdw$getIsEnabled()) {
                    amount += storedAmount * EnchantmentEffects.voidShotDamage(victim, ppe);
                }
                if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.DYNAMO).mcdw$getIsEnabled()) {
                    amount += storedAmount * EnchantmentEffects.dynamoShotDamage(attackingEntity, ppe);
                }
                if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.SHADOW_SHOT).mcdw$getIsEnabled()) {
                    amount += storedAmount * EnchantmentEffects.shadowFormShotDamage(attackingEntity, ppe);
                }
                if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.OVERCHARGE).mcdw$getIsEnabled()) {
                    amount += storedAmount * EnchantmentEffects.overchargeDamage(ppe);
                }
            }
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.COMMITTED).mcdw$getIsEnabled()) {
                amount += EnchantmentEffects.committedDamage(attackingEntity, victim, isOffHandAttack);
            }
        }
        return amount;
    }

    @Inject(method={"applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V"}, at={@At(value="HEAD")})
    public void mcdw$onApplyDamageHead(DamageSource source, float amount, CallbackInfo info) {
        LivingEntity sourceEntity;
        Entity entity;
        Entity entity2 = source.m_7639_();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity attackingEntity = (LivingEntity)entity2;
        LivingEntity victim = (LivingEntity)this;
        boolean isOffHandAttack = source instanceof OffHandDamageSource;
        if (amount > 0.0f && (entity = source.m_7640_()) instanceof LivingEntity && !((sourceEntity = (LivingEntity)entity).m_21205_().m_41720_() instanceof BowItem) && !(sourceEntity.m_21205_().m_41720_() instanceof CrossbowItem)) {
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.FREEZING).mcdw$getIsEnabled()) {
                EnchantmentEffects.applyFreezing(attackingEntity, victim, isOffHandAttack);
            }
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.JUNGLE_POISON).mcdw$getIsEnabled()) {
                EnchantmentEffects.applyPoisoning(attackingEntity, victim, isOffHandAttack);
            }
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.POISON_CLOUD).mcdw$getIsEnabled()) {
                EnchantmentEffects.applyPoisonCloud(attackingEntity, victim, isOffHandAttack);
            }
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.RADIANCE).mcdw$getIsEnabled()) {
                EnchantmentEffects.applyRadianceCloud(attackingEntity, isOffHandAttack);
            }
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.SHOCKWAVE).mcdw$getIsEnabled()) {
                EnchantmentEffects.applyShockwave(attackingEntity, victim, amount, isOffHandAttack);
            }
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.STUNNING).mcdw$getIsEnabled()) {
                EnchantmentEffects.applyStunning(attackingEntity, victim, isOffHandAttack);
            }
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.SWIRLING).mcdw$getIsEnabled()) {
                EnchantmentEffects.applySwirling(attackingEntity, victim, amount, isOffHandAttack);
            }
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.THUNDERING).mcdw$getIsEnabled()) {
                EnchantmentEffects.applyThundering(attackingEntity, amount, isOffHandAttack);
            }
            if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.WEAKENING).mcdw$getIsEnabled()) {
                EnchantmentEffects.applyWeakeningCloud(attackingEntity, victim, isOffHandAttack);
            }
            if (!source.m_276093_(DamageTypes.f_268739_)) {
                if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.CHAINS).mcdw$getIsEnabled()) {
                    EnchantmentEffects.applyChains(attackingEntity, victim, isOffHandAttack);
                }
                if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.GRAVITY).mcdw$getIsEnabled()) {
                    EnchantmentEffects.applyGravity(attackingEntity, victim, isOffHandAttack);
                }
            }
        }
    }

    @Inject(method={"applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V"}, at={@At(value="TAIL")})
    public void mcdw$onApplyDamageTail(DamageSource source, float amount, CallbackInfo info) {
        LivingEntity sourceEntity;
        Entity entity;
        Entity entity2 = source.m_7639_();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity attackingEntity = (LivingEntity)entity2;
        LivingEntity victim = (LivingEntity)this;
        boolean isOffHandAttack = source instanceof OffHandDamageSource;
        if (amount > 0.0f && (entity = source.m_7640_()) instanceof LivingEntity && !((sourceEntity = (LivingEntity)entity).m_21205_().m_41720_() instanceof BowItem) && !(sourceEntity.m_21205_().m_41720_() instanceof CrossbowItem) && Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.ECHO).mcdw$getIsEnabled()) {
            EnchantmentEffects.echoDamage(attackingEntity, victim, amount, isOffHandAttack);
        }
    }

    @Inject(method={"onDeath"}, at={@At(value="HEAD")})
    private void mcdw$onDeath(DamageSource source, CallbackInfo ci) {
        Entity victim;
        LivingEntity attackingEntity;
        boolean isOffHandAttack = source instanceof OffHandDamageSource;
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity sourceEntity;
            attackingEntity = (LivingEntity)entity;
            victim = (LivingEntity)this;
            Entity entity2 = source.m_7640_();
            if (entity2 instanceof LivingEntity && !((sourceEntity = (LivingEntity)entity2).m_21205_().m_41720_() instanceof BowItem) && !(sourceEntity.m_21205_().m_41720_() instanceof CrossbowItem)) {
                if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.EXPLODING).mcdw$getIsEnabled()) {
                    EnchantmentEffects.explodingDamage(attackingEntity, (LivingEntity)victim, isOffHandAttack);
                }
                if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.RAMPAGING).mcdw$getIsEnabled()) {
                    EnchantmentEffects.applyRampaging(attackingEntity, isOffHandAttack);
                }
                if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.LEECHING).mcdw$getIsEnabled()) {
                    EnchantmentEffects.applyLeeching(attackingEntity, (LivingEntity)victim, isOffHandAttack);
                }
                if (!PlayerAttackHelper.mcdw$isLikelyNotMeleeDamage(source) && Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.GUARDING_STRIKE).mcdw$getIsEnabled()) {
                    EnchantmentEffects.applyGuardingStrike(attackingEntity, isOffHandAttack);
                }
            }
        }
        if ((victim = source.m_7639_()) instanceof Player) {
            Entity entity3;
            attackingEntity = (Player)victim;
            if (source.m_7640_() instanceof LivingEntity && Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.REFRESHMENT).mcdw$getIsEnabled()) {
                EnchantmentEffects.applyRefreshment((Player)attackingEntity, isOffHandAttack);
            }
            if ((entity3 = source.m_7640_()) instanceof AbstractArrow) {
                AbstractArrow ppe = (AbstractArrow)entity3;
                if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.REFRESHMENT).mcdw$getIsEnabled()) {
                    EnchantmentEffects.applyRefreshment((Player)attackingEntity, isOffHandAttack);
                }
                if (Mcdw.CONFIG.mcdwEnchantmentsConfig.ENCHANTMENT_CONFIG.get((Object)EnchantmentsID.SHADOW_SHOT).mcdw$getIsEnabled()) {
                    EnchantmentEffects.applyShadowShotShadowForm(attackingEntity, ppe, 80);
                }
            }
        }
    }
}

