/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.mixin.mcdw;

import chronosacaria.mcdw.api.interfaces.IDualWielding;
import chronosacaria.mcdw.configs.CompatibilityFlags;
import chronosacaria.mcdw.enchants.summons.IBeeSummoning;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements IDualWielding,
IBeeSummoning {
    @Unique
    private static final EntityDataAccessor<Integer> LAST_ATTACKED_OFFHAND_TICKS = SynchedEntityData.m_135353_(PlayerEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Unique
    private int lastTimeSummonedBee = 0;

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public float mcdw$getOffhandAttackCooldownProgressPerTick() {
        return (float)(1.0 / this.m_21133_(Attributes.f_22283_) * 20.0);
    }

    @Override
    public float mcdw$getOffhandAttackCooldownProgress(float baseTime) {
        return Mth.m_14036_((float)(((float)this.mcdw$getOffhandAttackedTicks() + baseTime) / this.mcdw$getOffhandAttackCooldownProgressPerTick()), (float)0.0f, (float)1.0f);
    }

    @Override
    public void mcdw$resetLastAttackedOffhandTicks() {
        this.mcdw$setOffhandAttackedTicks(0);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getMainHandStack()Lnet/minecraft/item/ItemStack;")})
    public void mcdw$tick(CallbackInfo ci) {
        if (CompatibilityFlags.noOffhandConflicts) {
            this.mcdw$setOffhandAttackedTicks(this.mcdw$getOffhandAttackedTicks() + 1);
        }
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    protected void mcdw$initDataTracker(CallbackInfo ci) {
        if (CompatibilityFlags.noOffhandConflicts) {
            this.f_19804_.m_135372_(LAST_ATTACKED_OFFHAND_TICKS, (Object)0);
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void mcdw$writeCustomDataToNbt(CompoundTag nbt, CallbackInfo ci) {
        if (CompatibilityFlags.noOffhandConflicts) {
            nbt.m_128405_("LastAttackedOffhandTicks", this.mcdw$getOffhandAttackedTicks());
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="RETURN")})
    public void mcdw$readCustomDataFromNbt(CompoundTag nbt, CallbackInfo ci) {
        if (CompatibilityFlags.noOffhandConflicts) {
            this.mcdw$setOffhandAttackedTicks(nbt.m_128451_("LastAttackedOffhandTicks"));
        }
    }

    @Unique
    private double roundedDouble(double value, int percision) {
        int scale = (int)Math.pow(10.0, percision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }

    @Override
    public int mcdw$getOffhandAttackedTicks() {
        if (CompatibilityFlags.noOffhandConflicts) {
            return (Integer)this.f_19804_.m_135370_(LAST_ATTACKED_OFFHAND_TICKS);
        }
        return 0;
    }

    @Override
    public void mcdw$setOffhandAttackedTicks(int lastAttackedOffhandTicks) {
        if (CompatibilityFlags.noOffhandConflicts && lastAttackedOffhandTicks >= 0) {
            this.f_19804_.m_135381_(LAST_ATTACKED_OFFHAND_TICKS, (Object)lastAttackedOffhandTicks);
        }
    }

    @Override
    public void mcdw$setLastSummonedBee(int time) {
        this.lastTimeSummonedBee = time;
    }

    @Override
    public int mcdw$getLastSummonedBee() {
        return this.lastTimeSummonedBee;
    }
}

