/*
 * Decompiled with CFR 0.152.
 */
package circuitlord.reactivemusic;

import circuitlord.reactivemusic.MyMath;
import circuitlord.reactivemusic.ReactiveMusic;
import circuitlord.reactivemusic.SongLoader;
import circuitlord.reactivemusic.SongResource;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.sounds.SoundSource;
import rm_javazoom.jl.player.AudioDevice;
import rm_javazoom.jl.player.JavaSoundAudioDevice;
import rm_javazoom.jl.player.advanced.AdvancedPlayer;

public class PlayerThread
extends Thread {
    public static final float MIN_POSSIBLE_GAIN = -80.0f;
    public static final float MIN_GAIN = -50.0f;
    public static final float MAX_GAIN = 5.0f;
    public static float[] fadeGains = new float[150];
    public static volatile float gainPercentage;
    public static final float QUIET_VOLUME_PERCENTAGE = 0.7f;
    public static final float QUIET_VOLUME_LERP_RATE = 0.015f;
    public static float quietPercentage;
    public static volatile float realGain;
    public static volatile String currentSong;
    public static volatile String currentSongChoices;
    public volatile SongResource currentSongResource = null;
    AdvancedPlayer player;
    private volatile boolean queued = false;
    private volatile boolean kill = false;
    private volatile boolean playing = false;

    boolean notQueuedOrPlaying() {
        return !this.queued && !this.isPlaying();
    }

    boolean isPlaying() {
        return this.playing && !this.player.getComplete();
    }

    public PlayerThread() {
        this.setDaemon(true);
        this.setName("ReactiveMusic Player Thread");
        this.start();
    }

    @Override
    public void run() {
        try {
            while (!this.kill) {
                if (this.queued && currentSong != null) {
                    this.currentSongResource = SongLoader.getStream(SongLoader.activeSongpackPath, SongLoader.activeSongpackEmbedded, currentSong);
                    if (this.currentSongResource == null || this.currentSongResource.inputStream == null) continue;
                    this.player = new AdvancedPlayer(this.currentSongResource.inputStream);
                    this.queued = false;
                }
                if (this.player == null || this.player.getAudioDevice() == null) continue;
                this.setGainPercentage(1.0f);
                this.processRealGain();
                ReactiveMusic.LOGGER.info("Playing " + currentSong);
                this.playing = true;
                this.player.play();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resetPlayer() {
        this.playing = false;
        if (this.player != null) {
            this.player.queuedToStop = true;
        }
        this.queued = false;
        currentSong = null;
        if (this.currentSongResource != null && this.currentSongResource.fileSystem != null) {
            try {
                this.currentSongResource.fileSystem.close();
            }
            catch (IOException e) {
                ReactiveMusic.LOGGER.error("Failed to close file system input stream " + e.getMessage());
            }
        }
        this.currentSongResource = null;
    }

    public void play(String song) {
        this.resetPlayer();
        currentSong = song;
        this.queued = true;
    }

    public void setGainPercentage(float newGain) {
        gainPercentage = Math.min(1.0f, Math.max(0.0f, newGain));
    }

    public void processRealGain() {
        AudioDevice device;
        Minecraft client = Minecraft.m_91087_();
        Options options = Minecraft.m_91087_().f_91066_;
        boolean musicOptionsOpen = false;
        TranslatableContents ScreenTitleContent = null;
        if (client.f_91080_ != null && client.f_91080_.m_96636_() != null && client.f_91080_.m_96636_().m_214077_() != null && client.f_91080_.m_96636_().m_214077_() instanceof TranslatableContents && (ScreenTitleContent = (TranslatableContents)client.f_91080_.m_96636_().m_214077_()) != null) {
            musicOptionsOpen = ScreenTitleContent.m_237508_().equals("options.sounds.title");
        }
        boolean doQuietMusic = client.m_91104_() && client.f_91073_ != null && !musicOptionsOpen;
        float targetQuietMusicPercentage = doQuietMusic ? 0.7f : 1.0f;
        quietPercentage = MyMath.lerpConstant(quietPercentage, targetQuietMusicPercentage, 0.015f);
        float minecraftGain = options.m_92147_(SoundSource.MUSIC) * options.m_92147_(SoundSource.MASTER);
        float newRealGain = -50.0f + 55.0f * minecraftGain * gainPercentage * quietPercentage;
        if (minecraftGain <= 0.0f) {
            newRealGain = -80.0f;
        }
        realGain = newRealGain;
        if (this.player != null && (device = this.player.getAudioDevice()) != null && device instanceof JavaSoundAudioDevice) {
            try {
                ((JavaSoundAudioDevice)device).setGain(newRealGain);
            }
            catch (IllegalArgumentException e) {
                ReactiveMusic.LOGGER.error(e.toString());
            }
        }
    }

    public void forceKill() {
        try {
            this.resetPlayer();
            this.interrupt();
            this.finalize();
            this.kill = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        float totaldiff = -55.0f;
        float diff = totaldiff / (float)fadeGains.length;
        for (int i = 0; i < fadeGains.length; ++i) {
            PlayerThread.fadeGains[i] = 5.0f + diff * (float)i;
        }
        gainPercentage = 1.0f;
        quietPercentage = 1.0f;
        realGain = 0.0f;
        currentSong = null;
        currentSongChoices = null;
    }
}

