/*
 * Decompiled with CFR 0.152.
 */
package circuitlord.reactivemusic;

import circuitlord.reactivemusic.PlayerThread;
import circuitlord.reactivemusic.SongLoader;
import circuitlord.reactivemusic.SongPicker;
import circuitlord.reactivemusic.SongpackEntry;
import circuitlord.reactivemusic.SongpackZip;
import circuitlord.reactivemusic.config.ModConfig;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Random;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactiveMusic
implements ModInitializer {
    public static final String MOD_ID = "reactive_music";
    public static final String MOD_VERSION = "0.4.0";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"reactive_music");
    private static final int WAIT_FOR_SWITCH_DURATION = 100;
    public static final int FADE_DURATION = 150;
    public static final int SILENCE_DURATION = 100;
    public static int additionalSilence = 0;
    public static PlayerThread thread;
    static String currentSong;
    static SongpackEntry currentEntry;
    static int waitForSwitchTicks;
    static int fadeOutTicks;
    static int fadeInTicks;
    static int silenceTicks;
    static int slowTickUpdateCounter;
    boolean doSilenceForNextQueuedSong = true;
    static Random rand;
    static ModConfig config;

    public void onInitialize() {
        LOGGER.info("--------------------------------------------");
        LOGGER.info("|     Reactive Music initialization...     |");
        LOGGER.info("|                version 0.4.0              |");
        LOGGER.info("--------------------------------------------");
        ModConfig.GSON.load();
        config = ModConfig.getConfig();
        SongLoader.fetchAvailableSongpacks();
        boolean loadedUserSongpack = false;
        if (!ReactiveMusic.config.loadedUserSongpack.isEmpty()) {
            for (SongpackZip songpack : SongLoader.availableSongpacks) {
                if (!songpack.config.name.equals(ReactiveMusic.config.loadedUserSongpack)) continue;
                SongLoader.setActiveSongpack(songpack, false);
                loadedUserSongpack = true;
                break;
            }
        }
        if (!loadedUserSongpack) {
            SongLoader.setActiveSongpack(null, true);
        }
        SongPicker.initialize();
        thread = new PlayerThread();
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"reactivemusic").executes(context -> {
            Minecraft mc = ((FabricClientCommandSource)context.getSource()).getClient();
            Screen screen = ModConfig.createScreen(mc.f_91080_);
            mc.m_6937_(() -> mc.m_91152_(screen));
            return 1;
        })));
    }

    public static void tick() {
        SongpackEntry newEntry;
        if (thread == null) {
            return;
        }
        if (SongLoader.activeSongpack == null) {
            return;
        }
        silenceTicks = !thread.isPlaying() ? ++silenceTicks : 0;
        if (++slowTickUpdateCounter > 20) {
            SongPicker.tickEventMap();
            slowTickUpdateCounter = 0;
        }
        if ((newEntry = SongPicker.getCurrentEntry()) != null && newEntry.songs.length > 0) {
            waitForSwitchTicks = currentEntry == null || newEntry.id != ReactiveMusic.currentEntry.id ? ++waitForSwitchTicks : 0;
            boolean playNewSong = false;
            boolean doSilenceAfter = true;
            if (thread.notQueuedOrPlaying() && (silenceTicks > additionalSilence || ReactiveMusic.config.debugModeEnabled)) {
                playNewSong = true;
            } else if (thread.notQueuedOrPlaying() && newEntry.alwaysPlay) {
                playNewSong = true;
            } else if (thread.notQueuedOrPlaying() && currentEntry != null && ReactiveMusic.currentEntry.alwaysStop) {
                playNewSong = true;
            } else if (thread.isPlaying() && currentEntry != null && newEntry.id != ReactiveMusic.currentEntry.id && waitForSwitchTicks > 100 && (ReactiveMusic.currentEntry.alwaysStop || newEntry.alwaysPlay || ReactiveMusic.config.debugModeEnabled)) {
                if (fadeOutTicks < 150) {
                    thread.setGainPercentage(1.0f - (float)(++fadeOutTicks) / 150.0f);
                } else {
                    thread.resetPlayer();
                    fadeOutTicks = 0;
                }
            }
            if (playNewSong) {
                String picked = SongPicker.pickRandomSong(newEntry.songs);
                ReactiveMusic.changeCurrentSong(picked, newEntry);
                int minTickSilence = 0;
                int maxTickSilence = 0;
                switch (ModConfig.getConfig().musicDelayLength) {
                    case SHORT: {
                        minTickSilence = 250;
                        maxTickSilence = 1000;
                        break;
                    }
                    case NORMAL: {
                        minTickSilence = 1000;
                        maxTickSilence = 4000;
                        break;
                    }
                    case LONG: {
                        minTickSilence = 2000;
                        maxTickSilence = 7000;
                    }
                }
                additionalSilence = rand.nextInt(minTickSilence, maxTickSilence);
            }
        }
        thread.processRealGain();
    }

    public static void changeCurrentSong(String song, SongpackEntry newEntry) {
        currentSong = song;
        currentEntry = newEntry;
        Object entryName = "";
        for (int i = 0; i < newEntry.events.length; ++i) {
            entryName = (String)entryName + newEntry.events[i].toString();
        }
        LOGGER.info("Changing entry: " + (String)entryName + " Song name: " + song);
        thread.setGainPercentage(0.0f);
        thread.play(song);
    }

    public static void refreshSongpack() {
        thread.resetPlayer();
        additionalSilence = 0;
    }

    static {
        currentEntry = null;
        waitForSwitchTicks = 0;
        fadeOutTicks = 0;
        fadeInTicks = 0;
        silenceTicks = 0;
        slowTickUpdateCounter = 0;
        rand = new Random();
    }
}

