/*
 * Decompiled with CFR 0.152.
 */
package circuitlord.reactivemusic;

import circuitlord.reactivemusic.ReactiveMusic;
import circuitlord.reactivemusic.SongPicker;
import circuitlord.reactivemusic.SongResource;
import circuitlord.reactivemusic.SongpackConfig;
import circuitlord.reactivemusic.SongpackEventType;
import circuitlord.reactivemusic.SongpackZip;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import org.sinytra.connector.mod.ConnectorMod;
import org.yaml.snakeyaml.Yaml;

public final class SongLoader {
    public static SongpackConfig activeSongpack = null;
    public static Path activeSongpackPath = null;
    public static boolean activeSongpackEmbedded = false;
    public static List<SongpackZip> availableSongpacks = new ArrayList<SongpackZip>();

    public static void fetchAvailableSongpacks() {
        long startTime = System.currentTimeMillis();
        Path gamePath = FabricLoader.getInstance().getGameDir();
        Path resourcePacksPath = gamePath.resolve("resourcepacks");
        availableSongpacks.clear();
        final ArrayList potentialPacks = new ArrayList();
        try {
            Files.walkFileTree(resourcePacksPath, EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attr) throws IOException {
                    potentialPacks.add(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            ReactiveMusic.LOGGER.error("Failed while visiting potential packs " + e.getMessage());
        }
        for (Path packPath : potentialPacks) {
            SongpackConfig config = null;
            Path configPath = null;
            if (Files.isDirectory(packPath, new LinkOption[0])) {
                configPath = packPath.resolve("ReactiveMusic.yaml");
                if (Files.exists(configPath, new LinkOption[0])) {
                    config = SongLoader.loadSongpackConfig(configPath, false);
                }
            } else {
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("create", "false");
                try (FileSystem fs = FileSystems.newFileSystem(packPath, env);){
                    configPath = fs.getPath("ReactiveMusic.yaml", new String[0]);
                    if (Files.exists(configPath, new LinkOption[0])) {
                        config = SongLoader.loadSongpackConfig(configPath, false);
                    }
                }
                catch (Exception e) {
                    ReactiveMusic.LOGGER.error("Failed while loading potential packs " + e.getMessage());
                }
            }
            if (config == null) continue;
            if (config.entries == null) {
                config.errorString = "Entries are null or not formatted correctly! Make sure you indent each entry with a TAB.\n\n";
                config.blockLoading = true;
            } else {
                for (int i = 0; i < config.entries.length; ++i) {
                    if (config.entries[i] == null || config.entries[i].songs == null) continue;
                    for (int j = 0; j < config.entries[i].songs.length; ++j) {
                        SongResource songRes = SongLoader.getStream(packPath, false, config.entries[i].songs[j]);
                        if (songRes != null) continue;
                        Object eventName = "";
                        for (int k = 0; k < config.entries[i].events.length; ++k) {
                            eventName = (String)eventName + config.entries[i].events[k].toString();
                        }
                        config.errorString = config.errorString + "Failed finding song: \"" + config.entries[i].songs[j] + "\" for event: \"" + (String)eventName + "\"\n\n";
                    }
                }
            }
            SongpackZip zip = new SongpackZip();
            zip.path = packPath;
            zip.config = config;
            availableSongpacks.add(zip);
        }
        ReactiveMusic.LOGGER.info("Took " + (System.currentTimeMillis() - startTime) + "ms to parse available songpacks, found " + availableSongpacks.size() + "!");
    }

    public static void setActiveSongpack(SongpackZip songpackZip, boolean embeddedMode) {
        if (embeddedMode) {
            ReactiveMusic.LOGGER.info("Loading embedded songpack!");
            activeSongpack = SongLoader.loadSongpackConfig(null, true);
            activeSongpackPath = null;
        } else {
            ReactiveMusic.LOGGER.info("Loading songpack: " + songpackZip.config.name);
            activeSongpack = songpackZip.config;
            activeSongpackPath = songpackZip.path;
        }
        if (!SongLoader.activeSongpack.errorString.isEmpty()) {
            ReactiveMusic.LOGGER.error("ERRORS while loading songpack:\n\n" + SongLoader.activeSongpack.errorString);
        }
        activeSongpackEmbedded = embeddedMode;
    }

    public static SongpackConfig loadSongpackConfig(Path configPath, boolean embeddedMode) {
        SongpackConfig songpack = new SongpackConfig();
        songpack.configPath = configPath;
        Yaml yaml = new Yaml();
        try {
            InputStream inputStream = embeddedMode ? ConnectorMod.getModResourceAsStream(SongLoader.class, (String)"/musicpack/ReactiveMusic.yaml") : Files.newInputStream(configPath, new OpenOption[0]);
            songpack = yaml.loadAs(inputStream, SongpackConfig.class);
        }
        catch (Exception e) {
            songpack.name = configPath.getName(configPath.getNameCount() - 2).toString();
            songpack.errorString = e.toString() + "\n\n";
            songpack.blockLoading = true;
        }
        if (songpack.entries != null) {
            for (int i = 0; i < songpack.entries.length; ++i) {
                if (songpack.entries[i] == null) continue;
                songpack.entries[i].id = i;
                for (int j = 0; j < songpack.entries[i].events.length; ++j) {
                    String val = songpack.entries[i].events[j].toLowerCase();
                    if (val.isEmpty()) continue;
                    if (val.startsWith("biome=")) {
                        String biomeTagName = val.substring(6);
                        biomeTagName = biomeTagName.replace("is_", "");
                        boolean foundTag = false;
                        for (int k = 0; k < SongPicker.BIOME_TAG_FIELDS.length; ++k) {
                            TagKey<Biome> biomeTag;
                            String fieldName = SongPicker.BIOME_TAG_FIELDS[k].getName().toLowerCase();
                            if (!(fieldName = fieldName.replace("is_", "")).equals(biomeTagName) || (biomeTag = SongPicker.getBiomeTagFromField(SongPicker.BIOME_TAG_FIELDS[k])) == null) continue;
                            songpack.entries[i].biomeTagEvents.add(biomeTag);
                            foundTag = true;
                            break;
                        }
                        if (foundTag) {
                            continue;
                        }
                    } else {
                        try {
                            SongpackEventType eventType = Enum.valueOf(SongpackEventType.class, val.toUpperCase());
                            if (eventType != SongpackEventType.NONE) {
                                songpack.entries[i].songpackEvents.add(eventType);
                                continue;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    songpack.errorString = songpack.errorString + "Unknown event type: " + val + "\n\n";
                }
            }
        }
        return songpack;
    }

    public static SongResource getStream(Path songpackPath, boolean embedded, String songName) {
        if (songName == null || songName.isEmpty() || songName.equals("null")) {
            return null;
        }
        SongResource songRes = new SongResource();
        if (embedded) {
            String path = "/musicpack/music/" + songName + ".mp3";
            songRes.inputStream = ConnectorMod.getModResourceAsStream(SongLoader.class, (String)path);
        } else {
            if (songpackPath.toFile().isDirectory()) {
                Path songPath = songpackPath.resolve("music").resolve(songName + ".mp3");
                if (Files.exists(songPath, new LinkOption[0])) {
                    try {
                        songRes.inputStream = new FileInputStream(songPath.toFile());
                    }
                    catch (FileNotFoundException e) {
                        ReactiveMusic.LOGGER.error("Failed to load song file " + songName);
                        return null;
                    }
                }
                return null;
            }
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "false");
            FileSystem fs = null;
            try {
                fs = FileSystems.newFileSystem(songpackPath, env);
            }
            catch (IOException e) {
                ReactiveMusic.LOGGER.error("Failed while loading song file from zip " + e.getMessage());
                return null;
            }
            Path songPath = fs.getPath("music", songName + ".mp3");
            if (Files.exists(songPath, new LinkOption[0])) {
                try {
                    songRes.inputStream = Files.newInputStream(songPath, new OpenOption[0]);
                    songRes.fileSystem = fs;
                }
                catch (IOException e) {
                    ReactiveMusic.LOGGER.error("Failed while creating inputstream from zip " + e.getMessage());
                    return null;
                }
            } else {
                return null;
            }
        }
        return songRes;
    }

    private static String joinTokensExceptFirst(String[] tokens) {
        Object s = "";
        int i = 0;
        for (String token : tokens) {
            if (++i == 1) continue;
            s = (String)s + token;
        }
        return s;
    }
}

