/*
 * Decompiled with CFR 0.152.
 */
package circuitlord.reactivemusic;

import circuitlord.reactivemusic.SongLoader;
import circuitlord.reactivemusic.SongpackEntry;
import circuitlord.reactivemusic.SongpackEventType;
import circuitlord.reactivemusic.VersionHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public final class SongPicker {
    public static Map<SongpackEventType, Boolean> songpackEventMap = new EnumMap<SongpackEventType, Boolean>(SongpackEventType.class);
    public static Map<TagKey<Biome>, Boolean> biomeTagEventMap = new HashMap<TagKey<Biome>, Boolean>();
    private static final Random rand = new Random();
    private static List<String> recentlyPickedSongs = new ArrayList<String>();
    public static final Field[] BIOME_TAG_FIELDS = ConventionalBiomeTags.class.getDeclaredFields();
    public static final List<TagKey<Biome>> BIOME_TAGS = new ArrayList<TagKey<Biome>>();

    public static TagKey<Biome> getBiomeTagFromField(Field field) {
        if (field.getType() == TagKey.class) {
            try {
                TagKey tag = (TagKey)field.get(null);
                return tag;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void tickEventMap() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel world = mc.f_91073_;
        songpackEventMap.put(SongpackEventType.MAIN_MENU, player == null || world == null);
        songpackEventMap.put(SongpackEventType.CREDITS, mc.f_91080_ instanceof WinScreen);
        if (player == null || world == null) {
            return;
        }
        BlockPos pos = new BlockPos((Vec3i)player.m_20183_());
        Holder biome = world.m_204166_(pos);
        boolean underground = !world.m_45527_(pos);
        ResourceKey indimension = world.m_46472_();
        Entity riding = VersionHelper.GetRidingEntity(player);
        long time = world.m_46468_() % 24000L;
        boolean night = time > 13300L && time < 23200L;
        boolean sunset = time > 12000L && time < 13000L;
        boolean sunrise = time > 23000L;
        songpackEventMap.put(SongpackEventType.DAY, !night);
        songpackEventMap.put(SongpackEventType.NIGHT, night);
        songpackEventMap.put(SongpackEventType.SUNSET, sunset);
        songpackEventMap.put(SongpackEventType.SUNRISE, sunrise);
        songpackEventMap.put(SongpackEventType.DYING, player.m_21223_() < 7.0f);
        songpackEventMap.put(SongpackEventType.FISHING, player.f_36083_ != null);
        songpackEventMap.put(SongpackEventType.MINECART, riding instanceof Minecart);
        songpackEventMap.put(SongpackEventType.BOAT, riding instanceof Boat);
        songpackEventMap.put(SongpackEventType.HORSE, riding instanceof Horse);
        songpackEventMap.put(SongpackEventType.PIG, riding instanceof Pig);
        songpackEventMap.put(SongpackEventType.OVERWORLD, indimension == Level.f_46428_);
        songpackEventMap.put(SongpackEventType.NETHER, indimension == Level.f_46429_);
        songpackEventMap.put(SongpackEventType.END, indimension == Level.f_46430_);
        songpackEventMap.put(SongpackEventType.UNDERGROUND, indimension == Level.f_46428_ && underground && pos.m_123342_() < 55);
        songpackEventMap.put(SongpackEventType.DEEP_UNDERGROUND, indimension == Level.f_46428_ && underground && pos.m_123342_() < 15);
        songpackEventMap.put(SongpackEventType.HIGH_UP, indimension == Level.f_46428_ && !underground && pos.m_123342_() > 128);
        songpackEventMap.put(SongpackEventType.UNDERWATER, player.m_5842_());
        songpackEventMap.put(SongpackEventType.RAIN, world.m_46471_());
        songpackEventMap.put(SongpackEventType.MOUNTAIN, biome.m_203656_(BiomeTags.f_207606_));
        songpackEventMap.put(SongpackEventType.FOREST, biome.m_203656_(BiomeTags.f_207611_));
        songpackEventMap.put(SongpackEventType.BEACH, biome.m_203656_(BiomeTags.f_207604_));
        for (TagKey<Biome> tag : BIOME_TAGS) {
            biomeTagEventMap.put(tag, biome.m_203656_(tag));
        }
        songpackEventMap.put(SongpackEventType.GENERIC, true);
    }

    public static void initialize() {
        songpackEventMap.clear();
        for (SongpackEventType eventType : SongpackEventType.values()) {
            songpackEventMap.put(eventType, false);
        }
    }

    public static SongpackEntry getCurrentEntry() {
        for (int i = 0; i < SongLoader.activeSongpack.entries.length; ++i) {
            SongpackEntry entry = SongLoader.activeSongpack.entries[i];
            if (entry == null) continue;
            boolean eventsMet = true;
            for (SongpackEventType songpackEventType : entry.songpackEvents) {
                if (!songpackEventMap.containsKey((Object)songpackEventType) || songpackEventMap.get((Object)songpackEventType).booleanValue()) continue;
                eventsMet = false;
                break;
            }
            for (TagKey tagKey : entry.biomeTagEvents) {
                if (!biomeTagEventMap.containsKey(tagKey) || biomeTagEventMap.get(tagKey).booleanValue()) continue;
                eventsMet = false;
                break;
            }
            if (!eventsMet) continue;
            return entry;
        }
        return null;
    }

    static String pickRandomSong(String[] songArr) {
        String picked;
        ArrayList<String> songs = new ArrayList<String>(Arrays.stream(songArr).toList());
        songs.removeAll(recentlyPickedSongs);
        if (!songs.isEmpty()) {
            int randomIndex = rand.nextInt(songs.size());
            picked = (String)songs.get(randomIndex);
        } else {
            int randomIndex = rand.nextInt(songArr.length);
            picked = songArr[randomIndex];
        }
        if (recentlyPickedSongs.size() > 5) {
            recentlyPickedSongs.remove(0);
        }
        recentlyPickedSongs.add(picked);
        return picked;
    }

    public static String getSongName(String song) {
        return song == null ? "" : song.replaceAll("([^A-Z])([A-Z])", "$1 $2");
    }

    static {
        for (Field field : BIOME_TAG_FIELDS) {
            TagKey<Biome> biomeTag = SongPicker.getBiomeTagFromField(field);
            BIOME_TAGS.add(biomeTag);
            biomeTagEventMap.put(biomeTag, false);
        }
    }
}

