/*
 * Decompiled with CFR 0.152.
 */
package circuitlord.reactivemusic.config;

import circuitlord.reactivemusic.ReactiveMusic;
import circuitlord.reactivemusic.SongLoader;
import circuitlord.reactivemusic.SongpackZip;
import circuitlord.reactivemusic.config.MusicDelayLength;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import dev.isxander.yacl3.platform.YACLPlatform;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ModConfig {
    public static final ConfigClassHandler<ModConfig> GSON = ConfigClassHandler.createBuilder(ModConfig.class).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(YACLPlatform.getConfigDir().resolve("ReactiveMusic.json5")).setJson5(true).build()).build();
    @SerialEntry
    public MusicDelayLength musicDelayLength = MusicDelayLength.NORMAL;
    @SerialEntry
    public boolean debugModeEnabled = false;
    @SerialEntry
    public boolean treatAsWhitelist = false;
    @SerialEntry
    public double confirmationResetDelay = 1.0;
    @SerialEntry
    public String loadedUserSongpack = "";

    public static ModConfig getConfig() {
        return (ModConfig)GSON.instance();
    }

    public static Screen createScreen(Screen parent) {
        SongLoader.fetchAvailableSongpacks();
        return YetAnotherConfigLib.create(GSON, (defaults, config, builder) -> {
            ConfigCategory.Builder songpacksBuilder = ConfigCategory.createBuilder();
            songpacksBuilder.name((Component)Component.m_237113_((String)"Songpacks"));
            boolean arIsLoaded = Objects.equals(SongLoader.activeSongpack.name, "Adventure Redefined");
            songpacksBuilder.option((Option)ButtonOption.createBuilder().name((Component)Component.m_237113_((String)"Adventure Redefined (Default)")).description(OptionDescription.createBuilder().text(new Component[]{Component.m_237113_((String)"The included songpack with Reactive Music.")}).build()).available(!arIsLoaded).text((Component)Component.m_237113_((String)(arIsLoaded ? "Loaded" : "Load"))).action((yaclScreen, buttonOption) -> {
                ModConfig.setActiveSongpack(null, true);
                ReactiveMusic.refreshSongpack();
                Minecraft.m_91087_().m_91152_(ModConfig.createScreen(parent));
            }).build());
            for (SongpackZip songpackZip : SongLoader.availableSongpacks) {
                boolean isLoaded = Objects.equals(SongLoader.activeSongpack.name, songpackZip.config.name);
                if (songpackZip.config.blockLoading) {
                    songpacksBuilder.option((Option)ButtonOption.createBuilder().name((Component)Component.m_237113_((String)("FAILED LOADING: " + songpackZip.config.name))).description(OptionDescription.createBuilder().text(new Component[]{Component.m_237113_((String)("Failed to load songpack:\n\n" + songpackZip.config.errorString))}).build()).available(false).text((Component)Component.m_237113_((String)"")).action((yaclScreen, buttonOption) -> {}).build());
                    continue;
                }
                Object name = songpackZip.config.name;
                String description = songpackZip.config.description + "\n\nCredits:\n" + songpackZip.config.credits;
                if (!songpackZip.config.errorString.isEmpty()) {
                    name = "ERRORS: " + (String)name;
                    description = "Encountered errors while loading:\n\n" + songpackZip.config.errorString + "----------\n\n" + description;
                }
                songpacksBuilder.option((Option)ButtonOption.createBuilder().name((Component)Component.m_237113_((String)name)).description(OptionDescription.createBuilder().text(new Component[]{Component.m_237113_((String)description)}).build()).available(!isLoaded).text((Component)Component.m_237113_((String)(isLoaded ? "Loaded" : "Load"))).action((yaclScreen, buttonOption) -> {
                    ModConfig.setActiveSongpack(songpackZip, false);
                    ReactiveMusic.refreshSongpack();
                    Minecraft.m_91087_().m_91152_(ModConfig.createScreen(parent));
                }).build());
            }
            builder.category(songpacksBuilder.build());
            builder.title((Component)Component.m_237113_((String)"Reactive Music")).category(ConfigCategory.createBuilder().name((Component)Component.m_237113_((String)"General")).option(Option.createBuilder().name((Component)Component.m_237113_((String)"Music Delay Length")).binding((Object)defaults.musicDelayLength, () -> config.musicDelayLength, newVal -> {
                config.musicDelayLength = newVal;
            }).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(MusicDelayLength.class)).build()).build()).category(ConfigCategory.createBuilder().name((Component)Component.m_237113_((String)"Debug")).tooltip(new Component[]{Component.m_237113_((String)"Any debug tools useful for songpack creators or developers")}).option(Option.createBuilder().name((Component)Component.m_237113_((String)"Debug Mode Enabled")).description(OptionDescription.createBuilder().text(new Component[]{Component.m_237113_((String)"Enables some developer functionality such as always switching between songs when events change.")}).build()).binding((Object)defaults.debugModeEnabled, () -> config.debugModeEnabled, newVal -> {
                config.debugModeEnabled = newVal;
            }).controller(TickBoxControllerBuilder::create).build()).build()).build();
            return builder;
        }).generateScreen(parent);
    }

    public static void setActiveSongpack(SongpackZip zip, boolean embeddedMode) {
        ModConfig.getConfig().loadedUserSongpack = embeddedMode ? "" : zip.config.name;
        GSON.save();
        SongLoader.setActiveSongpack(zip, embeddedMode);
    }
}

