/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.crowdintranslate;

import com.mojang.logging.LogUtils;
import de.guntram.mcmod.crowdintranslate.CrowdinTranslate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import org.slf4j.Logger;

public class CTResourcePack
implements PackResources {
    private final List<String> namespaces = new ArrayList<String>();
    private static final Logger LOGGER = LogUtils.getLogger();

    public CTResourcePack() {
        for (String s : CrowdinTranslate.registeredMods()) {
            this.put(s + "/lang");
        }
        this.put("crowdintranslate/lang");
    }

    public boolean put(String resource) {
        ResourceLocation id = CTResourcePack.fromPath(resource);
        if (!this.namespaces.contains(id.m_135827_())) {
            this.namespaces.add(id.m_135827_());
        }
        return true;
    }

    public IoSupplier<InputStream> m_8017_(String ... fileName) {
        File file = new File(CrowdinTranslate.getRootDir(), fileName[0]);
        if (file.exists()) {
            return IoSupplier.m_246697_((Path)file.toPath());
        }
        return null;
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation id) {
        return this.m_8017_(type.m_10305_() + "/" + id.m_135827_() + "/" + id.m_135815_());
    }

    public void m_8031_(PackType type, String namespace, String prefix, PackResources.ResourceOutput consumer) {
        String start = CrowdinTranslate.getRootDir() + "/assets/" + namespace + "/" + prefix;
        String[] files = new File(start).list();
        if (files == null || files.length == 0) {
            return;
        }
        List resultList = Arrays.asList(files).stream().map(CTResourcePack::fromPath).collect(Collectors.toList());
        for (ResourceLocation result : resultList) {
            consumer.accept((Object)result, this.m_214146_(type, result));
        }
    }

    public Set<String> m_5698_(PackType type) {
        return new HashSet<String>(this.namespaces);
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> metaReader) throws IOException {
        return null;
    }

    public String m_5542_() {
        return "CrowdinTranslate internal Resource Pack";
    }

    public void close() {
    }

    public boolean m_246538_() {
        return true;
    }

    private static ResourceLocation fromPath(String path) {
        if (path.startsWith("assets/")) {
            path = path.substring("assets/".length());
        }
        String[] split = path.split("/", 2);
        return new ResourceLocation(split[0], split[1]);
    }
}

