/*
 * Decompiled with CFR 0.152.
 */
package draylar.omegaconfig.mixin;

import draylar.omegaconfig.OmegaConfig;
import draylar.omegaconfig.api.Config;
import draylar.omegaconfig.api.Syncing;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.Minecraft;
import net.minecraft.client.main.GameConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class ClientMixin {
    @Unique
    private final List<Config> savedClientConfig = new ArrayList<Config>();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onReturn(GameConfig args, CallbackInfo ci) {
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)OmegaConfig.CONFIG_SYNC_PACKET, (client, handler, buf, responseSender) -> {
            CompoundTag tag = buf.m_130260_();
            this.savedClientConfig.clear();
            client.execute(() -> {
                if (tag != null && tag.m_128441_("Configurations")) {
                    ListTag list = tag.m_128437_("Configurations", 10);
                    list.forEach(compound -> {
                        CompoundTag syncedConfiguration = (CompoundTag)compound;
                        String name = syncedConfiguration.m_128461_("ConfigName");
                        String json = syncedConfiguration.m_128461_("Serialized");
                        boolean allSync = syncedConfiguration.m_128471_("AllSync");
                        for (Config config : OmegaConfig.getRegisteredConfigurations()) {
                            if (!config.getName().equals(name)) continue;
                            Config server = (Config)OmegaConfig.GSON.fromJson(json, config.getClass());
                            Config cachedClient = (Config)OmegaConfig.GSON.fromJson(OmegaConfig.GSON.toJson((Object)config), config.getClass());
                            this.savedClientConfig.add(cachedClient);
                            for (Field field : server.getClass().getDeclaredFields()) {
                                if (!allSync && !Arrays.stream(field.getAnnotations()).anyMatch(annotation -> annotation instanceof Syncing)) continue;
                                try {
                                    field.setAccessible(true);
                                    Object serverValue = field.get(server);
                                    field.set(config, serverValue);
                                }
                                catch (IllegalAccessException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    });
                }
            });
        });
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screen/Screen;)V"}, at={@At(value="RETURN")})
    private void restoreConfigurations(CallbackInfo ci) {
        for (Config config : this.savedClientConfig) {
            for (Config potentiallySynced : OmegaConfig.getRegisteredConfigurations()) {
                if (!config.getName().equals(potentiallySynced.getName())) continue;
                boolean allConfigSyncs = Arrays.stream(config.getClass().getAnnotations()).anyMatch(annotation -> annotation instanceof Syncing);
                for (Field field : config.getClass().getDeclaredFields()) {
                    if (!allConfigSyncs && !Arrays.stream(field.getAnnotations()).anyMatch(annotation -> annotation instanceof Syncing)) continue;
                    try {
                        field.setAccessible(true);
                        Object preSyncValue = field.get(config);
                        field.set(potentiallySynced, preSyncValue);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.savedClientConfig.clear();
    }
}

