/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.mobs_of_mythology.entity.client.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.cache.object.GeoBone;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.model.GeoModel;
import mod.azure.azurelib.renderer.DynamicGeoEntityRenderer;
import mod.azure.azurelib.renderer.GeoRenderer;
import mod.azure.azurelib.renderer.layer.BlockAndItemGeoLayer;
import mod.azure.azurelib.renderer.layer.GeoRenderLayer;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.pixeldreamstudios.mobs_of_mythology.entity.client.model.KoboldWarriorModel;
import net.pixeldreamstudios.mobs_of_mythology.entity.mobs.KoboldWarriorEntity;
import net.pixeldreamstudios.mobs_of_mythology.entity.variant.KoboldWarriorVariant;
import org.jetbrains.annotations.Nullable;

public class KoboldWarriorRenderer
extends DynamicGeoEntityRenderer<KoboldWarriorEntity> {
    private static final String RIGHT_HAND = "item";
    private static final String LEFT_HAND = "item2";
    protected ItemStack mainHandItem;
    protected ItemStack offHandItem;
    public static final Map<KoboldWarriorVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.m_137469_((Object)Maps.newEnumMap(KoboldWarriorVariant.class), map -> {
        map.put(KoboldWarriorVariant.KOBOLD_WARRIOR_1, new ResourceLocation("mobs_of_mythology", "textures/entity/kobold_warrior/kobold_warrior_1.png"));
        map.put(KoboldWarriorVariant.KOBOLD_WARRIOR_2, new ResourceLocation("mobs_of_mythology", "textures/entity/kobold_warrior/kobold_warrior_2.png"));
        map.put(KoboldWarriorVariant.KOBOLD_WARRIOR_3, new ResourceLocation("mobs_of_mythology", "textures/entity/kobold_warrior/kobold_warrior_3.png"));
    });

    public KoboldWarriorRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (GeoModel)new KoboldWarriorModel());
        this.f_114477_ = 0.4f;
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<KoboldWarriorEntity>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, KoboldWarriorEntity animatable) {
                return switch (bone.getName()) {
                    case KoboldWarriorRenderer.LEFT_HAND -> {
                        if (animatable.m_21526_()) {
                            yield KoboldWarriorRenderer.this.mainHandItem;
                        }
                        yield KoboldWarriorRenderer.this.offHandItem;
                    }
                    case KoboldWarriorRenderer.RIGHT_HAND -> {
                        if (animatable.m_21526_()) {
                            yield KoboldWarriorRenderer.this.offHandItem;
                        }
                        yield KoboldWarriorRenderer.this.mainHandItem;
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, KoboldWarriorEntity animatable) {
                return switch (bone.getName()) {
                    case KoboldWarriorRenderer.LEFT_HAND, KoboldWarriorRenderer.RIGHT_HAND -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, KoboldWarriorEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == KoboldWarriorRenderer.this.mainHandItem) {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    if (stack.m_41720_() instanceof ShieldItem) {
                        poseStack.m_85837_(0.0, 0.125, -0.25);
                    }
                } else if (stack == KoboldWarriorRenderer.this.offHandItem) {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    if (stack.m_41720_() instanceof ShieldItem) {
                        poseStack.m_85837_(0.0, 0.125, 0.25);
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    }
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    public ResourceLocation getTextureLocation(KoboldWarriorEntity animatable) {
        return LOCATION_BY_VARIANT.get(animatable.getVariant());
    }

    public void preRender(PoseStack poseStack, KoboldWarriorEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        this.mainHandItem = animatable.m_21205_();
        this.offHandItem = animatable.m_21206_();
    }
}

