/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.mobs_of_mythology.entity.mobs;

import java.util.function.Predicate;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animatable.instance.SingletonAnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.object.PlayState;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.pixeldreamstudios.mobs_of_mythology.MobsOfMythology;
import net.pixeldreamstudios.mobs_of_mythology.entity.constant.DefaultMythAnimations;
import net.pixeldreamstudios.mobs_of_mythology.entity.variant.DrakeVariant;
import net.pixeldreamstudios.mobs_of_mythology.registry.ItemRegistry;
import net.pixeldreamstudios.mobs_of_mythology.registry.SoundRegistry;
import org.jetbrains.annotations.Nullable;

public class DrakeEntity
extends TamableAnimal
implements GeoEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    protected static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(DrakeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Predicate<LivingEntity> PREY_SELECTOR = livingEntity -> {
        EntityType entityType = livingEntity.m_6095_();
        return entityType == EntityType.f_20492_ || entityType == EntityType.f_20494_ || entityType == EntityType.f_20499_;
    };

    public DrakeEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 5;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        DrakeVariant variant = (DrakeVariant)((Object)Util.m_214670_((Object[])DrakeVariant.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public boolean m_5825_() {
        return true;
    }

    public void m_7105_(boolean bl) {
        super.m_7105_(bl);
        if (bl) {
            this.m_21051_(Attributes.f_22276_).m_22100_(MobsOfMythology.config.drakeHealth * 2.0);
            this.m_21153_((float)(MobsOfMythology.config.drakeHealth * 2.0));
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(MobsOfMythology.config.drakeHealth);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("Variant", this.getTypeVariant());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)nbt.m_128451_("Variant"));
    }

    public boolean m_6898_(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        return item.m_41472_() && item.m_41473_().m_38746_();
    }

    public DrakeVariant getVariant() {
        return DrakeVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private void setVariant(DrakeVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, MobsOfMythology.config.drakeHealth).m_22268_(Attributes.f_22281_, MobsOfMythology.config.drakeAttackDamage).m_22268_(Attributes.f_22283_, 2.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22279_, 0.3);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, PREY_SELECTOR));
        this.f_21346_.m_25352_(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "livingController", 3, state -> {
            if (this.m_21825_()) {
                state.getController().setAnimation(DefaultMythAnimations.SIT);
                return PlayState.CONTINUE;
            }
            if (state.isMoving() && !this.f_20911_) {
                if (this.m_5912_() && !this.f_20911_) {
                    state.getController().setAnimation(DefaultMythAnimations.RUN);
                    return PlayState.CONTINUE;
                }
                state.getController().setAnimation(DefaultMythAnimations.WALK);
                return PlayState.CONTINUE;
            }
            state.getController().setAnimation(DefaultMythAnimations.IDLE);
            return PlayState.CONTINUE;
        })}).add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 3, event -> {
            this.f_20911_ = false;
            return PlayState.STOP;
        }).triggerableAnim("attack", DefaultMythAnimations.ATTACK)});
    }

    public boolean m_7327_(Entity entity) {
        this.triggerAnim("attackController", "attack");
        return super.m_7327_(entity);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        Item item = itemStack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean bl = this.m_21830_((LivingEntity)player) || this.m_21824_() || itemStack.m_150930_((Item)ItemRegistry.COOKED_CHUPACABRA_MEAT.get()) && !this.m_21824_();
            return bl ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_6898_(itemStack) && this.m_21223_() < this.m_21233_()) {
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                this.m_5634_(2.0f * (float)item.m_41473_().m_38744_());
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionResult = super.m_6071_(player, interactionHand);
            if (interactionResult.m_19077_() && !this.m_6162_() || !this.m_21830_((LivingEntity)player)) {
                return interactionResult;
            }
            this.m_21839_(!this.m_21827_());
            this.f_20899_ = false;
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            return InteractionResult.SUCCESS;
        }
        if (!itemStack.m_150930_((Item)ItemRegistry.COOKED_CHUPACABRA_MEAT.get())) {
            return super.m_6071_(player, interactionHand);
        }
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            this.m_21828_(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.m_21839_(true);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
            return InteractionResult.SUCCESS;
        }
        this.m_9236_().m_7605_((Entity)this, (byte)6);
        return InteractionResult.SUCCESS;
    }

    private void tryToTame(Player player) {
        if (this.f_19796_.m_188503_(3) == 0) {
            this.m_21828_(player);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.m_21839_(true);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
    }

    protected SoundEvent m_7515_() {
        this.m_5496_((SoundEvent)SoundRegistry.DRAKE_ROAR.get(), 1.0f, 1.0f);
        return null;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        this.m_5496_((SoundEvent)SoundRegistry.DRAKE_ROAR.get(), 1.0f, 2.0f);
        return null;
    }

    protected SoundEvent m_5592_() {
        this.m_5496_((SoundEvent)SoundRegistry.DRAKE_DEATH.get(), 1.0f, 1.0f);
        return null;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12624_, 0.75f, 1.0f);
    }
}

