/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.mobs_of_mythology.entity.mobs;

import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.pixeldreamstudios.mobs_of_mythology.MobsOfMythology;
import net.pixeldreamstudios.mobs_of_mythology.entity.AbstractMythMonsterEntity;
import net.pixeldreamstudios.mobs_of_mythology.entity.mobs.AbstractKoboldEntity;
import net.pixeldreamstudios.mobs_of_mythology.entity.variant.KoboldVariant;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FleeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.navigation.SmoothGroundNavigation;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class KoboldEntity
extends AbstractKoboldEntity {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(KoboldEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    public KoboldEntity(EntityType<? extends AbstractKoboldEntity> entityType, Level world) {
        super(entityType, world, 3);
        this.f_21344_ = new SmoothGroundNavigation((Mob)this, this.m_9236_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (!this.getItemStack().m_41619_()) {
            nbt.m_128365_("ItemStack", (Tag)this.getItemStack().m_41739_(new CompoundTag()));
        }
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setItemStack(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ItemStack")));
    }

    protected boolean m_6125_() {
        return false;
    }

    public void setItemStack(ItemStack itemStack) {
        this.m_20088_().m_135381_(DATA_ITEM_STACK, (Object)itemStack);
        this.m_5496_(SoundEvents.f_12577_, 1.0f, 2.0f);
        this.m_21008_(InteractionHand.MAIN_HAND, itemStack);
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        KoboldVariant variant = (KoboldVariant)((Object)Util.m_214670_((Object[])KoboldVariant.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public void m_6667_(DamageSource arg) {
        super.m_6667_(arg);
        ItemStack itemStack = this.getItemStack();
        if (!itemStack.m_41619_()) {
            this.m_19983_(itemStack.m_41620_(1));
            this.setItemStack(ItemStack.f_41583_);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, MobsOfMythology.config.koboldHealth).m_22268_(Attributes.f_22281_, MobsOfMythology.config.koboldAttackDamage).m_22268_(Attributes.f_22283_, 2.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    @Override
    public BrainActivityGroup<AbstractMythMonsterEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((target, entity) -> !target.m_6084_() || !entity.m_142582_((Entity)target)), new SetWalkTargetToAttackTarget().startCondition(mob -> this.getItemStack().m_41619_() && !this.m_5448_().m_21120_(InteractionHand.MAIN_HAND).m_41619_()), new AnimatableMeleeAttack(6).whenStarting(mob -> this.triggerAnim("attackController", "attack")).startCondition(mob -> this.getItemStack().m_41619_() && !this.m_5448_().m_21120_(InteractionHand.MAIN_HAND).m_41619_()).stopIf(mob -> !this.getItemStack().m_41619_()).whenStopping(mob -> {
            LivingEntity target = this.m_5448_();
            this.setItemStack(target.m_21120_(InteractionHand.MAIN_HAND).m_41777_());
            target.m_21120_(InteractionHand.MAIN_HAND).m_41774_(this.getItemStack().m_41613_());
        }), new FleeTarget().speedModifier(2.0f).startCondition(mob -> !this.getItemStack().m_41619_() || BrainUtils.getTargetOfEntity((LivingEntity)this).m_7306_((Entity)BrainUtils.getLastAttacker((LivingEntity)this)))});
    }

    @Override
    public <T> T getVariant() {
        return (T)((Object)KoboldVariant.byId(this.getTypeVariant() & 0xFF));
    }

    private void setVariant(KoboldVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }
}

