/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.mobs_of_mythology.entity.mobs;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.pixeldreamstudios.mobs_of_mythology.MobsOfMythology;
import net.pixeldreamstudios.mobs_of_mythology.entity.AbstractMythMonsterEntity;
import net.pixeldreamstudios.mobs_of_mythology.entity.mobs.AbstractKoboldEntity;
import net.pixeldreamstudios.mobs_of_mythology.entity.mobs.AutomatonEntity;
import net.pixeldreamstudios.mobs_of_mythology.entity.variant.KoboldWarriorVariant;
import net.pixeldreamstudios.mobs_of_mythology.registry.ItemRegistry;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import org.jetbrains.annotations.Nullable;

public class KoboldWarriorEntity
extends AbstractKoboldEntity {
    public KoboldWarriorEntity(EntityType<? extends AbstractKoboldEntity> entityType, Level world) {
        super(entityType, world, 5);
        this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)ItemRegistry.KOBOLD_SPEAR.get(), 1));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        KoboldWarriorVariant variant = (KoboldWarriorVariant)((Object)Util.m_214670_((Object[])KoboldWarriorVariant.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, MobsOfMythology.config.koboldWarriorHealth).m_22268_(Attributes.f_22284_, MobsOfMythology.config.koboldWarriorArmor).m_22268_(Attributes.f_22281_, MobsOfMythology.config.koboldWarriorAttackDamage).m_22268_(Attributes.f_22283_, 2.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    @Override
    public List<ExtendedSensor<AbstractMythMonsterEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyLivingEntitySensor().setPredicate((target, entity) -> target instanceof Player || target instanceof Villager || target instanceof IronGolem || target instanceof AutomatonEntity), new HurtBySensor()});
    }

    @Override
    public BrainActivityGroup<AbstractMythMonsterEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((target, entity) -> !target.m_6084_() || !entity.m_142582_((Entity)target)), new SetWalkTargetToAttackTarget().speedMod((mob, livingEntity) -> Float.valueOf(1.25f)), new AnimatableMeleeAttack(6).whenStarting(mob -> this.triggerAnim("attackController", "attack"))});
    }

    @Override
    public <T> T getVariant() {
        return (T)((Object)KoboldWarriorVariant.byId(this.getTypeVariant() & 0xFF));
    }

    private void setVariant(KoboldWarriorVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }
}

