/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.mobs_of_mythology.entity.mobs;

import java.util.Arrays;
import java.util.List;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animatable.instance.SingletonAnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.core.object.PlayState;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.pixeldreamstudios.mobs_of_mythology.MobsOfMythology;
import net.pixeldreamstudios.mobs_of_mythology.entity.constant.DefaultMythAnimations;
import net.pixeldreamstudios.mobs_of_mythology.entity.variant.SporelingVariant;
import org.jetbrains.annotations.Nullable;

public class SporelingEntity
extends PathfinderMob
implements GeoEntity {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public static final RawAnimation BOUNCE = RawAnimation.begin().thenPlay("bounce");
    protected static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(SporelingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Component currentLine;
    private String[] lines;
    private List<String> greetings;
    private int lineCooldown = 60;
    private boolean touched = false;
    private boolean startCountdown = false;
    private boolean talk = true;
    private SoundEvent interactSound;

    public SporelingEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 1;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, MobsOfMythology.config.sporelingHealth).m_22268_(Attributes.f_22279_, 0.3);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        SporelingVariant variant = (SporelingVariant)((Object)Util.m_214670_((Object[])SporelingVariant.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public SporelingVariant getVariant() {
        return SporelingVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private void setVariant(SporelingVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("Variant", this.getTypeVariant());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)nbt.m_128451_("Variant"));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, (double)0.8f));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.75));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.startCountdown) {
            --this.lineCooldown;
            if (this.lineCooldown <= 0) {
                this.startCountdown = false;
                this.talk = true;
                this.lineCooldown = 60;
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "livingController", 3, state -> {
            if (state.isMoving()) {
                state.getController().setAnimation(DefaultMythAnimations.WALK);
                return PlayState.CONTINUE;
            }
            state.getController().setAnimation(DefaultMythAnimations.IDLE);
            return PlayState.CONTINUE;
        })});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "bounceController", 3, state -> {
            if (this.touched) {
                state.getController().forceAnimationReset();
                state.getController().setAnimation(BOUNCE);
                this.touched = false;
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.getVariant().equals((Object)SporelingVariant.RED)) {
            this.interactSound = SoundEvents.f_12509_;
            this.lines = MobsOfMythology.config.redSporelingLines;
            this.greetings = Arrays.asList("Hello there, ", "Hey there, ", "Howdy, ", "Howdy-do, ", "Salutations, ", "Hiya, ", "Godspeed, ");
        } else {
            this.interactSound = SoundEvents.f_12507_;
            this.lines = MobsOfMythology.config.brownSporelingLines;
        }
        this.currentLine = Component.m_237113_((String)this.lines[this.f_19796_.m_188503_(this.lines.length)]);
        if (this.talk) {
            this.touched = true;
            this.talk = false;
            this.startCountdown = true;
            Component previousLine = this.currentLine;
            do {
                this.currentLine = Component.m_237113_((String)this.lines[this.f_19796_.m_188503_(this.lines.length)]);
                if (!this.currentLine.equals((Object)Component.m_237113_((String)"playerGreeting"))) continue;
                this.currentLine = Component.m_237113_((String)(this.greetings.get(this.f_19796_.m_188503_(this.greetings.size())) + player.m_6302_() + "!"));
            } while (this.currentLine.equals((Object)previousLine));
            MinecraftServer server = player.m_20194_();
            if (server != null) {
                this.m_5496_(this.interactSound, 1.0f, 15.0f);
                server.m_6937_((Runnable)new TickTask(0, () -> player.m_5661_(this.currentLine, true)));
            }
        }
        return super.m_6071_(player, hand);
    }

    protected SoundEvent m_7515_() {
        this.m_5496_(SoundEvents.f_12503_, 1.0f, 15.0f);
        return null;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        this.m_5496_(SoundEvents.f_12506_, 1.0f, 15.0f);
        return null;
    }

    protected SoundEvent m_5592_() {
        this.m_5496_(SoundEvents.f_12505_, 1.0f, 15.0f);
        return null;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12624_, 0.25f, 15.0f);
    }
}

