/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.mobs_of_mythology.registry;

import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.level.entity.SpawnPlacementsRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.pixeldreamstudios.mobs_of_mythology.MobsOfMythology;
import net.pixeldreamstudios.mobs_of_mythology.entity.mobs.AutomatonEntity;
import net.pixeldreamstudios.mobs_of_mythology.entity.mobs.ChupacabraEntity;
import net.pixeldreamstudios.mobs_of_mythology.entity.mobs.DrakeEntity;
import net.pixeldreamstudios.mobs_of_mythology.entity.mobs.KoboldEntity;
import net.pixeldreamstudios.mobs_of_mythology.entity.mobs.KoboldWarriorEntity;
import net.pixeldreamstudios.mobs_of_mythology.entity.mobs.SporelingEntity;
import net.pixeldreamstudios.mobs_of_mythology.registry.TagRegistry;

public class EntityRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((String)"mobs_of_mythology", (ResourceKey)Registries.f_256939_);
    public static final RegistrySupplier<EntityType<AutomatonEntity>> AUTOMATON = ENTITIES.register("automaton", () -> EntityType.Builder.m_20704_(AutomatonEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.5f, 2.9f).m_20712_(new ResourceLocation("mobs_of_mythology", "automaton").toString()));
    public static final RegistrySupplier<EntityType<ChupacabraEntity>> CHUPACABRA = ENTITIES.register("chupacabra", () -> EntityType.Builder.m_20704_(ChupacabraEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.25f, 1.0f).m_20712_(new ResourceLocation("mobs_of_mythology", "chupacabra").toString()));
    public static final RegistrySupplier<EntityType<KoboldEntity>> KOBOLD = ENTITIES.register("kobold", () -> EntityType.Builder.m_20704_(KoboldEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.75f, 1.75f).m_20712_(new ResourceLocation("mobs_of_mythology", "kobold").toString()));
    public static final RegistrySupplier<EntityType<KoboldWarriorEntity>> KOBOLD_WARRIOR = ENTITIES.register("kobold_warrior", () -> EntityType.Builder.m_20704_(KoboldWarriorEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.75f, 1.75f).m_20712_(new ResourceLocation("mobs_of_mythology", "kobold_warrior").toString()));
    public static final RegistrySupplier<EntityType<DrakeEntity>> DRAKE = ENTITIES.register("drake", () -> EntityType.Builder.m_20704_(DrakeEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.25f, 1.0f).m_20712_(new ResourceLocation("mobs_of_mythology", "drake").toString()));
    public static final RegistrySupplier<EntityType<SporelingEntity>> SPORELING = ENTITIES.register("sporeling", () -> EntityType.Builder.m_20704_(SporelingEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.0f, 0.8f).m_20712_(new ResourceLocation("mobs_of_mythology", "sporeling").toString()));

    private static void initSpawns() {
        SpawnPlacementsRegistry.register(KOBOLD, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219019_);
        BiomeModifications.addProperties(b -> b.hasTag(TagRegistry.WET_BIOMES), (ctx, b) -> b.getSpawnProperties().addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)KOBOLD.get(), MobsOfMythology.config.koboldSpawnWeight, 2, 4)));
        SpawnPlacementsRegistry.register(KOBOLD_WARRIOR, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219019_);
        BiomeModifications.addProperties(b -> b.hasTag(TagRegistry.WET_BIOMES), (ctx, b) -> b.getSpawnProperties().addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)KOBOLD_WARRIOR.get(), MobsOfMythology.config.koboldWarriorSpawnWeight, 2, 3)));
        SpawnPlacementsRegistry.register(DRAKE, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        BiomeModifications.addProperties(b -> b.hasTag(TagRegistry.BADLANDS_BIOMES), (ctx, b) -> b.getSpawnProperties().addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)DRAKE.get(), MobsOfMythology.config.drakeSpawnWeight, 1, 1)));
        SpawnPlacementsRegistry.register(CHUPACABRA, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219019_);
        BiomeModifications.addProperties(b -> b.hasTag(TagRegistry.TEMPERATE_BIOMES), (ctx, b) -> b.getSpawnProperties().addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)CHUPACABRA.get(), MobsOfMythology.config.chupacabraSpawnWeight, 1, 1)));
        SpawnPlacementsRegistry.register(SPORELING, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        BiomeModifications.addProperties(b -> b.hasTag(TagRegistry.MUSHROOM_BIOMES), (ctx, b) -> b.getSpawnProperties().addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)SPORELING.get(), MobsOfMythology.config.sporelingSpawnWeight, 4, 6)));
    }

    private static void initAttributes() {
        EntityAttributeRegistry.register(AUTOMATON, AutomatonEntity::createAttributes);
        EntityAttributeRegistry.register(CHUPACABRA, ChupacabraEntity::createAttributes);
        EntityAttributeRegistry.register(CHUPACABRA, ChupacabraEntity::createAttributes);
        EntityAttributeRegistry.register(KOBOLD, KoboldEntity::createAttributes);
        EntityAttributeRegistry.register(KOBOLD_WARRIOR, KoboldWarriorEntity::createAttributes);
        EntityAttributeRegistry.register(DRAKE, DrakeEntity::createAttributes);
        EntityAttributeRegistry.register(SPORELING, SporelingEntity::createAttributes);
    }

    public static void init() {
        ENTITIES.register();
        EntityRegistry.initAttributes();
        EntityRegistry.initSpawns();
    }
}

