/*
 * Decompiled with CFR 0.152.
 */
package codes.ztereohype.nicerskies.core;

import java.util.Map;
import java.util.TreeMap;

public class Gradient {
    private final TreeMap<Double, int[]> gradient = new TreeMap();

    public void add(double index, int red, int green, int blue) {
        if (index < 0.0 || index > 1.0) {
            throw new IllegalArgumentException("Index must be between 0 and 1");
        }
        int[] color = new int[]{red, green, blue};
        this.gradient.put(index, color);
    }

    public void remove(double index) {
        this.gradient.remove(index);
    }

    public void clear() {
        this.gradient.clear();
    }

    public int[] getAt(double value) {
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("Value must be between 0 and 1");
        }
        Map.Entry<Double, int[]> floorEntry = this.gradient.floorEntry(value);
        if (floorEntry == null) {
            return this.gradient.firstEntry().getValue();
        }
        Map.Entry<Double, int[]> ceilingEntry = this.gradient.ceilingEntry(value);
        if (ceilingEntry == null) {
            return this.gradient.lastEntry().getValue();
        }
        double ratio = (value - floorEntry.getKey()) / (ceilingEntry.getKey() - floorEntry.getKey());
        double invRatio = 1.0 - ratio;
        int[] firstColor = floorEntry.getValue();
        int[] secondColor = ceilingEntry.getValue();
        long red = Math.round((double)secondColor[0] * ratio + (double)firstColor[0] * invRatio);
        long green = Math.round((double)secondColor[1] * ratio + (double)firstColor[1] * invRatio);
        long blue = Math.round((double)secondColor[2] * ratio + (double)firstColor[2] * invRatio);
        return new int[]{(int)red, (int)green, (int)blue};
    }
}

