/*
 * Decompiled with CFR 0.152.
 */
package codes.ztereohype.nicerskies.gui;

import codes.ztereohype.nicerskies.NicerSkies;
import codes.ztereohype.nicerskies.config.Config;
import codes.ztereohype.nicerskies.core.NebulaSeedManager;
import codes.ztereohype.nicerskies.gui.widget.Separator;
import codes.ztereohype.nicerskies.gui.widget.TooltippedCheckbox;
import codes.ztereohype.nicerskies.gui.widget.TooltippedSliderButton;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;

public class ConfigScreen
extends Screen {
    private final Screen lastScreen;
    private final Config config;
    private Config.ConfigData newConfig;
    private boolean invalidated = false;

    protected ConfigScreen(Screen lastScreen) {
        super((Component)Component.m_237115_((String)"nicer_skies.menu.settings"));
        this.lastScreen = lastScreen;
        this.config = NicerSkies.getInstance().getConfig();
        this.wipeConfig();
    }

    private void wipeConfig() {
        this.newConfig = this.config.getConfigData().toBuilder().build();
        this.newConfig.setNebulaConfig(this.config.getConfigData().getNebulaConfig().toBuilder().build());
    }

    public void m_7856_() {
        int btnDst = 24;
        int nebulaOptMargin = this.f_96543_ / 2 + (this.f_96543_ / 2 - 150) / 2;
        boolean renderNebulas = this.newConfig.isRenderNebulas();
        boolean dimensionalNebulas = this.newConfig.isNebulasInOtherDimensions();
        boolean twinkleStars = this.newConfig.isTwinklingStars();
        boolean lightmapTweaked = this.newConfig.isLightmapTweaked();
        boolean renderDuringDay = this.newConfig.getNebulaConfig().isRenderDuringDay();
        float nebulaStrength = this.newConfig.getNebulaConfig().getNebulaStrength();
        float nebulaNoiseAmount = this.newConfig.getNebulaConfig().getNebulaNoiseAmount();
        int nebulaBaseColourAmount = this.newConfig.getNebulaConfig().getBaseColourAmount();
        float nebulaNoiseScale = this.newConfig.getNebulaConfig().getNebulaNoiseScale();
        int Y = 60;
        this.m_142416_((GuiEventListener)new TooltippedCheckbox(20, Y, 20, 20, (Component)Component.m_237115_((String)"nicer_skies.option.render_nebulas"), renderNebulas, selected -> {
            this.newConfig.setRenderNebulas((boolean)selected);
            this.invalidated = true;
        }, null));
        this.m_142416_((GuiEventListener)new TooltippedCheckbox(40, Y += btnDst, 20, 20, (Component)Component.m_237115_((String)"nicer_skies.option.dimensional_nebulas"), dimensionalNebulas, selected -> {
            this.newConfig.setNebulasInOtherDimensions((boolean)selected);
            this.invalidated = true;
        }, null){

            public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
                this.f_93623_ = ConfigScreen.this.newConfig.isRenderNebulas();
                super.m_88315_(g, mouseX, mouseY, partialTick);
            }
        });
        this.m_142416_((GuiEventListener)new TooltippedCheckbox(20, Y += btnDst, 20, 20, (Component)Component.m_237115_((String)"nicer_skies.option.twinkle_stars"), twinkleStars, selected -> {
            this.newConfig.setTwinklingStars((boolean)selected);
            this.invalidated = true;
        }, null));
        this.m_142416_((GuiEventListener)new TooltippedCheckbox(20, Y += btnDst, 20, 20, (Component)Component.m_237115_((String)"nicer_skies.option.custom_lightmap"), lightmapTweaked, selected -> {
            this.newConfig.setLightmapTweaked((boolean)selected);
            Minecraft.m_91087_().f_91063_.m_109154_().m_109880_();
            this.invalidated = true;
        }, Tooltip.m_257550_((Component)Component.m_237115_((String)"nicer_skies.option.custom_lightmap.tooltip"))));
        this.m_169394_(new Separator(this.f_96543_ / 2, 30, this.f_96544_ - 70));
        Y = 60;
        this.m_142416_((GuiEventListener)new TooltippedCheckbox(nebulaOptMargin, Y, 20, 20, (Component)Component.m_237115_((String)"nicer_skies.option.render_during_day"), renderDuringDay, selected -> {
            this.newConfig.getNebulaConfig().setRenderDuringDay((boolean)selected);
            this.invalidated = true;
        }, Tooltip.m_257550_((Component)Component.m_237115_((String)"nicer_skies.option.render_during_day.tooltip"))));
        this.m_142416_((GuiEventListener)new TooltippedSliderButton(nebulaOptMargin, Y += btnDst, 150, 20, (Component)Component.m_237110_((String)"nicer_skies.option.nebula_transparency", (Object[])new Object[]{(int)(nebulaStrength * 100.0f) + "%"}), nebulaStrength, value -> Component.m_237110_((String)"nicer_skies.option.nebula_transparency", (Object[])new Object[]{(int)(value * 100.0) + "%"}), value -> {
            this.newConfig.getNebulaConfig().setNebulaStrength(value.floatValue());
            this.invalidated = true;
        }, Tooltip.m_257550_((Component)Component.m_237115_((String)"nicer_skies.option.nebula_transparency.tooltip"))));
        this.m_142416_((GuiEventListener)new TooltippedSliderButton(nebulaOptMargin, Y += btnDst, 150, 20, (Component)Component.m_237110_((String)"nicer_skies.option.nebula_amount", (Object[])new Object[]{(int)(nebulaNoiseAmount * 100.0f) + "%"}), nebulaNoiseAmount, value -> Component.m_237110_((String)"nicer_skies.option.nebula_amount", (Object[])new Object[]{(int)(value * 100.0) + "%"}), value -> {
            this.newConfig.getNebulaConfig().setNebulaNoiseAmount(value.floatValue());
            this.invalidated = true;
        }, Tooltip.m_257550_((Component)Component.m_237115_((String)"nicer_skies.option.nebula_amount.tooltip"))));
        this.m_142416_((GuiEventListener)new TooltippedSliderButton(nebulaOptMargin, Y += btnDst, 150, 20, (Component)Component.m_237110_((String)"nicer_skies.option.background_strength", (Object[])new Object[]{nebulaBaseColourAmount}), (float)nebulaBaseColourAmount / 255.0f, value -> Component.m_237110_((String)"nicer_skies.option.background_strength", (Object[])new Object[]{(int)(value * 255.0)}), value -> {
            this.newConfig.getNebulaConfig().setBaseColourAmount((int)(value * 255.0));
            this.invalidated = true;
        }, Tooltip.m_257550_((Component)Component.m_237115_((String)"nicer_skies.option.background_strength.tooltip"))));
        this.m_142416_((GuiEventListener)new TooltippedSliderButton(nebulaOptMargin, Y += btnDst, 150, 20, (Component)Component.m_237110_((String)"nicer_skies.option.nebula_scale", (Object[])new Object[]{Float.valueOf(nebulaNoiseScale)}), this.mapValueToScale(nebulaNoiseScale), value -> Component.m_237110_((String)"nicer_skies.option.nebula_scale", (Object[])new Object[]{Float.valueOf(this.mapScaleToValue((double)value))}), value -> {
            this.newConfig.getNebulaConfig().setNebulaNoiseScale(this.mapScaleToValue((double)value));
            this.invalidated = true;
        }, Tooltip.m_257550_((Component)Component.m_237115_((String)"nicer_skies.option.nebula_scale.tooltip"))));
        this.m_142416_((GuiEventListener)new Button(nebulaOptMargin, Y += btnDst, 150, 20, (Component)Component.m_237115_((String)"nicer_skies.menu.reset"), button -> {
            this.newConfig.setNebulaConfig(Config.DEFAULT_CONFIG.getNebulaConfig().toBuilder().build());
            this.m_232761_();
            this.invalidated = true;
        }, Supplier::get){

            public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
                this.f_93623_ = !ConfigScreen.this.isDefaultNebulaSettings();
                super.m_88315_(g, mouseX, mouseY, partialTick);
            }
        });
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 4, this.f_96544_ - 28, 150, 20, (Component)Component.m_237115_((String)"nicer_skies.menu.apply"), button -> {
            this.config.updateConfig(this.newConfig);
            this.regenerateSky();
            this.invalidated = false;
        }, Supplier::get){

            public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
                this.f_93623_ = ConfigScreen.this.invalidated;
                super.m_88315_(g, mouseX, mouseY, partialTick);
            }
        });
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"nicer_skies.menu.back"), button -> this.m_7379_()).m_252794_(this.f_96543_ / 2 - 154, this.f_96544_ - 28).m_253046_(150, 20).m_253136_());
        super.m_7856_();
    }

    public void m_88315_(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(g);
        super.m_88315_(g, mouseX, mouseY, partialTick);
        g.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, 0xFFFFFF);
        g.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"nicer_skies.menu.subtitle.feature_toggles"), this.f_96543_ / 4, 36, 0xFFFFFF);
        g.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"nicer_skies.menu.subtitle.nebula_settings"), 3 * this.f_96543_ / 4, 36, 0xFFFFFF);
        this.drawWrappedComponent(g, (FormattedText)Component.m_237115_((String)"nicer_skies.menu.compatibility_warning"), 20, 160, this.f_96543_ / 2 - 40);
    }

    public void m_7379_() {
        this.wipeConfig();
        this.f_96541_.m_91152_(this.lastScreen);
    }

    private void regenerateSky() {
        if (NebulaSeedManager.canGenerateSky()) {
            NicerSkies.getInstance().getSkyManager().generateSky(NebulaSeedManager.getSeed());
        }
        this.invalidated = false;
    }

    private boolean isDefaultNebulaSettings() {
        return this.newConfig.getNebulaConfig().equals(Config.DEFAULT_CONFIG.getNebulaConfig());
    }

    private void drawWrappedComponent(GuiGraphics g, FormattedText component, int x, int y, int wrapWidth) {
        Minecraft mc = Minecraft.m_91087_();
        List lines = mc.f_91062_.m_92865_().m_92414_(component, wrapWidth, Style.f_131099_);
        int amount = lines.size();
        for (int i = 0; i < amount; ++i) {
            FormattedText renderable = (FormattedText)lines.get(i);
            g.m_280488_(this.f_96547_, renderable.getString(), x, y + i * 9, -1);
        }
    }

    private float mapScaleToValue(double value) {
        return (float)Math.round(1.0 / (value * 1.5 + 0.5) * 100.0) / 100.0f;
    }

    private float mapValueToScale(double value) {
        return (float)(1.0 / value - 0.5) / 1.5f;
    }
}

