/*
 * Decompiled with CFR 0.152.
 */
package codes.ztereohype.nicerskies.sky.nebula;

import codes.ztereohype.nicerskies.core.Gradient;
import codes.ztereohype.nicerskies.sky.nebula.SkyboxPainter;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;

public class NebulaSkyboxPainter
extends SkyboxPainter {
    private final float scalingFactor;
    private final float noiseAmount;
    private final int baseColourStrength;
    private final Gradient nebulaGradient;

    public NebulaSkyboxPainter(PerlinNoise noise, Gradient nebulaGradient, float scalingFactor, float noiseAmount, int baseColourStrength) {
        super(noise);
        this.nebulaGradient = nebulaGradient;
        this.scalingFactor = scalingFactor;
        this.noiseAmount = noiseAmount;
        this.baseColourStrength = baseColourStrength;
    }

    @Override
    int getTexelColour(float x, float y, float z) {
        float[] projCoords = this.projectOnSphere(x, y, z);
        x = projCoords[0];
        y = projCoords[1];
        z = projCoords[2];
        float offset = (float)this.noise.m_75408_((double)(x * this.scalingFactor * 3.0f), (double)(y * this.scalingFactor * 3.0f), (double)(z * this.scalingFactor * 3.0f));
        x = Mth.m_14036_((float)(x + offset / 5.0f), (float)-1.0f, (float)1.0f);
        y = Mth.m_14036_((float)(y + offset / 5.0f), (float)-1.0f, (float)1.0f);
        z = Mth.m_14036_((float)(z + offset / 5.0f), (float)-1.0f, (float)1.0f);
        double noiseValue = Mth.m_14008_((double)(this.noise.m_75408_((double)(x * this.scalingFactor), (double)(y * this.scalingFactor), (double)(z * this.scalingFactor)) + 0.5), (double)0.0, (double)1.0);
        double[] ds = new double[3];
        this.noise.m_75424_(0).m_164312_((double)(x * this.scalingFactor), (double)(y * this.scalingFactor), (double)(z * this.scalingFactor), ds);
        int baseB = (int)(((double)(x / 2.0f) + 0.5) * (double)this.baseColourStrength);
        int baseG = (int)(((double)(y / 2.0f) + 0.5) * (double)this.baseColourStrength);
        int baseR = (int)(((double)(z / 2.0f) + 0.5) * (double)this.baseColourStrength);
        double nebulaFactor = this.noiseAmount != 0.0f ? Mth.m_14008_((double)(noiseValue * (1.0 / (double)this.noiseAmount) - (1.0 / (double)this.noiseAmount - 1.0)), (double)0.0, (double)0.99) : 0.0;
        int[] nebula = this.nebulaGradient.getAt(nebulaFactor);
        double bgFactor = Mth.m_14008_((double)(Math.log10(-nebulaFactor + 1.0) + 1.0), (double)0.0, (double)1.0);
        int r = Mth.m_14045_((int)((int)(nebulaFactor * (double)nebula[0] - ds[0] * nebulaFactor * 128.0 + (double)baseR * bgFactor)), (int)0, (int)255);
        int g = Mth.m_14045_((int)((int)(nebulaFactor * (double)nebula[1] - ds[1] * nebulaFactor * 64.0 + (double)baseG * bgFactor)), (int)0, (int)255);
        int b = Mth.m_14045_((int)((int)(nebulaFactor * (double)nebula[2] - ds[2] * nebulaFactor * 128.0 + (double)baseB * bgFactor)), (int)0, (int)255);
        int alpha = Mth.m_14045_((int)((int)((1.0 - bgFactor) * 255.0)), (int)50, (int)255);
        return FastColor.ARGB32.m_13660_((int)alpha, (int)b, (int)g, (int)r);
    }
}

