/*
 * Decompiled with CFR 0.152.
 */
package codes.ztereohype.nicerskies.sky.nebula;

import codes.ztereohype.nicerskies.NicerSkies;
import codes.ztereohype.nicerskies.config.Config;
import codes.ztereohype.nicerskies.sky.nebula.SkyboxPainter;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class Skybox {
    public static final int RESOLUTION = 768;
    private final DynamicTexture skyTexture = new DynamicTexture(3072, 3072, false);
    private final ExecutorService skyExecutor = Executors.newCachedThreadPool();
    private final VertexBuffer skyboxBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);

    public Skybox(SkyboxPainter painter) {
        this.generateVertices();
        this.paint(painter);
    }

    public void render(PoseStack poseStack, Matrix4f projectionMatrix) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (int)this.skyTexture.m_117963_());
        float alpha = this.getSkyboxBrightness(Minecraft.m_91087_().f_91073_);
        RenderSystem.setShaderColor((float)alpha, (float)alpha, (float)alpha, (float)1.0f);
        this.skyboxBuffer.m_85921_();
        this.skyboxBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, GameRenderer.m_172817_());
    }

    public void paint(SkyboxPainter painter) {
        NativeImage skyNativeTex = this.skyTexture.m_117991_();
        CountDownLatch latch = new CountDownLatch(PaintTask.TextureLocation.values().length);
        for (PaintTask.TextureLocation location : PaintTask.TextureLocation.values()) {
            this.skyExecutor.execute(new PaintTask(skyNativeTex, painter, location, latch));
        }
        try {
            latch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.skyTexture.m_117985_();
    }

    private void generateVertices() {
        BufferBuilder skyboxBuilder = Tesselator.m_85913_().m_85915_();
        skyboxBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        skyboxBuilder.m_5483_(-80.0, -80.0, 80.0).m_7421_(0.25f, 0.25f).m_5752_();
        skyboxBuilder.m_5483_(-80.0, 80.0, 80.0).m_7421_(0.25f, 0.5f).m_5752_();
        skyboxBuilder.m_5483_(80.0, 80.0, 80.0).m_7421_(0.5f, 0.5f).m_5752_();
        skyboxBuilder.m_5483_(80.0, -80.0, 80.0).m_7421_(0.5f, 0.25f).m_5752_();
        skyboxBuilder.m_5483_(-80.0, -80.0, -80.0).m_7421_(0.75f, 0.25f).m_5752_();
        skyboxBuilder.m_5483_(80.0, -80.0, -80.0).m_7421_(1.0f, 0.25f).m_5752_();
        skyboxBuilder.m_5483_(80.0, 80.0, -80.0).m_7421_(1.0f, 0.5f).m_5752_();
        skyboxBuilder.m_5483_(-80.0, 80.0, -80.0).m_7421_(0.75f, 0.5f).m_5752_();
        skyboxBuilder.m_5483_(-80.0, -80.0, -80.0).m_7421_(0.5f, 0.5f).m_5752_();
        skyboxBuilder.m_5483_(-80.0, -80.0, 80.0).m_7421_(0.5f, 0.75f).m_5752_();
        skyboxBuilder.m_5483_(80.0, -80.0, 80.0).m_7421_(0.75f, 0.75f).m_5752_();
        skyboxBuilder.m_5483_(80.0, -80.0, -80.0).m_7421_(0.75f, 0.5f).m_5752_();
        skyboxBuilder.m_5483_(-80.0, 80.0, -80.0).m_7421_(0.5f, 0.0f).m_5752_();
        skyboxBuilder.m_5483_(80.0, 80.0, -80.0).m_7421_(0.75f, 0.0f).m_5752_();
        skyboxBuilder.m_5483_(80.0, 80.0, 80.0).m_7421_(0.75f, 0.25f).m_5752_();
        skyboxBuilder.m_5483_(-80.0, 80.0, 80.0).m_7421_(0.5f, 0.25f).m_5752_();
        skyboxBuilder.m_5483_(80.0, -80.0, -80.0).m_7421_(0.5f, 0.25f).m_5752_();
        skyboxBuilder.m_5483_(80.0, -80.0, 80.0).m_7421_(0.75f, 0.25f).m_5752_();
        skyboxBuilder.m_5483_(80.0, 80.0, 80.0).m_7421_(0.75f, 0.5f).m_5752_();
        skyboxBuilder.m_5483_(80.0, 80.0, -80.0).m_7421_(0.5f, 0.5f).m_5752_();
        skyboxBuilder.m_5483_(-80.0, -80.0, -80.0).m_7421_(0.0f, 0.25f).m_5752_();
        skyboxBuilder.m_5483_(-80.0, 80.0, -80.0).m_7421_(0.0f, 0.5f).m_5752_();
        skyboxBuilder.m_5483_(-80.0, 80.0, 80.0).m_7421_(0.25f, 0.5f).m_5752_();
        skyboxBuilder.m_5483_(-80.0, -80.0, 80.0).m_7421_(0.25f, 0.25f).m_5752_();
        this.skyboxBuffer.m_85921_();
        this.skyboxBuffer.m_231221_(skyboxBuilder.m_231175_());
    }

    private float getSkyboxBrightness(ClientLevel level) {
        Config config = NicerSkies.getInstance().getConfig();
        float strength = config.getNebulaStrength();
        boolean renderDuringDay = config.getRenderDuringDay();
        float timeOfDay = level.m_46942_(0.0f);
        float nightness = 1.0f - (Mth.m_14089_((float)(timeOfDay * ((float)Math.PI * 2))) * 4.0f + 0.5f);
        nightness = Mth.m_14036_((float)nightness, (float)(renderDuringDay ? 1.0f : 0.0f), (float)1.0f);
        float rain = level.m_46722_(0.0f);
        return nightness * (1.0f - rain) * strength;
    }

    public VertexBuffer getSkyboxBuffer() {
        return this.skyboxBuffer;
    }

    private static class PaintTask
    implements Runnable {
        private NativeImage skyNativeTex;
        private SkyboxPainter painter;
        private TextureLocation location;
        private CountDownLatch latch;

        @Override
        public void run() {
            for (int texY = 0; texY < 768; ++texY) {
                for (int texX = 0; texX < 768; ++texX) {
                    float x = this.location.getXFunc().apply(texX, texY).floatValue();
                    float y = this.location.getYFunc().apply(texX, texY).floatValue();
                    float z = this.location.getZFunc().apply(texX, texY).floatValue();
                    this.skyNativeTex.m_84988_(this.location.getXLocation(texX), this.location.getYLocation(texY), this.painter.getTexelColour(x, y, z));
                }
            }
            this.latch.countDown();
        }

        public PaintTask(NativeImage skyNativeTex, SkyboxPainter painter, TextureLocation location, CountDownLatch latch) {
            this.skyNativeTex = skyNativeTex;
            this.painter = painter;
            this.location = location;
            this.latch = latch;
        }

        public static enum TextureLocation {
            TOP(CoordMap.X.getMap(), CoordMap.ONE.getMap(), CoordMap.Y.getMap(), 2, 0),
            BOTTOM(CoordMap.X.getMap(), CoordMap.NEG_ONE.getMap(), CoordMap.Y.getMap(), 2, 2),
            POS_Z(CoordMap.X.getMap(), CoordMap.Y.getMap(), CoordMap.ONE.getMap(), 1, 1),
            NEG_Z(CoordMap.X.getMap(), CoordMap.Y.getMap(), CoordMap.NEG_ONE.getMap(), 3, 1),
            POS_X(CoordMap.ONE.getMap(), CoordMap.Y.getMap(), CoordMap.X.getMap(), 2, 1),
            NEG_X(CoordMap.NEG_ONE.getMap(), CoordMap.Y.getMap(), CoordMap.X.getMap(), 0, 1);

            private final BiFunction<Integer, Integer, Float> xFunc;
            private final BiFunction<Integer, Integer, Float> yFunc;
            private final BiFunction<Integer, Integer, Float> zFunc;
            private final int shiftX;
            private final int shiftY;

            public int getXLocation(int texX) {
                return texX + this.shiftX * 768;
            }

            public int getYLocation(int texY) {
                return texY + this.shiftY * 768;
            }

            private TextureLocation(BiFunction<Integer, Integer, Float> xFunc, BiFunction<Integer, Integer, Float> yFunc, BiFunction<Integer, Integer, Float> zFunc, int shiftX, int shiftY) {
                this.xFunc = xFunc;
                this.yFunc = yFunc;
                this.zFunc = zFunc;
                this.shiftX = shiftX;
                this.shiftY = shiftY;
            }

            public BiFunction<Integer, Integer, Float> getXFunc() {
                return this.xFunc;
            }

            public BiFunction<Integer, Integer, Float> getYFunc() {
                return this.yFunc;
            }

            public BiFunction<Integer, Integer, Float> getZFunc() {
                return this.zFunc;
            }
        }

        private static enum CoordMap {
            X((texX, texY) -> Float.valueOf((float)texX.intValue() / 768.0f * 2.0f - 1.0f)),
            Y((texX, texY) -> Float.valueOf((float)texY.intValue() / 768.0f * 2.0f - 1.0f)),
            ONE((texX, texY) -> Float.valueOf(1.0f)),
            NEG_ONE((texX, texY) -> Float.valueOf(-1.0f));

            private final BiFunction<Integer, Integer, Float> map;

            public BiFunction<Integer, Integer, Float> getMap() {
                return this.map;
            }

            private CoordMap(BiFunction<Integer, Integer, Float> map) {
                this.map = map;
            }
        }
    }
}

