/*
 * Decompiled with CFR 0.152.
 */
package codes.ztereohype.nicerskies.sky.star;

import codes.ztereohype.nicerskies.core.Gradient;
import codes.ztereohype.nicerskies.sky.star.Star;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;

public class Starbox {
    private static final BufferBuilder STAR_BUFFER_BUILDER = Tesselator.m_85913_().m_85915_();
    private final List<Star> starList = new ArrayList<Star>();
    private final VertexBuffer starBuffer;

    public Starbox(RandomSource randomSource, Gradient starGradient, VertexBuffer starBuffer) {
        this.starBuffer = starBuffer;
        this.generateStars(randomSource, starGradient);
    }

    private void generateStars(RandomSource randomSource, Gradient starGradient) {
        this.starList.clear();
        ImprovedNoise noise = new ImprovedNoise(randomSource);
        int stars = 1500;
        for (int i = 0; i < stars; ++i) {
            float randX = randomSource.m_188501_() * 2.0f - 1.0f;
            float randY = randomSource.m_188501_() * 2.0f - 1.0f;
            float randZ = randomSource.m_188501_() * 2.0f - 1.0f;
            float resizeSpeed = 0.03f + randomSource.m_188501_() * 0.04f;
            float spinSpeed = randomSource.m_188501_() * 0.02f - 0.01f;
            int[] starColor = starGradient.getAt(randomSource.m_188501_());
            float starRadius = 0.15f + randomSource.m_188501_() * 0.15f;
            double starValue = noise.m_164308_((double)(randX * 2.5f), (double)(randY * 2.5f), (double)(randZ * 2.5f)) + 0.5;
            float squaredDistance = randX * randX + randY * randY + randZ * randZ;
            if ((double)squaredDistance < 1.0 && (double)squaredDistance > 0.01 && starValue > 0.2) {
                this.starList.add(new Star(randX, randY, randZ, starRadius, starColor, resizeSpeed, spinSpeed));
                continue;
            }
            --i;
        }
    }

    public void updateStars(int ticks) {
        STAR_BUFFER_BUILDER.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (Star star : this.starList) {
            star.tick(ticks);
            star.setVertices(STAR_BUFFER_BUILDER);
        }
        this.starBuffer.m_85921_();
        this.starBuffer.m_231221_(STAR_BUFFER_BUILDER.m_231175_());
    }
}

