/*
 * Decompiled with CFR 0.152.
 */
package elocindev.spopaccompat.mixin;

import java.util.List;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.spell_engine.utils.TargetHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.pac.common.server.api.OpenPACServerAPI;
import xaero.pac.common.server.parties.party.api.IPartyManagerAPI;
import xaero.pac.common.server.parties.party.api.IServerPartyAPI;

@Mixin(value={TargetHelper.class})
public class TargetHelperMixin {
    @Inject(at={@At(value="HEAD")}, method={"allowedToHurt"}, cancellable=true)
    private static void spellengineopacsupport$damageOpacLogic(Entity e1, Entity e2, CallbackInfoReturnable<Boolean> cir) {
        if (!TargetHelperMixin.checkOpac(e1, e2)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getRelation"}, cancellable=true)
    private static void spellengineopacsupport$relationOpacLogic(LivingEntity attacker, Entity target, CallbackInfoReturnable<TargetHelper.Relation> cir) {
        if (attacker == target || !TargetHelperMixin.checkOpac((Entity)attacker, target)) {
            cir.setReturnValue((Object)TargetHelper.Relation.FRIENDLY);
        }
    }

    private static boolean checkOpac(Entity attackerEntity, Entity targetEntity) {
        Player player;
        if (!(attackerEntity instanceof Player) || (player = (Player)attackerEntity).m_9236_().m_5776_() || !(targetEntity instanceof Player)) {
            return true;
        }
        Player target = (Player)targetEntity;
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return true;
        }
        UUID playerUUID = player.m_20148_();
        UUID targetUUID = target.m_20148_();
        try {
            List memberList;
            UUID targetPartyId;
            UUID playerPartyId;
            OpenPACServerAPI api = OpenPACServerAPI.get((MinecraftServer)server);
            IPartyManagerAPI partyManager = api.getPartyManager();
            IServerPartyAPI playerParty = partyManager.getPartyByMember(playerUUID);
            IServerPartyAPI targetParty = partyManager.getPartyByMember(targetUUID);
            if (playerParty != null && targetParty != null && !(playerPartyId = playerParty.getId()).equals(targetPartyId = targetParty.getId())) {
                return !playerParty.isAlly(targetPartyId);
            }
            if (playerParty != null && !(memberList = playerParty.getOnlineMemberStream().toList()).isEmpty() && target instanceof ServerPlayer) {
                ServerPlayer serverTarget = (ServerPlayer)target;
                return !memberList.contains(serverTarget);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }
}

