/*
 * Decompiled with CFR 0.152.
 */
package net.paladins;

import net.fabric_extras.structure_pool.api.StructurePoolConfig;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.paladins.block.PaladinBlocks;
import net.paladins.config.Default;
import net.paladins.config.ShieldsConfig;
import net.paladins.config.TweaksConfig;
import net.paladins.effect.Effects;
import net.paladins.entity.BannerEntity;
import net.paladins.entity.BarrierEntity;
import net.paladins.item.Group;
import net.paladins.item.PaladinBooks;
import net.paladins.item.Shields;
import net.paladins.item.Weapons;
import net.paladins.item.armor.Armors;
import net.paladins.util.SoundHelper;
import net.paladins.village.PaladinVillagers;
import net.spell_engine.api.item.ItemConfig;
import net.tinyconfig.ConfigManager;

public class PaladinsMod
implements ModInitializer {
    public static final String ID = "paladins";
    public static ConfigManager<ItemConfig> itemConfig = new ConfigManager("items_v5", (Object)Default.itemConfig).builder().setDirectory("paladins").sanitize(true).build();
    public static ConfigManager<ShieldsConfig> shieldConfig = new ConfigManager("shields", (Object)new ShieldsConfig()).builder().setDirectory("paladins").sanitize(true).build();
    public static ConfigManager<StructurePoolConfig> villageConfig = new ConfigManager("villages", (Object)Default.villageConfig).builder().setDirectory("paladins").sanitize(true).build();
    public static ConfigManager<TweaksConfig> tweaksConfig = new ConfigManager("tweaks", (Object)new TweaksConfig()).builder().setDirectory("paladins").sanitize(true).build();

    public void onInitialize() {
        itemConfig.refresh();
        shieldConfig.refresh();
        tweaksConfig.refresh();
        Group.PALADINS = FabricItemGroup.builder().m_257737_(() -> new ItemStack((ItemLike)Armors.paladinArmorSet_t2.head)).m_257941_((Component)Component.m_237115_((String)"itemGroup.paladins.general")).m_257652_();
        Registry.m_194579_((Registry)BuiltInRegistries.f_279662_, Group.KEY, (Object)Group.PALADINS);
        PaladinBlocks.register();
        PaladinBooks.register();
        Weapons.register(((ItemConfig)PaladinsMod.itemConfig.value).weapons);
        Shields.register(((ShieldsConfig)PaladinsMod.shieldConfig.value).shields);
        Armors.register(((ItemConfig)PaladinsMod.itemConfig.value).armor_sets);
        shieldConfig.save();
        itemConfig.save();
        villageConfig.refresh();
        Effects.register();
        PaladinVillagers.register();
        SoundHelper.registerSounds();
        this.subscribeEvents();
    }

    private void subscribeEvents() {
    }

    static {
        BarrierEntity.TYPE = (EntityType)Registry.m_122965_((Registry)BuiltInRegistries.f_256780_, (ResourceLocation)new ResourceLocation(ID, "barrier"), (Object)FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, BarrierEntity::new).dimensions(EntityDimensions.m_20398_((float)1.0f, (float)1.0f)).fireImmune().trackRangeBlocks(128).trackedUpdateRate(20).build());
        BannerEntity.ENTITY_TYPE = (EntityType)Registry.m_122965_((Registry)BuiltInRegistries.f_256780_, (ResourceLocation)new ResourceLocation(ID, "battle_banner"), (Object)FabricEntityTypeBuilder.create((MobCategory)MobCategory.MISC, BannerEntity::new).dimensions(EntityDimensions.m_20395_((float)6.0f, (float)0.5f)).fireImmune().trackRangeBlocks(128).trackedUpdateRate(20).build());
    }
}

